/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.focus.FocusEventModifierLocal;
import androidx.compose.ui.focus.FocusModifier;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.focus.FocusTransactionsKt;
import androidx.compose.ui.focus.TwoDimensionalFocusSearchKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.OwnerScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u0004*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\t\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0011"}, d2={"activateNode", "", "Landroidx/compose/ui/focus/FocusModifier;", "captureFocus", "", "clearChildFocus", "clearFocus", "forcedClear", "deactivateNode", "freeFocus", "grantFocus", "grantFocusToChild", "childNode", "requestFocus", "requestFocusForChild", "requestFocusForOwner", "sendOnFocusEvent", "ui"})
public final class FocusTransactionsKt {
    public static final void requestFocus(@NotNull FocusModifier $this$requestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$requestFocus, (String)"<this>");
        OwnerScope ownerScope = $this$requestFocus.getCoordinator();
        if ((ownerScope != null && (ownerScope = ((NodeCoordinator)ownerScope).getLayoutNode()) != null ? ((LayoutNode)ownerScope).getOwner$ui() : null) == null) {
            $this$requestFocus.setFocusRequestedOnPlaced(true);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$this$requestFocus.getFocusState().ordinal()]) {
            case 1: 
            case 2: {
                FocusTransactionsKt.sendOnFocusEvent($this$requestFocus);
                break;
            }
            case 3: {
                if (!FocusTransactionsKt.clearChildFocus($this$requestFocus)) break;
                FocusTransactionsKt.grantFocus($this$requestFocus);
                break;
            }
            case 4: 
            case 5: {
                TwoDimensionalFocusSearchKt.findChildCorrespondingToFocusEnter--OM-vw8($this$requestFocus, FocusDirection.Companion.getEnter-dhqQ-8s(), (Function1<? super FocusModifier, Boolean>)((Function1)requestFocus.1.INSTANCE));
                break;
            }
            case 6: {
                FocusModifier focusParent = $this$requestFocus.getParent();
                if (focusParent != null) {
                    FocusTransactionsKt.requestFocusForChild(focusParent, $this$requestFocus);
                    break;
                }
                if (!FocusTransactionsKt.requestFocusForOwner($this$requestFocus)) break;
                FocusTransactionsKt.grantFocus($this$requestFocus);
            }
        }
    }

    public static final void activateNode(@NotNull FocusModifier $this$activateNode) {
        Intrinsics.checkNotNullParameter((Object)$this$activateNode, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$activateNode.getFocusState().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                $this$activateNode.setFocusState(FocusStateImpl.Inactive);
                break;
            }
            case 5: {
                $this$activateNode.setFocusState(FocusStateImpl.ActiveParent);
            }
        }
    }

    public static final void deactivateNode(@NotNull FocusModifier $this$deactivateNode) {
        Intrinsics.checkNotNullParameter((Object)$this$deactivateNode, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$deactivateNode.getFocusState().ordinal()]) {
            case 3: {
                $this$deactivateNode.setFocusState(FocusStateImpl.DeactivatedParent);
                break;
            }
            case 1: 
            case 2: {
                Object object = $this$deactivateNode.getCoordinator();
                if (object != null && (object = ((NodeCoordinator)object).getLayoutNode()) != null && (object = ((LayoutNode)object).getOwner$ui()) != null && (object = object.getFocusManager()) != null) {
                    object.clearFocus(true);
                }
                $this$deactivateNode.setFocusState(FocusStateImpl.Deactivated);
                break;
            }
            case 6: {
                $this$deactivateNode.setFocusState(FocusStateImpl.Deactivated);
            }
        }
    }

    public static final boolean captureFocus(@NotNull FocusModifier $this$captureFocus) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$captureFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$captureFocus.getFocusState().ordinal()]) {
            case 1: {
                $this$captureFocus.setFocusState(FocusStateImpl.Captured);
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean freeFocus(@NotNull FocusModifier $this$freeFocus) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$freeFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$freeFocus.getFocusState().ordinal()]) {
            case 2: {
                $this$freeFocus.setFocusState(FocusStateImpl.Active);
                bl = true;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean clearFocus(@NotNull FocusModifier $this$clearFocus, boolean forcedClear) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$clearFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$clearFocus.getFocusState().ordinal()]) {
            case 1: {
                $this$clearFocus.setFocusState(FocusStateImpl.Inactive);
                bl = true;
                break;
            }
            case 3: {
                if (FocusTransactionsKt.clearChildFocus($this$clearFocus)) {
                    $this$clearFocus.setFocusState(FocusStateImpl.Inactive);
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                if (FocusTransactionsKt.clearChildFocus($this$clearFocus)) {
                    $this$clearFocus.setFocusState(FocusStateImpl.Deactivated);
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (forcedClear) {
                    $this$clearFocus.setFocusState(FocusStateImpl.Inactive);
                }
                bl = forcedClear;
                break;
            }
            case 4: 
            case 6: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean clearFocus$default(FocusModifier focusModifier2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FocusTransactionsKt.clearFocus(focusModifier2, bl);
    }

    private static final void grantFocus(FocusModifier $this$grantFocus) {
        FocusStateImpl focusStateImpl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$grantFocus.getFocusState().ordinal()]) {
            case 1: 
            case 3: 
            case 6: {
                focusStateImpl = FocusStateImpl.Active;
                break;
            }
            case 2: {
                focusStateImpl = FocusStateImpl.Captured;
                break;
            }
            case 4: 
            case 5: {
                throw new IllegalStateException("Granting focus to a deactivated node.".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$grantFocus.setFocusState(focusStateImpl);
    }

    private static final boolean grantFocusToChild(FocusModifier $this$grantFocusToChild, FocusModifier childNode) {
        $this$grantFocusToChild.setFocusedChild(childNode);
        FocusTransactionsKt.grantFocus(childNode);
        return true;
    }

    private static final boolean clearChildFocus(FocusModifier $this$clearChildFocus) {
        boolean bl;
        FocusModifier focusModifier2 = $this$clearChildFocus.getFocusedChild();
        if (focusModifier2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (FocusTransactionsKt.clearFocus$default(focusModifier2, false, 1, null)) {
            $this$clearChildFocus.setFocusedChild(null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean requestFocusForChild(FocusModifier $this$requestFocusForChild, FocusModifier childNode) {
        boolean bl;
        if (!$this$requestFocusForChild.getChildren().contains((Object)childNode)) {
            throw new IllegalStateException("Non child node cannot request focus.".toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$this$requestFocusForChild.getFocusState().ordinal()]) {
            case 1: {
                $this$requestFocusForChild.setFocusState(FocusStateImpl.ActiveParent);
                bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                break;
            }
            case 3: {
                if (FocusTransactionsKt.clearChildFocus($this$requestFocusForChild)) {
                    bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                if ($this$requestFocusForChild.getFocusedChild() == null) {
                    bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                    break;
                }
                if (FocusTransactionsKt.clearChildFocus($this$requestFocusForChild)) {
                    bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                FocusModifier focusParent = $this$requestFocusForChild.getParent();
                if (focusParent == null && FocusTransactionsKt.requestFocusForOwner($this$requestFocusForChild)) {
                    $this$requestFocusForChild.setFocusState(FocusStateImpl.Active);
                    bl = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                    break;
                }
                if (focusParent != null && FocusTransactionsKt.requestFocusForChild(focusParent, $this$requestFocusForChild)) {
                    bl = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            case 4: {
                void var2_3;
                FocusTransactionsKt.activateNode($this$requestFocusForChild);
                boolean childGrantedFocus = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                FocusTransactionsKt.deactivateNode($this$requestFocusForChild);
                bl = var2_3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean requestFocusForOwner(FocusModifier $this$requestFocusForOwner) {
        Object object = $this$requestFocusForOwner.getCoordinator();
        if (object == null || (object = ((NodeCoordinator)object).getLayoutNode()) == null || (object = ((LayoutNode)object).getOwner$ui()) == null) {
            throw new IllegalStateException("Owner not initialized.".toString());
        }
        return object.requestFocus();
    }

    public static final void sendOnFocusEvent(@NotNull FocusModifier $this$sendOnFocusEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$sendOnFocusEvent, (String)"<this>");
            FocusEventModifierLocal focusEventModifierLocal = $this$sendOnFocusEvent.getFocusEventListener();
            if (focusEventModifierLocal == null) break block0;
            focusEventModifierLocal.propagateFocusEvent();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FocusStateImpl.values().length];
            try {
                nArray[FocusStateImpl.Active.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.Captured.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.ActiveParent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.Deactivated.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.DeactivatedParent.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FocusStateImpl.Inactive.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

