/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.Nodes;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsNodeKt;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.semantics.SemanticsSortKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010D\u001a\u00020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00000GH\u0002J6\u0010H\u001a\u00020\u00002\b\u0010I\u001a\u0004\u0018\u00010J2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020E0L\u00a2\u0006\u0002\bNH\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\bOJ\r\u0010P\u001a\u00020QH\u0000\u00a2\u0006\u0002\bRJ(\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\u000e\b\u0002\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00000G2\b\b\u0002\u0010U\u001a\u00020\u0005H\u0002J\u000e\u0010V\u001a\u00020\u00192\u0006\u0010W\u001a\u00020XJ&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\u0006\u0010U\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\u0005H\u0002J\u0010\u0010[\u001a\u00020E2\u0006\u0010\\\u001a\u00020\u0014H\u0002J'\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\b\b\u0002\u0010U\u001a\u00020\u00052\b\b\u0002\u0010Z\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b]R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001eR\u0011\u0010\"\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010,\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u0002008F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u0002008F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b4\u00102R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0012R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0012R\u0013\u00109\u001a\u0004\u0018\u00010:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b?\u00102R\u0011\u0010@\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\fR\u0014\u0010B\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0016\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006^"}, d2={"Landroidx/compose/ui/semantics/SemanticsNode;", "", "outerSemanticsNode", "Landroidx/compose/ui/node/SemanticsModifierNode;", "mergingEnabled", "", "layoutNode", "Landroidx/compose/ui/node/LayoutNode;", "(Landroidx/compose/ui/node/SemanticsModifierNode;ZLandroidx/compose/ui/node/LayoutNode;)V", "boundsInRoot", "Landroidx/compose/ui/geometry/Rect;", "getBoundsInRoot", "()Landroidx/compose/ui/geometry/Rect;", "boundsInWindow", "getBoundsInWindow", "children", "", "getChildren", "()Ljava/util/List;", "config", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "getConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", "fakeNodeParent", "id", "", "getId", "()I", "isFake", "isFake$ui", "()Z", "setFake$ui", "(Z)V", "isMergingSemanticsOfDescendants", "isRoot", "layoutInfo", "Landroidx/compose/ui/layout/LayoutInfo;", "getLayoutInfo", "()Landroidx/compose/ui/layout/LayoutInfo;", "getLayoutNode$ui", "()Landroidx/compose/ui/node/LayoutNode;", "getMergingEnabled", "getOuterSemanticsNode$ui", "()Landroidx/compose/ui/node/SemanticsModifierNode;", "parent", "getParent", "()Landroidx/compose/ui/semantics/SemanticsNode;", "positionInRoot", "Landroidx/compose/ui/geometry/Offset;", "getPositionInRoot-F1C5BW0", "()J", "positionInWindow", "getPositionInWindow-F1C5BW0", "replacedChildren", "getReplacedChildren$ui", "replacedChildrenSortedByBounds", "getReplacedChildrenSortedByBounds$ui", "root", "Landroidx/compose/ui/node/RootForTest;", "getRoot", "()Landroidx/compose/ui/node/RootForTest;", "size", "Landroidx/compose/ui/unit/IntSize;", "getSize-YbymL2g", "touchBoundsInRoot", "getTouchBoundsInRoot", "unmergedConfig", "getUnmergedConfig$ui", "emitFakeNodes", "", "unmergedChildren", "", "fakeSemanticsNode", "role", "Landroidx/compose/ui/semantics/Role;", "properties", "Lkotlin/Function1;", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "Lkotlin/ExtensionFunctionType;", "fakeSemanticsNode-ypyhhiA", "findCoordinatorToGetBounds", "Landroidx/compose/ui/node/NodeCoordinator;", "findCoordinatorToGetBounds$ui", "findOneLayerOfMergingSemanticsNodes", "list", "sortByBounds", "getAlignmentLinePosition", "alignmentLine", "Landroidx/compose/ui/layout/AlignmentLine;", "includeReplacedSemantics", "includeFakeNodes", "mergeConfig", "mergedConfig", "unmergedChildren$ui", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSemanticsNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsNode.kt\nandroidx/compose/ui/semantics/SemanticsNode\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,462:1\n33#2,6:463\n33#2,6:469\n33#2,6:475\n*S KotlinDebug\n*F\n+ 1 SemanticsNode.kt\nandroidx/compose/ui/semantics/SemanticsNode\n*L\n189#1:463,6\n216#1:469,6\n333#1:475,6\n*E\n"})
public final class SemanticsNode {
    @NotNull
    private final SemanticsModifierNode outerSemanticsNode;
    private final boolean mergingEnabled;
    @NotNull
    private final LayoutNode layoutNode;
    private boolean isFake;
    @Nullable
    private SemanticsNode fakeNodeParent;
    @NotNull
    private final SemanticsConfiguration unmergedConfig;
    private final int id;
    public static final int $stable = 8;

    public SemanticsNode(@NotNull SemanticsModifierNode outerSemanticsNode, boolean mergingEnabled, @NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)outerSemanticsNode, (String)"outerSemanticsNode");
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.outerSemanticsNode = outerSemanticsNode;
        this.mergingEnabled = mergingEnabled;
        this.layoutNode = layoutNode;
        this.unmergedConfig = SemanticsModifierNodeKt.collapsedSemanticsConfiguration(this.outerSemanticsNode);
        this.id = this.layoutNode.getSemanticsId();
    }

    public /* synthetic */ SemanticsNode(SemanticsModifierNode semanticsModifierNode, boolean bl, LayoutNode layoutNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            layoutNode = DelegatableNodeKt.requireLayoutNode(semanticsModifierNode);
        }
        this(semanticsModifierNode, bl, layoutNode);
    }

    @NotNull
    public final SemanticsModifierNode getOuterSemanticsNode$ui() {
        return this.outerSemanticsNode;
    }

    public final boolean getMergingEnabled() {
        return this.mergingEnabled;
    }

    @NotNull
    public final LayoutNode getLayoutNode$ui() {
        return this.layoutNode;
    }

    public final boolean isFake$ui() {
        return this.isFake;
    }

    public final void setFake$ui(boolean bl) {
        this.isFake = bl;
    }

    @NotNull
    public final SemanticsConfiguration getUnmergedConfig$ui() {
        return this.unmergedConfig;
    }

    @NotNull
    public final LayoutInfo getLayoutInfo() {
        return this.layoutNode;
    }

    @Nullable
    public final RootForTest getRoot() {
        Owner owner = this.layoutNode.getOwner$ui();
        return owner != null ? owner.getRootForTest() : null;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final Rect getTouchBoundsInRoot() {
        SemanticsModifierNode semanticsModifierNode;
        if (this.unmergedConfig.isMergingSemanticsOfDescendants()) {
            semanticsModifierNode = SemanticsNodeKt.getOuterMergingSemantics(this.layoutNode);
            if (semanticsModifierNode == null) {
                semanticsModifierNode = this.outerSemanticsNode;
            }
        } else {
            semanticsModifierNode = this.outerSemanticsNode;
        }
        SemanticsModifierNode entity = semanticsModifierNode;
        return SemanticsModifierNodeKt.touchBoundsInRoot(entity);
    }

    public final long getSize-YbymL2g() {
        return this.findCoordinatorToGetBounds$ui().getSize-YbymL2g();
    }

    @NotNull
    public final Rect getBoundsInRoot() {
        if (!this.layoutNode.isAttached()) {
            return Rect.Companion.getZero();
        }
        return LayoutCoordinatesKt.boundsInRoot(this.findCoordinatorToGetBounds$ui());
    }

    public final long getPositionInRoot-F1C5BW0() {
        if (!this.layoutNode.isAttached()) {
            return Offset.Companion.getZero-F1C5BW0();
        }
        return LayoutCoordinatesKt.positionInRoot(this.findCoordinatorToGetBounds$ui());
    }

    @NotNull
    public final Rect getBoundsInWindow() {
        if (!this.layoutNode.isAttached()) {
            return Rect.Companion.getZero();
        }
        return LayoutCoordinatesKt.boundsInWindow(this.findCoordinatorToGetBounds$ui());
    }

    public final long getPositionInWindow-F1C5BW0() {
        if (!this.layoutNode.isAttached()) {
            return Offset.Companion.getZero-F1C5BW0();
        }
        return LayoutCoordinatesKt.positionInWindow(this.findCoordinatorToGetBounds$ui());
    }

    public final int getAlignmentLinePosition(@NotNull AlignmentLine alignmentLine) {
        Intrinsics.checkNotNullParameter((Object)alignmentLine, (String)"alignmentLine");
        return this.findCoordinatorToGetBounds$ui().get(alignmentLine);
    }

    @NotNull
    public final SemanticsConfiguration getConfig() {
        if (this.isMergingSemanticsOfDescendants()) {
            SemanticsConfiguration mergedConfig = this.unmergedConfig.copy();
            this.mergeConfig(mergedConfig);
            return mergedConfig;
        }
        return this.unmergedConfig;
    }

    private final void mergeConfig(SemanticsConfiguration mergedConfig) {
        if (!this.unmergedConfig.isClearingSemantics()) {
            List $this$fastForEach$iv = SemanticsNode.unmergedChildren$ui$default(this, false, false, 3, null);
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                SemanticsNode child = (SemanticsNode)item$iv;
                boolean bl = false;
                if (child.isMergingSemanticsOfDescendants()) continue;
                mergedConfig.mergeChild$ui(child.unmergedConfig);
                child.mergeConfig(mergedConfig);
            }
        }
    }

    private final boolean isMergingSemanticsOfDescendants() {
        return this.mergingEnabled && this.unmergedConfig.isMergingSemanticsOfDescendants();
    }

    @NotNull
    public final List<SemanticsNode> unmergedChildren$ui(boolean sortByBounds, boolean includeFakeNodes) {
        List semanticsChildren;
        if (this.isFake) {
            return CollectionsKt.emptyList();
        }
        List unmergedChildren = new ArrayList();
        List $this$fastForEach$iv = semanticsChildren = sortByBounds ? SemanticsSortKt.findOneLayerOfSemanticsWrappersSortedByBounds$default(this.layoutNode, null, 1, null) : SemanticsNodeKt.findOneLayerOfSemanticsWrappers$default(this.layoutNode, null, 1, null);
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            SemanticsModifierNode semanticsChild = (SemanticsModifierNode)item$iv;
            boolean bl = false;
            unmergedChildren.add(new SemanticsNode(semanticsChild, this.mergingEnabled, null, 4, null));
        }
        if (includeFakeNodes) {
            this.emitFakeNodes(unmergedChildren);
        }
        return unmergedChildren;
    }

    public static /* synthetic */ List unmergedChildren$ui$default(SemanticsNode semanticsNode, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return semanticsNode.unmergedChildren$ui(bl, bl2);
    }

    @NotNull
    public final List<SemanticsNode> getChildren() {
        return this.getChildren(false, !this.mergingEnabled, false);
    }

    @NotNull
    public final List<SemanticsNode> getReplacedChildren$ui() {
        return this.getChildren(false, false, true);
    }

    @NotNull
    public final List<SemanticsNode> getReplacedChildrenSortedByBounds$ui() {
        return this.getChildren(true, false, true);
    }

    private final List<SemanticsNode> getChildren(boolean sortByBounds, boolean includeReplacedSemantics, boolean includeFakeNodes) {
        if (!includeReplacedSemantics && this.unmergedConfig.isClearingSemantics()) {
            return CollectionsKt.emptyList();
        }
        if (this.isMergingSemanticsOfDescendants()) {
            return SemanticsNode.findOneLayerOfMergingSemanticsNodes$default(this, null, sortByBounds, 1, null);
        }
        return this.unmergedChildren$ui(sortByBounds, includeFakeNodes);
    }

    public final boolean isRoot() {
        return this.getParent() == null;
    }

    @Nullable
    public final SemanticsNode getParent() {
        SemanticsModifierNode outerSemantics;
        if (this.fakeNodeParent != null) {
            return this.fakeNodeParent;
        }
        LayoutNode node = null;
        if (this.mergingEnabled) {
            node = SemanticsNodeKt.access$findClosestParentNode(this.layoutNode, parent.1.INSTANCE);
        }
        if (node == null) {
            node = SemanticsNodeKt.access$findClosestParentNode(this.layoutNode, parent.2.INSTANCE);
        }
        LayoutNode layoutNode = node;
        SemanticsModifierNode semanticsModifierNode = outerSemantics = layoutNode != null ? SemanticsNodeKt.getOuterSemantics(layoutNode) : null;
        if (outerSemantics == null) {
            return null;
        }
        return new SemanticsNode(outerSemantics, this.mergingEnabled, null, 4, null);
    }

    private final List<SemanticsNode> findOneLayerOfMergingSemanticsNodes(List<SemanticsNode> list, boolean sortByBounds) {
        List $this$fastForEach$iv = SemanticsNode.unmergedChildren$ui$default(this, sortByBounds, false, 2, null);
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            SemanticsNode child = (SemanticsNode)item$iv;
            boolean bl = false;
            if (child.isMergingSemanticsOfDescendants()) {
                list.add(child);
                continue;
            }
            if (child.unmergedConfig.isClearingSemantics()) continue;
            SemanticsNode.findOneLayerOfMergingSemanticsNodes$default(child, list, false, 2, null);
        }
        return list;
    }

    static /* synthetic */ List findOneLayerOfMergingSemanticsNodes$default(SemanticsNode semanticsNode, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return semanticsNode.findOneLayerOfMergingSemanticsNodes(list, bl);
    }

    @NotNull
    public final NodeCoordinator findCoordinatorToGetBounds$ui() {
        NodeCoordinator nodeCoordinator;
        if (this.unmergedConfig.isMergingSemanticsOfDescendants()) {
            SemanticsModifierNode semanticsModifierNode = SemanticsNodeKt.getOuterMergingSemantics(this.layoutNode);
            if (semanticsModifierNode == null) {
                semanticsModifierNode = this.outerSemanticsNode;
            }
            nodeCoordinator = DelegatableNodeKt.requireCoordinator-64DMado(semanticsModifierNode, Nodes.INSTANCE.getSemantics-OLwlOKw());
        } else {
            nodeCoordinator = DelegatableNodeKt.requireCoordinator-64DMado(this.outerSemanticsNode, Nodes.INSTANCE.getSemantics-OLwlOKw());
        }
        return nodeCoordinator;
    }

    private final void emitFakeNodes(List<SemanticsNode> unmergedChildren) {
        Role nodeRole = SemanticsNodeKt.access$getRole(this);
        if (nodeRole != null && this.unmergedConfig.isMergingSemanticsOfDescendants() && !((Collection)unmergedChildren).isEmpty()) {
            SemanticsNode fakeNode2 = this.fakeSemanticsNode-ypyhhiA(nodeRole, (Function1<? super SemanticsPropertyReceiver, Unit>)((Function1)new Function1<SemanticsPropertyReceiver, Unit>(nodeRole){
                final /* synthetic */ Role $nodeRole;
                {
                    this.$nodeRole = $nodeRole;
                    super(1);
                }

                public final void invoke(@NotNull SemanticsPropertyReceiver $this$fakeSemanticsNode) {
                    Intrinsics.checkNotNullParameter((Object)$this$fakeSemanticsNode, (String)"$this$fakeSemanticsNode");
                    SemanticsPropertiesKt.setRole-kuIjeqM($this$fakeSemanticsNode, this.$nodeRole.unbox-impl());
                }
            }));
            unmergedChildren.add(fakeNode2);
        }
        if (this.unmergedConfig.contains(SemanticsProperties.INSTANCE.getContentDescription()) && !((Collection)unmergedChildren).isEmpty() && this.unmergedConfig.isMergingSemanticsOfDescendants()) {
            String contentDescription;
            List<String> list = SemanticsConfigurationKt.getOrNull(this.unmergedConfig, SemanticsProperties.INSTANCE.getContentDescription());
            String string = contentDescription = list != null ? (String)CollectionsKt.firstOrNull(list) : null;
            if (contentDescription != null) {
                SemanticsNode fakeNode3 = this.fakeSemanticsNode-ypyhhiA(null, (Function1<? super SemanticsPropertyReceiver, Unit>)((Function1)new Function1<SemanticsPropertyReceiver, Unit>(contentDescription){
                    final /* synthetic */ String $contentDescription;
                    {
                        this.$contentDescription = $contentDescription;
                        super(1);
                    }

                    public final void invoke(@NotNull SemanticsPropertyReceiver $this$fakeSemanticsNode) {
                        Intrinsics.checkNotNullParameter((Object)$this$fakeSemanticsNode, (String)"$this$fakeSemanticsNode");
                        SemanticsPropertiesKt.setContentDescription($this$fakeSemanticsNode, this.$contentDescription);
                    }
                }));
                unmergedChildren.add(0, fakeNode3);
            }
        }
    }

    private final SemanticsNode fakeSemanticsNode-ypyhhiA(Role role, Function1<? super SemanticsPropertyReceiver, Unit> properties) {
        SemanticsNode fakeNode2 = new SemanticsNode(new SemanticsModifierNode(properties){
            @NotNull
            private final SemanticsConfiguration semanticsConfiguration;
            {
                void it;
                SemanticsConfiguration semanticsConfiguration;
                SemanticsConfiguration semanticsConfiguration2 = semanticsConfiguration = new SemanticsConfiguration();
                fakeSemanticsNode.fakeNode.1 var5_4 = this;
                boolean bl = false;
                it.setMergingSemanticsOfDescendants(false);
                it.setClearingSemantics(false);
                $properties.invoke((Object)it);
                var5_4.semanticsConfiguration = semanticsConfiguration;
            }

            @NotNull
            public SemanticsConfiguration getSemanticsConfiguration() {
                return this.semanticsConfiguration;
            }
        }, false, new LayoutNode(true, role != null ? SemanticsNodeKt.access$roleFakeNodeId(this) : SemanticsNodeKt.access$contentDescriptionFakeNodeId(this)));
        fakeNode2.isFake = true;
        fakeNode2.fakeNodeParent = this;
        return fakeNode2;
    }
}

