/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ComposeScene;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.awt.ComposeLayer;
import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.awt.LocalLayerContainer_desktopKt;
import androidx.compose.ui.awt.Utils_desktopKt;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.window.WindowExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipComponent;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0012\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\b\u0010(\u001a\u00020\nH\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\nH\u0016J\b\u0010,\u001a\u00020\u0012H\u0002J\b\u0010-\u001a\u00020\nH\u0016J\b\u0010.\u001a\u00020\nH\u0016J\b\u0010/\u001a\u00020\nH\u0016J\u0010\u00100\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0012\u00101\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010\bH\u0016J\b\u00102\u001a\u00020\u0012H\u0016J\b\u00103\u001a\u00020\u0012H\u0016J\u0012\u00103\u001a\u00020\u00122\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0010\u00103\u001a\u00020\n2\u0006\u00106\u001a\u00020\nH\u0016J\b\u00107\u001a\u00020\nH\u0016J\u0012\u00107\u001a\u00020\n2\b\u00104\u001a\u0004\u0018\u000105H\u0016J(\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020:H\u0016J\u001e\u0010>\u001a\u00020\u00122\u0011\u0010\u0010\u001a\r\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\nH\u0016J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020\nH\u0016J\u0010\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\nH\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000f\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R0\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Landroidx/compose/ui/awt/ComposePanel;", "Ljavax/swing/JLayeredPane;", "()V", "skiaLayerAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "_focusListeners", "", "Ljava/awt/event/FocusListener;", "_isFocusable", "", "_isRequestFocusEnabled", "clipMap", "", "Ljava/awt/Component;", "Lorg/jetbrains/skiko/ClipComponent;", "content", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "Lkotlin/jvm/functions/Function2;", "value", "Landroidx/compose/ui/window/WindowExceptionHandler;", "exceptionHandler", "getExceptionHandler$annotations", "getExceptionHandler", "()Landroidx/compose/ui/window/WindowExceptionHandler;", "setExceptionHandler", "(Landroidx/compose/ui/window/WindowExceptionHandler;)V", "layer", "Landroidx/compose/ui/awt/ComposeLayer;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "add", "component", "addFocusListener", "l", "addNotify", "getFocusTraversalKeysEnabled", "getPreferredSize", "Ljava/awt/Dimension;", "hasFocus", "initContent", "isFocusOwner", "isFocusable", "isRequestFocusEnabled", "remove", "removeFocusListener", "removeNotify", "requestFocus", "cause", "Ljava/awt/event/FocusEvent$Cause;", "temporary", "requestFocusInWindow", "setBounds", "x", "", "y", "width", "height", "setContent", "(Lkotlin/jvm/functions/Function2;)V", "setFocusTraversalKeysEnabled", "focusTraversalKeysEnabled", "setFocusable", "focusable", "setRequestFocusEnabled", "requestFocusEnabled", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposePanel.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1855#2,2:263\n*S KotlinDebug\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n*L\n157#1:263,2\n*E\n"})
public final class ComposePanel
extends JLayeredPane {
    @NotNull
    private final SkiaLayerAnalytics skiaLayerAnalytics;
    @NotNull
    private final Set<FocusListener> _focusListeners;
    private boolean _isFocusable;
    private boolean _isRequestFocusEnabled;
    @Nullable
    private ComposeLayer layer;
    @NotNull
    private final Map<Component, ClipComponent> clipMap;
    @Nullable
    private Function2<? super Composer, ? super Integer, Unit> content;
    @Nullable
    private WindowExceptionHandler exceptionHandler;
    public static final int $stable = 8;

    @ExperimentalComposeUiApi
    public ComposePanel(@NotNull SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"skiaLayerAnalytics");
        this.skiaLayerAnalytics = skiaLayerAnalytics;
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "ComposePanel should be created inside AWT Event Dispatch Thread (use SwingUtilities.invokeLater).\nCreating from another thread isn't supported.";
            throw new IllegalStateException(string.toString());
        }
        this.setBackground(Color.white);
        this.setLayout(null);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            @NotNull
            public Component getComponentAfter(@Nullable Container aContainer, @Nullable Component aComponent) {
                Container ancestor = this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = ancestor.getFocusTraversalPolicy();
                Component component = policy.getComponentAfter(ancestor, this);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"policy.getComponentAfter\u2026estor, this@ComposePanel)");
                return component;
            }

            @Override
            @NotNull
            public Component getComponentBefore(@Nullable Container aContainer, @Nullable Component aComponent) {
                Container ancestor = this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = ancestor.getFocusTraversalPolicy();
                Component component = policy.getComponentBefore(ancestor, this);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"policy.getComponentBefor\u2026estor, this@ComposePanel)");
                return component;
            }

            @Nullable
            public Void getFirstComponent(@Nullable Container aContainer) {
                return null;
            }

            @Nullable
            public Void getLastComponent(@Nullable Container aContainer) {
                return null;
            }

            @Nullable
            public Void getDefaultComponent(@Nullable Container aContainer) {
                return null;
            }
        });
        this.setFocusCycleRoot(true);
        this._focusListeners = new LinkedHashSet();
        this._isFocusable = true;
        this.clipMap = new LinkedHashMap();
    }

    public ComposePanel() {
        this(SkiaLayerAnalytics.Companion.getEmpty());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        ComposeLayer composeLayer = this.layer;
        if (composeLayer != null && (composeLayer = composeLayer.getComponent()) != null) {
            composeLayer.setSize(width, height);
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        ComposeLayer composeLayer;
        return this.isPreferredSizeSet() ? super.getPreferredSize() : ((composeLayer = this.layer) != null && (composeLayer = composeLayer.getComponent()) != null ? composeLayer.getPreferredSize() : null);
    }

    public final void setContent(@NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.content = content;
        this.initContent();
    }

    @Nullable
    public final WindowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void setExceptionHandler(@Nullable WindowExceptionHandler value) {
        this.exceptionHandler = value;
        ComposeLayer composeLayer = this.layer;
        if (composeLayer != null) {
            composeLayer.setExceptionHandler(value);
        }
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getExceptionHandler$annotations() {
    }

    private final void initContent() {
        if (this.layer != null && this.content != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            ComposeLayer.setContent$default(composeLayer, null, null, (Function2)ComposableLambdaKt.composableLambdaInstance((int)-991691413, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this){
                final /* synthetic */ ComposePanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @Composable
                public final void invoke(@Nullable Composer $composer, int $changed) {
                    ComposerKt.sourceInformation((Composer)$composer, (String)"C121@4919L138:ComposePanel.desktop.kt#ccs55x");
                    if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)-991691413, (int)$changed, (int)-1, (String)"androidx.compose.ui.awt.ComposePanel.initContent.<anonymous> (ComposePanel.desktop.kt:120)");
                        }
                        ProvidedValue[] providedValueArray = new ProvidedValue[]{LocalLayerContainer_desktopKt.getLocalLayerContainer().provides((Object)this.this$0)};
                        Function2 function2 = ComposePanel.access$getContent$p(this.this$0);
                        Intrinsics.checkNotNull((Object)function2);
                        CompositionLocalKt.CompositionLocalProvider((ProvidedValue[])providedValueArray, (Function2)function2, (Composer)$composer, (int)8);
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }), 3, null);
        }
    }

    @Override
    @NotNull
    public Component add(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.layer == null) {
            return component;
        }
        ClipComponent clipComponent = new ClipComponent(component);
        this.clipMap.put(component, clipComponent);
        ComposeLayer composeLayer = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer);
        composeLayer.getComponent().getClipComponents().add(clipComponent);
        Component component2 = super.add(component, 0);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"super.add(component, Integer.valueOf(0))");
        return component2;
    }

    @Override
    public void remove(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ComposeLayer composeLayer = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer);
        List list = composeLayer.getComponent().getClipComponents();
        ClipComponent clipComponent = this.clipMap.get(component);
        Intrinsics.checkNotNull((Object)clipComponent);
        list.remove(clipComponent);
        this.clipMap.remove(component);
        super.remove(component);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addNotify() {
        void $this$forEach$iv;
        void $this$addNotify_u24lambda_u241;
        ComposeLayer composeLayer;
        super.addNotify();
        ComposeLayer composeLayer2 = composeLayer = new ComposeLayer(this.skiaLayerAnalytics);
        ComposePanel composePanel = this;
        boolean bl = false;
        $this$addNotify_u24lambda_u241.getScene$ui().releaseFocus();
        $this$addNotify_u24lambda_u241.getComponent().setSize(this.getWidth(), this.getHeight());
        $this$addNotify_u24lambda_u241.getComponent().setFocusable(this._isFocusable);
        $this$addNotify_u24lambda_u241.getComponent().setRequestFocusEnabled(this._isRequestFocusEnabled);
        Iterable iterable = this._focusListeners;
        SkiaLayer skiaLayer = $this$addNotify_u24lambda_u241.getComponent();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FocusListener p0 = (FocusListener)element$iv;
            boolean bl2 = false;
            skiaLayer.addFocusListener(p0);
        }
        $this$addNotify_u24lambda_u241.setExceptionHandler(this.exceptionHandler);
        $this$addNotify_u24lambda_u241.getComponent().addFocusListener(new FocusListener(this){
            final /* synthetic */ ComposePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!Utils_desktopKt.isParentOf(this.this$0, e.getOppositeComponent())) {
                    Object object = ComposePanel.access$getLayer$p(this.this$0);
                    if (object != null && (object = ((ComposeLayer)object).getScene$ui()) != null) {
                        ((ComposeScene)object).requestFocus();
                    }
                    FocusEvent.Cause cause = e.getCause();
                    switch (cause == null ? -1 : addNotify.1.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: {
                            Object object2 = ComposePanel.access$getLayer$p(this.this$0);
                            if (object2 != null && (object2 = ((ComposeLayer)object2).getScene$ui()) != null) {
                                ((ComposeScene)object2).moveFocus-3ESFkO8(FocusDirection.Companion.getNext-dhqQ-8s());
                            }
                            break;
                        }
                        case 2: {
                            Object object3 = ComposePanel.access$getLayer$p(this.this$0);
                            if (object3 != null && (object3 = ((ComposeLayer)object3).getScene$ui()) != null) {
                                ((ComposeScene)object3).moveFocus-3ESFkO8(FocusDirection.Companion.getPrevious-dhqQ-8s());
                            }
                            break;
                        }
                    }
                }
            }

            public void focusLost(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        composePanel.layer = composeLayer;
        this.initContent();
        ComposeLayer composeLayer3 = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer3);
        super.add((Component)composeLayer3.getComponent(), 1);
    }

    @Override
    public void removeNotify() {
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            composeLayer.dispose();
            ComposeLayer composeLayer2 = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer2);
            super.remove((Component)composeLayer2.getComponent());
            this.layer = null;
        }
        super.removeNotify();
    }

    @Override
    public void addFocusListener(@Nullable FocusListener l) {
        ComposeLayer composeLayer = this.layer;
        if (composeLayer != null && (composeLayer = composeLayer.getComponent()) != null) {
            composeLayer.addFocusListener(l);
        }
        this._focusListeners.add(l);
    }

    @Override
    public void removeFocusListener(@Nullable FocusListener l) {
        ComposeLayer composeLayer = this.layer;
        if (composeLayer != null && (composeLayer = composeLayer.getComponent()) != null) {
            composeLayer.removeFocusListener(l);
        }
        this._focusListeners.remove(l);
    }

    @Override
    public boolean isFocusable() {
        return this._isFocusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this._isFocusable = focusable;
        ComposeLayer composeLayer = this.layer;
        Object object = composeLayer != null ? composeLayer.getComponent() : null;
        if (object != null) {
            object.setFocusable(focusable);
        }
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return this._isRequestFocusEnabled;
    }

    @Override
    public void setRequestFocusEnabled(boolean requestFocusEnabled) {
        this._isRequestFocusEnabled = requestFocusEnabled;
        ComposeLayer composeLayer = this.layer;
        Object object = composeLayer != null ? composeLayer.getComponent() : null;
        if (object != null) {
            object.setRequestFocusEnabled(requestFocusEnabled);
        }
    }

    @Override
    public boolean hasFocus() {
        ComposeLayer composeLayer = this.layer;
        return composeLayer != null && (composeLayer = composeLayer.getComponent()) != null ? composeLayer.hasFocus() : false;
    }

    @Override
    public boolean isFocusOwner() {
        ComposeLayer composeLayer = this.layer;
        return composeLayer != null && (composeLayer = composeLayer.getComponent()) != null ? composeLayer.isFocusOwner() : false;
    }

    @Override
    public void requestFocus() {
        block0: {
            ComposeLayer composeLayer = this.layer;
            if (composeLayer == null || (composeLayer = composeLayer.getComponent()) == null) break block0;
            composeLayer.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        ComposeLayer composeLayer = this.layer;
        return composeLayer != null && (composeLayer = composeLayer.getComponent()) != null ? composeLayer.requestFocus(temporary) : false;
    }

    @Override
    public void requestFocus(@Nullable FocusEvent.Cause cause) {
        block0: {
            ComposeLayer composeLayer = this.layer;
            if (composeLayer == null || (composeLayer = composeLayer.getComponent()) == null) break block0;
            composeLayer.requestFocus(cause);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        ComposeLayer composeLayer = this.layer;
        return composeLayer != null && (composeLayer = composeLayer.getComponent()) != null ? composeLayer.requestFocusInWindow() : false;
    }

    @Override
    public boolean requestFocusInWindow(@Nullable FocusEvent.Cause cause) {
        ComposeLayer composeLayer = this.layer;
        return composeLayer != null && (composeLayer = composeLayer.getComponent()) != null ? composeLayer.requestFocusInWindow(cause) : false;
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        GraphicsApi graphicsApi;
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            graphicsApi = composeLayer.getComponent().getRenderApi();
        } else {
            graphicsApi = GraphicsApi.UNKNOWN;
        }
        return graphicsApi;
    }

    public static final /* synthetic */ Function2 access$getContent$p(ComposePanel $this) {
        return $this.content;
    }

    public static final /* synthetic */ ComposeLayer access$getLayer$p(ComposePanel $this) {
        return $this.layer;
    }
}

