/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathMeasure;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.graphics.vector.PathComponent;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParser;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010R\u001a\u00020\u0014H\u0016J\b\u0010S\u001a\u00020TH\u0002J\b\u0010U\u001a\u00020TH\u0002J\f\u0010V\u001a\u00020T*\u00020WH\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R/\u0010&\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020%@FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001b\u0010,\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R\u000e\u00102\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00103\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0007\"\u0004\b5\u0010\tR$\u00106\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u000fR/\u0010:\u001a\u0002092\u0006\u0010\u0003\u001a\u000209@FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b;\u0010(\"\u0004\b<\u0010*R/\u0010>\u001a\u00020=2\u0006\u0010\u0003\u001a\u00020=@FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b?\u0010(\"\u0004\b@\u0010*R$\u0010A\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\r\"\u0004\bC\u0010\u000fR$\u0010D\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\r\"\u0004\bF\u0010\u000fR\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010I\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\r\"\u0004\bK\u0010\u000fR$\u0010L\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\r\"\u0004\bN\u0010\u000fR$\u0010O\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\r\"\u0004\bQ\u0010\u000f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006X"}, d2={"Landroidx/compose/ui/graphics/vector/PathComponent;", "Landroidx/compose/ui/graphics/vector/VNode;", "()V", "value", "Landroidx/compose/ui/graphics/Brush;", "fill", "getFill", "()Landroidx/compose/ui/graphics/Brush;", "setFill", "(Landroidx/compose/ui/graphics/Brush;)V", "", "fillAlpha", "getFillAlpha", "()F", "setFillAlpha", "(F)V", "isPathDirty", "", "isStrokeDirty", "isTrimPathDirty", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "parser", "Landroidx/compose/ui/graphics/vector/PathParser;", "path", "Landroidx/compose/ui/graphics/Path;", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "pathData", "getPathData", "()Ljava/util/List;", "setPathData", "(Ljava/util/List;)V", "Landroidx/compose/ui/graphics/PathFillType;", "pathFillType", "getPathFillType-Rg-k1Os", "()I", "setPathFillType-oQ8Xj4U", "(I)V", "I", "pathMeasure", "Landroidx/compose/ui/graphics/PathMeasure;", "getPathMeasure", "()Landroidx/compose/ui/graphics/PathMeasure;", "pathMeasure$delegate", "Lkotlin/Lazy;", "renderPath", "stroke", "getStroke", "setStroke", "strokeAlpha", "getStrokeAlpha", "setStrokeAlpha", "Landroidx/compose/ui/graphics/StrokeCap;", "strokeLineCap", "getStrokeLineCap-KaPHkGw", "setStrokeLineCap-BeK7IIE", "Landroidx/compose/ui/graphics/StrokeJoin;", "strokeLineJoin", "getStrokeLineJoin-LxFBmk8", "setStrokeLineJoin-Ww9F2mQ", "strokeLineMiter", "getStrokeLineMiter", "setStrokeLineMiter", "strokeLineWidth", "getStrokeLineWidth", "setStrokeLineWidth", "strokeStyle", "Landroidx/compose/ui/graphics/drawscope/Stroke;", "trimPathEnd", "getTrimPathEnd", "setTrimPathEnd", "trimPathOffset", "getTrimPathOffset", "setTrimPathOffset", "trimPathStart", "getTrimPathStart", "setTrimPathStart", "toString", "updatePath", "", "updateRenderPath", "draw", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "ui"})
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/PathComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,555:1\n1#2:556\n*E\n"})
public final class PathComponent
extends VNode {
    @NotNull
    private String name = "";
    @Nullable
    private Brush fill;
    private float fillAlpha = 1.0f;
    @NotNull
    private List<? extends PathNode> pathData = VectorKt.getEmptyPath();
    private int pathFillType = VectorKt.getDefaultFillType();
    private float strokeAlpha = 1.0f;
    private float strokeLineWidth;
    @Nullable
    private Brush stroke;
    private int strokeLineCap = VectorKt.getDefaultStrokeLineCap();
    private int strokeLineJoin = VectorKt.getDefaultStrokeLineJoin();
    private float strokeLineMiter = 4.0f;
    private float trimPathStart;
    private float trimPathEnd = 1.0f;
    private float trimPathOffset;
    private boolean isPathDirty = true;
    private boolean isStrokeDirty = true;
    private boolean isTrimPathDirty = true;
    @Nullable
    private Stroke strokeStyle;
    @NotNull
    private final Path path = SkiaBackedPath_skikoKt.Path();
    @NotNull
    private final Path renderPath = SkiaBackedPath_skikoKt.Path();
    @NotNull
    private final Lazy pathMeasure$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)pathMeasure.2.INSTANCE);
    @NotNull
    private final PathParser parser = new PathParser();

    public PathComponent() {
        super(null);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = value;
        this.invalidate();
    }

    @Nullable
    public final Brush getFill() {
        return this.fill;
    }

    public final void setFill(@Nullable Brush value) {
        this.fill = value;
        this.invalidate();
    }

    public final float getFillAlpha() {
        return this.fillAlpha;
    }

    public final void setFillAlpha(float value) {
        this.fillAlpha = value;
        this.invalidate();
    }

    @NotNull
    public final List<PathNode> getPathData() {
        return this.pathData;
    }

    public final void setPathData(@NotNull List<? extends PathNode> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.pathData = value;
        this.isPathDirty = true;
        this.invalidate();
    }

    public final int getPathFillType-Rg-k1Os() {
        return this.pathFillType;
    }

    public final void setPathFillType-oQ8Xj4U(int value) {
        this.pathFillType = value;
        this.renderPath.setFillType-oQ8Xj4U(value);
        this.invalidate();
    }

    public final float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public final void setStrokeAlpha(float value) {
        this.strokeAlpha = value;
        this.invalidate();
    }

    public final float getStrokeLineWidth() {
        return this.strokeLineWidth;
    }

    public final void setStrokeLineWidth(float value) {
        this.strokeLineWidth = value;
        this.invalidate();
    }

    @Nullable
    public final Brush getStroke() {
        return this.stroke;
    }

    public final void setStroke(@Nullable Brush value) {
        this.stroke = value;
        this.invalidate();
    }

    public final int getStrokeLineCap-KaPHkGw() {
        return this.strokeLineCap;
    }

    public final void setStrokeLineCap-BeK7IIE(int value) {
        this.strokeLineCap = value;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final int getStrokeLineJoin-LxFBmk8() {
        return this.strokeLineJoin;
    }

    public final void setStrokeLineJoin-Ww9F2mQ(int value) {
        this.strokeLineJoin = value;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final float getStrokeLineMiter() {
        return this.strokeLineMiter;
    }

    public final void setStrokeLineMiter(float value) {
        this.strokeLineMiter = value;
        this.isStrokeDirty = true;
        this.invalidate();
    }

    public final float getTrimPathStart() {
        return this.trimPathStart;
    }

    public final void setTrimPathStart(float value) {
        if (!(this.trimPathStart == value)) {
            this.trimPathStart = value;
            this.isTrimPathDirty = true;
            this.invalidate();
        }
    }

    public final float getTrimPathEnd() {
        return this.trimPathEnd;
    }

    public final void setTrimPathEnd(float value) {
        if (!(this.trimPathEnd == value)) {
            this.trimPathEnd = value;
            this.isTrimPathDirty = true;
            this.invalidate();
        }
    }

    public final float getTrimPathOffset() {
        return this.trimPathOffset;
    }

    public final void setTrimPathOffset(float value) {
        if (!(this.trimPathOffset == value)) {
            this.trimPathOffset = value;
            this.isTrimPathDirty = true;
            this.invalidate();
        }
    }

    private final PathMeasure getPathMeasure() {
        Lazy lazy = this.pathMeasure$delegate;
        return (PathMeasure)lazy.getValue();
    }

    private final void updatePath() {
        this.parser.clear();
        this.path.reset();
        this.parser.addPathNodes(this.pathData).toPath(this.path);
        this.updateRenderPath();
    }

    private final void updateRenderPath() {
        this.renderPath.reset();
        if (this.trimPathStart == 0.0f && this.trimPathEnd == 1.0f) {
            Path.addPath-Uv8p0NA$default((Path)this.renderPath, (Path)this.path, (long)0L, (int)2, null);
        } else {
            this.getPathMeasure().setPath(this.path, false);
            float length = this.getPathMeasure().getLength();
            float start = (this.trimPathStart + this.trimPathOffset) % 1.0f * length;
            float end = (this.trimPathEnd + this.trimPathOffset) % 1.0f * length;
            if (start > end) {
                this.getPathMeasure().getSegment(start, length, this.renderPath, true);
                this.getPathMeasure().getSegment(0.0f, end, this.renderPath, true);
            } else {
                this.getPathMeasure().getSegment(start, end, this.renderPath, true);
            }
        }
    }

    @Override
    public void draw(@NotNull DrawScope $this$draw) {
        block5: {
            Brush it;
            Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
            if (this.isPathDirty) {
                this.updatePath();
            } else if (this.isTrimPathDirty) {
                this.updateRenderPath();
            }
            this.isPathDirty = false;
            this.isTrimPathDirty = false;
            Brush brush = this.fill;
            if (brush != null) {
                it = brush;
                boolean bl = false;
                DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$draw, (Path)this.renderPath, (Brush)it, (float)this.fillAlpha, null, null, (int)0, (int)56, null);
            }
            Brush brush2 = this.stroke;
            if (brush2 == null) break block5;
            it = brush2;
            boolean bl = false;
            Stroke targetStroke = this.strokeStyle;
            if (this.isStrokeDirty || targetStroke == null) {
                this.strokeStyle = targetStroke = new Stroke(this.strokeLineWidth, this.strokeLineMiter, this.strokeLineCap, this.strokeLineJoin, null, 16, null);
                this.isStrokeDirty = false;
            }
            DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$draw, (Path)this.renderPath, (Brush)it, (float)this.strokeAlpha, (DrawStyle)((DrawStyle)targetStroke), null, (int)0, (int)48, null);
        }
    }

    @NotNull
    public String toString() {
        return this.path.toString();
    }
}

