/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.platform.AccessibilityController;
import androidx.compose.ui.platform.AccessibilityControllerImpl;
import androidx.compose.ui.platform.ComposeAccessible;
import androidx.compose.ui.platform.ComposeSceneAccessible;
import androidx.compose.ui.platform.SkiaBasedOwner;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/platform/ComposeSceneAccessible;", "Ljavax/accessibility/Accessible;", "ownersProvider", "Lkotlin/Function0;", "", "Landroidx/compose/ui/platform/SkiaBasedOwner;", "mainOwnerProvider", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "a11yDisabled", "", "getA11yDisabled", "()Z", "a11yDisabled$delegate", "Lkotlin/Lazy;", "accessibleContext", "Landroidx/compose/ui/platform/ComposeSceneAccessible$ComposeSceneAccessibleContext;", "getAccessibleContext", "()Landroidx/compose/ui/platform/ComposeSceneAccessible$ComposeSceneAccessibleContext;", "accessibleContext$delegate", "Ljavax/accessibility/AccessibleContext;", "ComposeSceneAccessibleContext", "ui"})
public final class ComposeSceneAccessible
implements Accessible {
    @NotNull
    private final Function0<List<SkiaBasedOwner>> ownersProvider;
    @NotNull
    private final Function0<SkiaBasedOwner> mainOwnerProvider;
    @NotNull
    private final Lazy a11yDisabled$delegate;
    @NotNull
    private final Lazy accessibleContext$delegate;

    public ComposeSceneAccessible(@NotNull Function0<? extends List<SkiaBasedOwner>> ownersProvider, @NotNull Function0<SkiaBasedOwner> mainOwnerProvider) {
        Intrinsics.checkNotNullParameter(ownersProvider, (String)"ownersProvider");
        Intrinsics.checkNotNullParameter(mainOwnerProvider, (String)"mainOwnerProvider");
        this.ownersProvider = ownersProvider;
        this.mainOwnerProvider = mainOwnerProvider;
        this.a11yDisabled$delegate = LazyKt.lazy((Function0)a11yDisabled.2.INSTANCE);
        this.accessibleContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeSceneAccessibleContext>(this){
            final /* synthetic */ ComposeSceneAccessible this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ComposeSceneAccessibleContext invoke() {
                return new ComposeSceneAccessibleContext((Function0<? extends List<SkiaBasedOwner>>)ComposeSceneAccessible.access$getOwnersProvider$p(this.this$0), (Function0<SkiaBasedOwner>)ComposeSceneAccessible.access$getMainOwnerProvider$p(this.this$0));
            }
        }));
    }

    private final boolean getA11yDisabled() {
        Lazy lazy = this.a11yDisabled$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    private final ComposeSceneAccessibleContext getAccessibleContext() {
        Lazy lazy = this.accessibleContext$delegate;
        return (ComposeSceneAccessibleContext)lazy.getValue();
    }

    @Override
    @Nullable
    public AccessibleContext getAccessibleContext() {
        if (this.getA11yDisabled()) {
            return null;
        }
        return this.getAccessibleContext();
    }

    public static final /* synthetic */ Function0 access$getOwnersProvider$p(ComposeSceneAccessible $this) {
        return $this.ownersProvider;
    }

    public static final /* synthetic */ Function0 access$getMainOwnerProvider$p(ComposeSceneAccessible $this) {
        return $this.mainOwnerProvider;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010%H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010*\u001a\u00020+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0002J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u00020\u000eH\u0016J\b\u00103\u001a\u00020\u000eH\u0016J\b\u00104\u001a\u00020\u000eH\u0016J\b\u00105\u001a\u00020\u000eH\u0016J\u0012\u00106\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u00107\u001a\u00020\nH\u0016J\u0012\u00108\u001a\u00020\n2\b\u00109\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010:\u001a\u00020\n2\b\u0010;\u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010<\u001a\u00020\n2\b\u0010=\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u000eH\u0016J\u0012\u0010@\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010A\u001a\u00020\n2\b\u00109\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010B\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010C\u001a\u00020\n2\b\u0010D\u001a\u0004\u0018\u000101H\u0016J\u0010\u0010E\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u000eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Landroidx/compose/ui/platform/ComposeSceneAccessible$ComposeSceneAccessibleContext;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "allOwners", "Lkotlin/Function0;", "", "Landroidx/compose/ui/platform/SkiaBasedOwner;", "mainOwner", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "addFocusListener", "", "l", "Ljava/awt/event/FocusListener;", "contains", "", "p", "Ljava/awt/Point;", "getAccessibleAt", "Ljavax/accessibility/Accessible;", "getAccessibleChild", "i", "", "getAccessibleChildrenCount", "getAccessibleComponent", "getAccessibleIndexInParent", "getAccessibleParent", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "getBackground", "Ljava/awt/Color;", "getBounds", "Ljava/awt/Rectangle;", "getCursor", "Ljava/awt/Cursor;", "getFont", "Ljava/awt/Font;", "getFontMetrics", "Ljava/awt/FontMetrics;", "f", "getForeground", "getLocale", "Ljava/util/Locale;", "getLocation", "getLocationOnScreen", "getMainOwnerAccessibleRoot", "Landroidx/compose/ui/platform/ComposeAccessible;", "getSize", "Ljava/awt/Dimension;", "isEnabled", "isFocusTraversable", "isShowing", "isVisible", "removeFocusListener", "requestFocus", "setBackground", "c", "setBounds", "r", "setCursor", "cursor", "setEnabled", "b", "setFont", "setForeground", "setLocation", "setSize", "d", "setVisible", "ui"})
    private static final class ComposeSceneAccessibleContext
    extends AccessibleContext
    implements AccessibleComponent {
        @NotNull
        private final Function0<List<SkiaBasedOwner>> allOwners;
        @NotNull
        private final Function0<SkiaBasedOwner> mainOwner;

        public ComposeSceneAccessibleContext(@NotNull Function0<? extends List<SkiaBasedOwner>> allOwners, @NotNull Function0<SkiaBasedOwner> mainOwner2) {
            Intrinsics.checkNotNullParameter(allOwners, (String)"allOwners");
            Intrinsics.checkNotNullParameter(mainOwner2, (String)"mainOwner");
            this.allOwners = allOwners;
            this.mainOwner = mainOwner2;
        }

        private final ComposeAccessible getMainOwnerAccessibleRoot() {
            SkiaBasedOwner skiaBasedOwner = (SkiaBasedOwner)this.mainOwner.invoke();
            AccessibilityController accessibilityController2 = skiaBasedOwner != null ? skiaBasedOwner.getAccessibilityController$ui() : null;
            AccessibilityControllerImpl accessibilityControllerImpl = accessibilityController2 instanceof AccessibilityControllerImpl ? (AccessibilityControllerImpl)accessibilityController2 : null;
            return accessibilityControllerImpl != null ? accessibilityControllerImpl.getRootAccessible() : null;
        }

        @Override
        @Nullable
        public Accessible getAccessibleAt(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            for (SkiaBasedOwner owner2 : (List)this.allOwners.invoke()) {
                Accessible accessibleOnPoint;
                AccessibilityControllerImpl controller;
                ComposeAccessible rootAccessible;
                ComposeAccessible.ComposeAccessibleComponent context2;
                AccessibilityController accessibilityController2 = owner2.getAccessibilityController$ui();
                AccessibilityControllerImpl accessibilityControllerImpl = accessibilityController2 instanceof AccessibilityControllerImpl ? (AccessibilityControllerImpl)accessibilityController2 : null;
                if (accessibilityControllerImpl == null || (context2 = (rootAccessible = (controller = accessibilityControllerImpl).getRootAccessible()).getComposeAccessibleContext()).getAccessibleAt(p) == null || Intrinsics.areEqual((Object)accessibleOnPoint, (Object)rootAccessible)) continue;
                return accessibleOnPoint;
            }
            return null;
        }

        @Override
        public boolean contains(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return true;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ((List)this.allOwners.invoke()).size();
        }

        @Override
        @NotNull
        public Accessible getAccessibleChild(int i) {
            AccessibilityController accessibilityController2 = ((SkiaBasedOwner)((List)this.allOwners.invoke()).get(i)).getAccessibilityController$ui();
            Intrinsics.checkNotNull((Object)accessibilityController2, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.AccessibilityControllerImpl");
            return ((AccessibilityControllerImpl)accessibilityController2).getRootAccessible();
        }

        @Override
        @Nullable
        public Dimension getSize() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getSize() : null;
        }

        @Override
        @Nullable
        public Point getLocationOnScreen() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getLocationOnScreen() : null;
        }

        @Override
        @Nullable
        public Point getLocation() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getLocation() : null;
        }

        @Override
        @Nullable
        public Rectangle getBounds() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getBounds() : null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        @Nullable
        public Accessible getAccessibleParent() {
            return null;
        }

        @Override
        @NotNull
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        @NotNull
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            return locale;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"UNKNOWN");
            return accessibleRole;
        }

        @Override
        @NotNull
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        @Override
        public void setLocation(@Nullable Point p) {
        }

        @Override
        public void setBounds(@Nullable Rectangle r) {
        }

        @Override
        public void setSize(@Nullable Dimension d) {
        }

        @Override
        public void setVisible(boolean b) {
        }

        @Override
        @Nullable
        public Color getBackground() {
            return null;
        }

        @Override
        public void setBackground(@Nullable Color c) {
        }

        @Override
        @Nullable
        public Color getForeground() {
            return null;
        }

        @Override
        public void setForeground(@Nullable Color c) {
        }

        @Override
        @Nullable
        public Cursor getCursor() {
            return null;
        }

        @Override
        public void setCursor(@Nullable Cursor cursor) {
        }

        @Override
        @Nullable
        public Font getFont() {
            return null;
        }

        @Override
        public void setFont(@Nullable Font f) {
        }

        @Override
        @Nullable
        public FontMetrics getFontMetrics(@Nullable Font f) {
            return null;
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void addFocusListener(@Nullable FocusListener l) {
        }

        @Override
        public void removeFocusListener(@Nullable FocusListener l) {
        }
    }
}

