/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.ui.awt.AwtEvents_desktopKt;
import androidx.compose.ui.awt.ComponentInfo;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerEventPass;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.PointerInputFilter;
import androidx.compose.ui.input.pointer.PointerInputModifier;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016J*\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/awt/InteropPointerInputModifier;", "T", "Ljava/awt/Component;", "Landroidx/compose/ui/input/pointer/PointerInputFilter;", "Landroidx/compose/ui/input/pointer/PointerInputModifier;", "componentInfo", "Landroidx/compose/ui/awt/ComponentInfo;", "(Landroidx/compose/ui/awt/ComponentInfo;)V", "pointerInputFilter", "getPointerInputFilter", "()Landroidx/compose/ui/input/pointer/PointerInputFilter;", "dispatchToView", "", "pointerEvent", "Landroidx/compose/ui/input/pointer/PointerEvent;", "getDeepestComponentForEvent", "parent", "event", "Ljava/awt/event/MouseEvent;", "onCancel", "onPointerEvent", "pass", "Landroidx/compose/ui/input/pointer/PointerEventPass;", "bounds", "Landroidx/compose/ui/unit/IntSize;", "onPointerEvent-H0pRuoY", "(Landroidx/compose/ui/input/pointer/PointerEvent;Landroidx/compose/ui/input/pointer/PointerEventPass;J)V", "ui"})
@SourceDebugExtension(value={"SMAP\nSwingPanel.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingPanel.desktop.kt\nandroidx/compose/ui/awt/InteropPointerInputModifier\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,406:1\n101#2,2:407\n33#2,6:409\n103#2:415\n33#2,6:416\n*S KotlinDebug\n*F\n+ 1 SwingPanel.desktop.kt\nandroidx/compose/ui/awt/InteropPointerInputModifier\n*L\n362#1:407,2\n362#1:409,6\n362#1:415\n390#1:416,6\n*E\n"})
final class InteropPointerInputModifier<T extends Component>
extends PointerInputFilter
implements PointerInputModifier {
    @NotNull
    private final ComponentInfo<T> componentInfo;
    @NotNull
    private final PointerInputFilter pointerInputFilter;

    public InteropPointerInputModifier(@NotNull ComponentInfo<T> componentInfo) {
        Intrinsics.checkNotNullParameter(componentInfo, (String)"componentInfo");
        this.componentInfo = componentInfo;
        this.pointerInputFilter = this;
    }

    @Override
    @NotNull
    public PointerInputFilter getPointerInputFilter() {
        return this.pointerInputFilter;
    }

    @Override
    public void onPointerEvent-H0pRuoY(@NotNull PointerEvent pointerEvent, @NotNull PointerEventPass pass, long bounds) {
        boolean dispatchDuringInitialTunnel;
        block3: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)pointerEvent, (String)"pointerEvent");
            Intrinsics.checkNotNullParameter((Object)((Object)pass), (String)"pass");
            List<PointerInputChange> $this$fastAny$iv = pointerEvent.getChanges();
            boolean $i$f$fastAny = false;
            List<PointerInputChange> $this$fastForEach$iv$iv = $this$fastAny$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                PointerInputChange item$iv$iv;
                PointerInputChange it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                PointerInputChange it = it$iv;
                boolean bl3 = false;
                if (!(PointerEventKt.changedToDownIgnoreConsumed(it) || PointerEventKt.changedToUpIgnoreConsumed(it))) continue;
                bl = true;
                break block3;
            }
            bl = dispatchDuringInitialTunnel = false;
        }
        if (pass == PointerEventPass.Initial && dispatchDuringInitialTunnel) {
            this.dispatchToView(pointerEvent);
        }
        if (pass == PointerEventPass.Final && !dispatchDuringInitialTunnel) {
            this.dispatchToView(pointerEvent);
        }
    }

    @Override
    public void onCancel() {
    }

    private final void dispatchToView(PointerEvent pointerEvent) {
        MouseEvent mouseEvent = AwtEvents_desktopKt.getAwtEventOrNull(pointerEvent);
        if (mouseEvent == null) {
            return;
        }
        MouseEvent e = mouseEvent;
        switch (e.getID()) {
            case 504: 
            case 505: {
                return;
            }
        }
        if (SwingUtilities.isDescendingFrom(e.getComponent(), this.componentInfo.getContainer())) {
            return;
        }
        Component component = this.getDeepestComponentForEvent((Component)this.componentInfo.getComponent(), e);
        if (component != null) {
            component.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, component));
            List<PointerInputChange> $this$fastForEach$iv = pointerEvent.getChanges();
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                PointerInputChange item$iv;
                PointerInputChange it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                it.consume();
            }
        }
    }

    private final Component getDeepestComponentForEvent(Component parent2, MouseEvent event) {
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), parent2);
        return SwingUtilities.getDeepestComponentAt(parent2, point.x, point.y);
    }
}

