/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.ComposeAccessible;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.TextRange;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleState;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u00013B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020\u000bJ\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\nH\u0002J \u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$H\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\nH\u0002J\u0006\u00100\u001a\u00020\u000bJ\u0006\u00101\u001a\u00020\u000bJ\b\u00102\u001a\u00020\u000bH\u0002R&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00064"}, d2={"Landroidx/compose/ui/platform/AccessibilityController;", "", "owner", "Landroidx/compose/ui/semantics/SemanticsOwner;", "desktopComponent", "Landroidx/compose/ui/platform/PlatformComponent;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "onFocusReceived", "Lkotlin/Function1;", "Landroidx/compose/ui/platform/ComposeAccessible;", "", "(Landroidx/compose/ui/semantics/SemanticsOwner;Landroidx/compose/ui/platform/PlatformComponent;Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function1;)V", "_currentNodes", "", "", "get_currentNodes", "()Ljava/util/Map;", "set_currentNodes", "(Ljava/util/Map;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentNodes", "getCurrentNodes", "currentNodesInvalidated", "", "getDesktopComponent", "()Landroidx/compose/ui/platform/PlatformComponent;", "job", "Lkotlinx/coroutines/CompletableJob;", "getOwner", "()Landroidx/compose/ui/semantics/SemanticsOwner;", "rootAccessible", "getRootAccessible", "()Landroidx/compose/ui/platform/ComposeAccessible;", "rootSemanticNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "getRootSemanticNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "dispose", "notifyIsInUse", "onNodeAdded", "accessible", "onNodeChanged", "component", "previousSemanticsNode", "newSemanticsNode", "onNodeRemoved", "onSemanticsChange", "syncLoop", "syncNodes", "SyncLoopState", "ui"})
@StabilityInferred(parameters=0)
public final class AccessibilityController {
    @NotNull
    private final SemanticsOwner owner;
    @NotNull
    private final PlatformComponent desktopComponent;
    @NotNull
    private final Function1<ComposeAccessible, Unit> onFocusReceived;
    private boolean currentNodesInvalidated;
    @NotNull
    private Map<Integer, ComposeAccessible> _currentNodes;
    @NotNull
    private final CompletableJob job;
    @NotNull
    private final CoroutineScope coroutineScope;
    public static final int $stable = 8;

    public AccessibilityController(@NotNull SemanticsOwner owner2, @NotNull PlatformComponent desktopComponent, @NotNull CoroutineContext coroutineContext, @NotNull Function1<? super ComposeAccessible, Unit> onFocusReceived) {
        Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)desktopComponent, (String)"desktopComponent");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter(onFocusReceived, (String)"onFocusReceived");
        this.owner = owner2;
        this.desktopComponent = desktopComponent;
        this.onFocusReceived = onFocusReceived;
        this.currentNodesInvalidated = true;
        this._currentNodes = MapsKt.emptyMap();
        this.job = JobKt.Job$default(null, (int)1, null);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineContext.plus((CoroutineContext)this.job));
    }

    @NotNull
    public final SemanticsOwner getOwner() {
        return this.owner;
    }

    @NotNull
    public final PlatformComponent getDesktopComponent() {
        return this.desktopComponent;
    }

    @NotNull
    public final Map<Integer, ComposeAccessible> get_currentNodes() {
        return this._currentNodes;
    }

    public final void set_currentNodes(@NotNull Map<Integer, ComposeAccessible> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this._currentNodes = map;
    }

    @NotNull
    public final Map<Integer, ComposeAccessible> getCurrentNodes() {
        if (this.currentNodesInvalidated) {
            this.syncNodes();
        }
        return this._currentNodes;
    }

    private final void onNodeAdded(ComposeAccessible accessible2) {
    }

    private final void onNodeRemoved(ComposeAccessible accessible2) {
        accessible2.setRemoved(true);
    }

    private final void onNodeChanged(ComposeAccessible component, SemanticsNode previousSemanticsNode, SemanticsNode newSemanticsNode) {
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : newSemanticsNode.getConfig()) {
            Object prev = SemanticsConfigurationKt.getOrNull(previousSemanticsNode.getConfig(), entry.getKey());
            if (Intrinsics.areEqual((Object)entry.getValue(), prev)) continue;
            SemanticsPropertyKey<?> semanticsPropertyKey = entry.getKey();
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getText())) {
                component.getComposeAccessibleContext().firePropertyChange("AccessibleText", prev, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getEditableText())) {
                component.getComposeAccessibleContext().firePropertyChange("AccessibleText", prev, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getTextSelectionRange())) {
                ComposeAccessible.ComposeAccessibleComponent composeAccessibleComponent = component.getComposeAccessibleContext();
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.text.TextRange");
                composeAccessibleComponent.firePropertyChange("AccessibleCaret", prev, TextRange.getStart-impl((long)((TextRange)object).unbox-impl()));
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getFocused())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                if (((Boolean)object).booleanValue()) {
                    component.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                    this.onFocusReceived.invoke((Object)component);
                    continue;
                }
                component.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getToggleableState())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.state.ToggleableState");
                switch (WhenMappings.$EnumSwitchMapping$0[((ToggleableState)((Object)object)).ordinal()]) {
                    case 1: {
                        component.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                        break;
                    }
                    case 2: 
                    case 3: {
                        component.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                    }
                }
                continue;
            }
            if (!Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getProgressBarRangeInfo())) continue;
            Object object = entry.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.ProgressBarRangeInfo");
            ProgressBarRangeInfo value = (ProgressBarRangeInfo)object;
            component.getComposeAccessibleContext().firePropertyChange("AccessibleValue", prev, Float.valueOf(value.getCurrent()));
        }
    }

    public final void notifyIsInUse() {
        SyncLoopState.INSTANCE.setLastAccessTimeMillis(System.currentTimeMillis());
    }

    public final void dispose() {
        Job.DefaultImpls.cancel$default((Job)((Job)this.job), null, (int)1, null);
    }

    public final void syncLoop() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccessibilityController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                        // 2 sources

                        while (true) {
                            if (AccessibilityController.access$getCurrentNodesInvalidated$p(this.this$0) && SyncLoopState.INSTANCE.getShouldSync()) {
                                AccessibilityController.access$syncNodes(this.this$0);
                            }
                            this.label = 1;
                            v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                            if (v0 != var2_2) continue;
                            return var2_2;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void syncNodes() {
        if (!this.getRootSemanticNode().getLayoutNode$ui().isPlaced()) {
            return;
        }
        Map<Integer, ComposeAccessible> previous = this._currentNodes;
        Map nodes = new LinkedHashMap();
        AccessibilityController.syncNodes$findAllSemanticNodesRecursive(nodes, previous, this, this.getRootSemanticNode());
        for (Map.Entry<Integer, ComposeAccessible> entry : previous.entrySet()) {
            int id = ((Number)entry.getKey()).intValue();
            ComposeAccessible prevNode = entry.getValue();
            if (nodes.get(id) != null) continue;
            this.onNodeRemoved(prevNode);
        }
        this._currentNodes = nodes;
        this.currentNodesInvalidated = false;
    }

    public final void onSemanticsChange() {
        this.currentNodesInvalidated = true;
    }

    @NotNull
    public final SemanticsNode getRootSemanticNode() {
        return this.owner.getRootSemanticsNode();
    }

    @NotNull
    public final ComposeAccessible getRootAccessible() {
        ComposeAccessible composeAccessible = this.getCurrentNodes().get(this.getRootSemanticNode().getId());
        Intrinsics.checkNotNull((Object)composeAccessible);
        return composeAccessible;
    }

    private static final void syncNodes$findAllSemanticNodesRecursive(Map<Integer, ComposeAccessible> nodes, Map<Integer, ComposeAccessible> previous, AccessibilityController this$0, SemanticsNode currentNode) {
        ComposeAccessible composeAccessible;
        ComposeAccessible it;
        Map<Integer, ComposeAccessible> map = nodes;
        Integer n = currentNode.getId();
        ComposeAccessible composeAccessible2 = previous.get(currentNode.getId());
        if (composeAccessible2 != null) {
            it = composeAccessible2;
            boolean bl = false;
            SemanticsNode prevSemanticsNode = it.getSemanticsNode();
            it.setSemanticsNode(currentNode);
            this$0.onNodeChanged(it, prevSemanticsNode, currentNode);
            composeAccessible = it;
        } else {
            ComposeAccessible composeAccessible3;
            it = composeAccessible3 = new ComposeAccessible(currentNode, this$0);
            boolean bl = false;
            this$0.onNodeAdded(it);
            composeAccessible = composeAccessible3;
        }
        ComposeAccessible composeAccessible4 = composeAccessible;
        map.put(n, composeAccessible4);
        List<SemanticsNode> children = currentNode.getReplacedChildren$ui();
        for (int i = children.size() - 1; -1 < i; --i) {
            AccessibilityController.syncNodes$findAllSemanticNodesRecursive(nodes, previous, this$0, children.get(i));
        }
    }

    public static final /* synthetic */ boolean access$getCurrentNodesInvalidated$p(AccessibilityController $this) {
        return $this.currentNodesInvalidated;
    }

    public static final /* synthetic */ void access$syncNodes(AccessibilityController $this) {
        $this.syncNodes();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/platform/AccessibilityController$SyncLoopState;", "", "()V", "lastAccessTimeMillis", "", "getLastAccessTimeMillis", "()J", "setLastAccessTimeMillis", "(J)V", "maxIdleTimeMillis", "", "getMaxIdleTimeMillis", "()I", "shouldSync", "", "getShouldSync", "()Z", "ui"})
    private static final class SyncLoopState {
        @NotNull
        public static final SyncLoopState INSTANCE = new SyncLoopState();
        private static final int maxIdleTimeMillis = 300000;
        private static long lastAccessTimeMillis;

        private SyncLoopState() {
        }

        public final int getMaxIdleTimeMillis() {
            return maxIdleTimeMillis;
        }

        public final long getLastAccessTimeMillis() {
            return lastAccessTimeMillis;
        }

        public final void setLastAccessTimeMillis(long l) {
            lastAccessTimeMillis = l;
        }

        public final boolean getShouldSync() {
            return System.currentTimeMillis() - lastAccessTimeMillis < (long)maxIdleTimeMillis;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToggleableState.values().length];
            try {
                nArray[ToggleableState.On.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Off.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Indeterminate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

