/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b*\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u001a\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"floatCountForType", "", "type", "Landroidx/compose/ui/graphics/PathSegment$Type;", "computeDirection", "Landroidx/compose/ui/graphics/Path$Direction;", "Landroidx/compose/ui/graphics/Path;", "divide", "", "contours", "reverse", "destination", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nPathGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathGeometry.kt\nandroidx/compose/ui/graphics/PathGeometryKt\n+ 2 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n1#1,316:1\n456#2:317\n*S KotlinDebug\n*F\n+ 1 PathGeometry.kt\nandroidx/compose/ui/graphics/PathGeometryKt\n*L\n127#1:317\n*E\n"})
public final class PathGeometryKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Path.Direction computeDirection(@NotNull Path $this$computeDirection) {
        Path.Direction direction;
        Intrinsics.checkNotNullParameter((Object)$this$computeDirection, (String)"<this>");
        boolean first = true;
        PathIterator iterator2 = $this$computeDirection.iterator();
        float[] points = new float[8];
        float area = 0.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        float endX = 0.0f;
        float endY = 0.0f;
        PathSegment.Type type = PathIterator.next$default(iterator2, points, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!first) break block9;
                    first = false;
                    startX = points[0];
                    startY = points[1];
                    break;
                }
                case 2: {
                    float x0 = points[0];
                    float y0 = points[1];
                    float x1 = points[2];
                    float y1 = points[3];
                    area += BezierKt.cubicArea(x0, y0, x0, y0, x1, y1, x1, y1);
                    endX = x1;
                    endY = y1;
                    break;
                }
                case 3: {
                    float x0 = points[0];
                    float y0 = points[1];
                    float x1 = points[2];
                    float y1 = points[3];
                    float x2 = points[4];
                    float y2 = points[5];
                    float c1x = x0 + 0.6666667f * (x1 - x0);
                    float c1y = y0 + 0.6666667f * (y1 - y0);
                    float c2x = x2 + 0.6666667f * (x1 - x2);
                    float c2y = y2 + 0.6666667f * (y1 - y2);
                    area += BezierKt.cubicArea(x0, y0, c1x, c1y, c2x, c2y, x2, y2);
                    endX = x2;
                    endY = y2;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    area += BezierKt.cubicArea(points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7]);
                    endX = points[6];
                    endY = points[7];
                    break;
                }
                case 6: {
                    float $this$closeTo$iv = endX;
                    boolean $i$f$closeTo = false;
                    if (Math.abs($this$closeTo$iv - startX) < 1.05E-6f) {
                        $this$closeTo$iv = endY;
                        $i$f$closeTo = false;
                        if (Math.abs($this$closeTo$iv - startY) < 1.05E-6f) break;
                    }
                    area += BezierKt.cubicArea(endX, endY, endX, endY, startX, startY, startX, startY);
                    endX = startX;
                    endY = startY;
                    break;
                }
                case 7: {
                    break block9;
                }
            }
            type = PathIterator.next$default(iterator2, points, 0, 2, null);
        }
        if (area >= 0.0f) {
            direction = Path.Direction.Clockwise;
            return direction;
        }
        direction = Path.Direction.CounterClockwise;
        return direction;
    }

    @NotNull
    public static final List<Path> divide(@NotNull Path $this$divide, @NotNull List<Path> contours) {
        Intrinsics.checkNotNullParameter((Object)$this$divide, (String)"<this>");
        Intrinsics.checkNotNullParameter(contours, (String)"contours");
        Path path = SkiaBackedPath_skikoKt.Path();
        boolean first = true;
        boolean isEmpty = true;
        PathIterator iterator2 = $this$divide.iterator();
        float[] points = new float[8];
        PathSegment.Type type = PathIterator.next$default(iterator2, points, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!first && !isEmpty) {
                        contours.add(path);
                        path = SkiaBackedPath_skikoKt.Path();
                    }
                    first = false;
                    isEmpty = true;
                    path.moveTo(points[0], points[1]);
                    break;
                }
                case 2: {
                    path.lineTo(points[2], points[3]);
                    isEmpty = false;
                    break;
                }
                case 3: {
                    path.quadraticTo(points[2], points[3], points[4], points[5]);
                    isEmpty = false;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    path.cubicTo(points[2], points[3], points[4], points[5], points[6], points[7]);
                    isEmpty = false;
                    break;
                }
                case 6: {
                    path.close();
                    break;
                }
                case 7: {
                    continue block9;
                }
            }
            type = PathIterator.next$default(iterator2, points, 0, 2, null);
        }
        if (!first && !isEmpty) {
            contours.add(path);
        }
        return contours;
    }

    public static /* synthetic */ List divide$default(Path path, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        return PathGeometryKt.divide(path, list);
    }

    @NotNull
    public static final Path reverse(@NotNull Path $this$reverse, @NotNull Path destination) {
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        PathIterator iterator2 = $this$reverse.iterator();
        int count = iterator2.calculateSize(false);
        ArrayList<PathSegment.Type> segments = new ArrayList<PathSegment.Type>(count);
        ArrayList<float[]> data = new ArrayList<float[]>(count);
        float[] points = new float[8];
        PathSegment.Type type = PathIterator.next$default(iterator2, points, 0, 2, null);
        while (type != PathSegment.Type.Done) {
            segments.add(type);
            if (type != PathSegment.Type.Close) {
                float[] fArray = Arrays.copyOf(points, PathGeometryKt.floatCountForType(type));
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
                data.add(fArray);
            }
            type = PathIterator.next$default(iterator2, points, 0, 2, null);
        }
        boolean insertMove = true;
        boolean insertClose = false;
        int dataIndex = data.size();
        block9: for (int i = segments.size() - 1; -1 < i; --i) {
            if (insertMove) {
                Object e = data.get(--dataIndex);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                points = (float[])e;
                int offset = ArraysKt.getLastIndex((float[])points);
                destination.moveTo(points[offset - 1], points[offset]);
                insertMove = false;
            } else {
                Object e = data.get(dataIndex);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                points = (float[])e;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((PathSegment.Type)((Object)segments.get(i))).ordinal()]) {
                case 1: {
                    if (insertClose) {
                        destination.close();
                        insertClose = false;
                    }
                    insertMove = true;
                    continue block9;
                }
                case 2: {
                    destination.lineTo(points[0], points[1]);
                    --dataIndex;
                    continue block9;
                }
                case 3: {
                    destination.quadraticTo(points[2], points[3], points[0], points[1]);
                    --dataIndex;
                    continue block9;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    destination.cubicTo(points[4], points[5], points[2], points[3], points[0], points[1]);
                    --dataIndex;
                    continue block9;
                }
                case 6: {
                    insertClose = true;
                }
            }
        }
        if (insertClose) {
            destination.close();
        }
        return destination;
    }

    public static /* synthetic */ Path reverse$default(Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            path2 = SkiaBackedPath_skikoKt.Path();
        }
        return PathGeometryKt.reverse(path, path2);
    }

    private static final int floatCountForType(PathSegment.Type type) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 6;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

