/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.ComposeScene;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.platform.SkiaRootForTest;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.test.Assertions_skikoMainKt;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\tH\u0002\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0005H\u0000\u00a8\u0006\u000b"}, d2={"checkIsDisplayed", "", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "clippedNodeBoundsInWindow", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/ui/semantics/SemanticsNode;", "findClosestParentNode", "Landroidx/compose/ui/layout/LayoutInfo;", "selector", "Lkotlin/Function1;", "isInScreenBounds", "ui-test"})
public final class Assertions_skikoMainKt {
    public static final boolean checkIsDisplayed(@NotNull SemanticsNodeInteraction $this$checkIsDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$checkIsDisplayed, (String)"<this>");
        String errorMessageOnFail = "Failed to perform isDisplayed check.";
        SemanticsNode node = $this$checkIsDisplayed.fetchSemanticsNode(errorMessageOnFail);
        LayoutInfo layoutInfo = node.getLayoutInfo();
        if (Assertions_skikoMainKt.checkIsDisplayed$isNotPlaced(layoutInfo) || Assertions_skikoMainKt.findClosestParentNode(layoutInfo, (Function1<? super LayoutInfo, Boolean>)((Function1)checkIsDisplayed.1.INSTANCE)) != null) {
            return false;
        }
        Rect globalRect = node.getBoundsInWindow();
        if (!Assertions_skikoMainKt.isInScreenBounds(node)) {
            return false;
        }
        return globalRect.getWidth() > 0.0f && globalRect.getHeight() > 0.0f;
    }

    @NotNull
    public static final Rect clippedNodeBoundsInWindow(@NotNull SemanticsNode $this$clippedNodeBoundsInWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$clippedNodeBoundsInWindow, (String)"<this>");
        return $this$clippedNodeBoundsInWindow.getBoundsInRoot().translate-k-4lQ0M(OffsetKt.Offset((float)0.0f, (float)0.0f));
    }

    public static final boolean isInScreenBounds(@NotNull SemanticsNode $this$isInScreenBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$isInScreenBounds, (String)"<this>");
        RootForTest rootForTest = $this$isInScreenBounds.getRoot();
        Intrinsics.checkNotNull((Object)rootForTest, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.SkiaRootForTest");
        ComposeScene composeView = ((SkiaRootForTest)rootForTest).getScene();
        Rect nodeBoundsInWindow = Assertions_skikoMainKt.clippedNodeBoundsInWindow($this$isInScreenBounds);
        if (nodeBoundsInWindow.getWidth() == 0.0f || nodeBoundsInWindow.getHeight() == 0.0f) {
            return false;
        }
        return nodeBoundsInWindow.getTop() >= 0.0f && nodeBoundsInWindow.getLeft() >= 0.0f && nodeBoundsInWindow.getRight() <= (float)IntSize.getWidth-impl((long)composeView.getContentSize-YbymL2g()) && nodeBoundsInWindow.getBottom() <= (float)IntSize.getHeight-impl((long)composeView.getContentSize-YbymL2g());
    }

    private static final LayoutInfo findClosestParentNode(LayoutInfo $this$findClosestParentNode, Function1<? super LayoutInfo, Boolean> selector) {
        for (LayoutInfo currentParent = $this$findClosestParentNode.getParentInfo(); currentParent != null; currentParent = currentParent.getParentInfo()) {
            if (!((Boolean)selector.invoke((Object)currentParent)).booleanValue()) continue;
            return currentParent;
        }
        return null;
    }

    private static final boolean checkIsDisplayed$isNotPlaced(LayoutInfo node) {
        return !node.isPlaced();
    }

    public static final /* synthetic */ boolean access$checkIsDisplayed$isNotPlaced(LayoutInfo node) {
        return Assertions_skikoMainKt.checkIsDisplayed$isNotPlaced(node);
    }
}

