/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.compose.ui.test.SemanticsNodeInteractionCollection;
import androidx.compose.ui.test.SkikoOutput_skikoMainKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.unit.IntSizeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\b2\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\n2\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0000\u001a8\u0010\u000b\u001a\u00020\u0006*\u00020\n2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0014H\u0002\u001a\"\u0010\u0019\u001a\u00020\u0006*\u00060\rj\u0002`\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0001H\u0002\"\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"printToString", "", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "maxDepth", "", "printToLog", "", "tag", "Landroidx/compose/ui/test/SemanticsNodeInteractionCollection;", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "printToStringInner", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nestingLevel", "nestingIndent", "isFollowedBySibling", "", "unclippedGlobalBounds", "Landroidx/compose/ui/geometry/Rect;", "getUnclippedGlobalBounds", "(Landroidx/compose/ui/semantics/SemanticsNode;)Landroidx/compose/ui/geometry/Rect;", "rectToShortString", "rect", "appendConfigInfo", "config", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "indent", "ui-test"})
@SourceDebugExtension(value={"SMAP\nOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Output.kt\nandroidx/compose/ui/test/OutputKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1869#2,2:298\n1878#2,3:300\n1056#2:303\n*S KotlinDebug\n*F\n+ 1 Output.kt\nandroidx/compose/ui/test/OutputKt\n*L\n121#1:298,2\n207#1:300,3\n228#1:303\n*E\n"})
public final class OutputKt {
    @NotNull
    public static final String printToString(@NotNull SemanticsNodeInteraction $this$printToString, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)$this$printToString, (String)"<this>");
        SemanticsNode result = SemanticsNodeInteraction.fetchSemanticsNode$default($this$printToString, null, 1, null);
        return "Printing with useUnmergedTree = '" + $this$printToString.getUseUnmergedTree$ui_test() + "'\n" + OutputKt.printToString(result, maxDepth);
    }

    public static /* synthetic */ String printToString$default(SemanticsNodeInteraction semanticsNodeInteraction, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        return OutputKt.printToString(semanticsNodeInteraction, n);
    }

    public static final void printToLog(@NotNull SemanticsNodeInteraction $this$printToLog, @NotNull String tag, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)$this$printToLog, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String result = "printToLog:\n" + OutputKt.printToString($this$printToLog, maxDepth);
        SkikoOutput_skikoMainKt.printToLog(tag, result);
    }

    public static /* synthetic */ void printToLog$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        OutputKt.printToLog(semanticsNodeInteraction, string, n);
    }

    @NotNull
    public static final String printToString(@NotNull SemanticsNodeInteractionCollection $this$printToString, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)$this$printToString, (String)"<this>");
        List nodes = SemanticsNodeInteractionCollection.fetchSemanticsNodes$default($this$printToString, false, null, 3, null);
        return "Printing with useUnmergedTree = '" + $this$printToString.getUseUnmergedTree$ui_test() + "'\n" + (nodes.isEmpty() ? "There were 0 nodes found!" : OutputKt.printToString(nodes, maxDepth));
    }

    public static /* synthetic */ String printToString$default(SemanticsNodeInteractionCollection semanticsNodeInteractionCollection, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return OutputKt.printToString(semanticsNodeInteractionCollection, n);
    }

    public static final void printToLog(@NotNull SemanticsNodeInteractionCollection $this$printToLog, @NotNull String tag, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)$this$printToLog, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String result = "printToLog:\n" + OutputKt.printToString($this$printToLog, maxDepth);
        SkikoOutput_skikoMainKt.printToLog(tag, result);
    }

    public static /* synthetic */ void printToLog$default(SemanticsNodeInteractionCollection semanticsNodeInteractionCollection, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        OutputKt.printToLog(semanticsNodeInteractionCollection, string, n);
    }

    @NotNull
    public static final String printToString(@NotNull Collection<SemanticsNode> $this$printToString, int maxDepth) {
        Intrinsics.checkNotNullParameter($this$printToString, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        i = 1;
        Iterable $this$forEach$iv = $this$printToString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl = false;
            if ($this$printToString.size() > 1) {
                sb.append(i);
                sb.append(") ");
            }
            sb.append(OutputKt.printToString(it, maxDepth));
            if (i < $this$printToString.size()) {
                sb.append('\n');
            }
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String printToString$default(Collection collection, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return OutputKt.printToString(collection, n);
    }

    @NotNull
    public static final String printToString(@NotNull SemanticsNode $this$printToString, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)$this$printToString, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        OutputKt.printToStringInner($this$printToString, sb, maxDepth, 0, "", false);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String printToString$default(SemanticsNode semanticsNode, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return OutputKt.printToString(semanticsNode, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final void printToStringInner(SemanticsNode $this$printToStringInner, StringBuilder sb, int maxDepth, int nestingLevel, String nestingIndent, boolean isFollowedBySibling) {
        String newIndent;
        String string = nestingLevel == 0 ? "" : (newIndent = isFollowedBySibling ? nestingIndent + " | " : nestingIndent + "   ");
        if (nestingLevel > 0) {
            sb.append(nestingIndent + " |-");
        }
        sb.append("Node #" + $this$printToStringInner.getId() + " at ");
        sb.append(OutputKt.rectToShortString(OutputKt.getUnclippedGlobalBounds($this$printToStringInner)));
        if ($this$printToStringInner.getConfig().contains(SemanticsProperties.INSTANCE.getTestTag())) {
            sb.append(", Tag: '");
            sb.append((String)$this$printToStringInner.getConfig().get(SemanticsProperties.INSTANCE.getTestTag()));
            sb.append("'");
        }
        boolean maxLevelReached = nestingLevel == maxDepth;
        OutputKt.appendConfigInfo(sb, $this$printToStringInner.getConfig(), newIndent);
        if (maxLevelReached) {
            int childrenCount = $this$printToStringInner.getChildren().size();
            Object object = $this$printToStringInner.getParent();
            int siblingsCount = (object != null && (object = object.getChildren()) != null ? object.size() : 1) - 1;
            if (childrenCount > 0 || siblingsCount > 0 && nestingLevel == 0) {
                sb.append('\n');
                sb.append(newIndent);
                sb.append("Has ");
                if (childrenCount > 1) {
                    sb.append(childrenCount + " children");
                } else if (childrenCount == 1) {
                    sb.append(childrenCount + " child");
                }
                if (siblingsCount > 0 && nestingLevel == 0) {
                    if (childrenCount > 0) {
                        sb.append(", ");
                    }
                    StringBuilder stringBuilder = siblingsCount > 1 ? sb.append(siblingsCount + " siblings") : sb.append(siblingsCount + " sibling");
                }
            }
            return;
        }
        int childrenLevel = nestingLevel + 1;
        List children = CollectionsKt.toList((Iterable)$this$printToStringInner.getChildren());
        Iterable $this$forEachIndexed$iv = children;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void child;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SemanticsNode semanticsNode = (SemanticsNode)item$iv;
            int index = n;
            boolean bl = false;
            boolean hasSibling = index < children.size() - 1;
            sb.append('\n');
            OutputKt.printToStringInner((SemanticsNode)child, sb, maxDepth, childrenLevel, newIndent, hasSibling);
        }
    }

    private static final Rect getUnclippedGlobalBounds(SemanticsNode $this$unclippedGlobalBounds) {
        return RectKt.Rect-tz77jQw((long)$this$unclippedGlobalBounds.getPositionInWindow-F1C5BW0(), (long)IntSizeKt.toSize-ozmzZPI((long)$this$unclippedGlobalBounds.getSize-YbymL2g()));
    }

    private static final String rectToShortString(Rect rect) {
        return "(l=" + rect.getLeft() + ", t=" + rect.getTop() + ", r=" + rect.getRight() + ", b=" + rect.getBottom() + ")px";
    }

    private static final void appendConfigInfo(StringBuilder $this$appendConfigInfo, SemanticsConfiguration config, String indent) {
        List actions = new ArrayList();
        List units = new ArrayList();
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)((Iterable)config));
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((SemanticsPropertyKey)it.getKey()).getName());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((SemanticsPropertyKey)it.getKey()).getName())));
            }
        });
        for (Map.Entry entry : sorted) {
            SemanticsPropertyKey key = (SemanticsPropertyKey)entry.getKey();
            Object value = entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)SemanticsProperties.INSTANCE.getTestTag())) continue;
            if (value instanceof AccessibilityAction || value instanceof Function) {
                actions.add(key.getName());
                continue;
            }
            if (value instanceof Unit) {
                units.add(key.getName());
                continue;
            }
            $this$appendConfigInfo.append('\n');
            $this$appendConfigInfo.append(indent);
            $this$appendConfigInfo.append(key.getName());
            $this$appendConfigInfo.append(" = '");
            StringBuilder stringBuilder = value instanceof AnnotatedString ? (((AnnotatedString)value).getParagraphStyles().isEmpty() && ((AnnotatedString)value).getSpanStyles().isEmpty() && ((AnnotatedString)value).getStringAnnotations(0, ((AnnotatedString)value).getText().length()).isEmpty() ? $this$appendConfigInfo.append(((AnnotatedString)value).getText()) : $this$appendConfigInfo.append((CharSequence)value)) : $this$appendConfigInfo.append(value);
            $this$appendConfigInfo.append("'");
        }
        if (!((Collection)units).isEmpty()) {
            $this$appendConfigInfo.append('\n');
            $this$appendConfigInfo.append(indent);
            $this$appendConfigInfo.append("[");
            $this$appendConfigInfo.append(CollectionsKt.joinToString$default((Iterable)units, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            $this$appendConfigInfo.append("]");
        }
        if (!((Collection)actions).isEmpty()) {
            $this$appendConfigInfo.append('\n');
            $this$appendConfigInfo.append(indent);
            $this$appendConfigInfo.append("Actions = [");
            $this$appendConfigInfo.append(CollectionsKt.joinToString$default((Iterable)actions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            $this$appendConfigInfo.append("]");
        }
        if (config.isMergingSemanticsOfDescendants()) {
            $this$appendConfigInfo.append('\n');
            $this$appendConfigInfo.append(indent);
            $this$appendConfigInfo.append("MergeDescendants = 'true'");
        }
        if (config.isClearingSemantics()) {
            $this$appendConfigInfo.append('\n');
            $this$appendConfigInfo.append(indent);
            $this$appendConfigInfo.append("ClearAndSetSemantics = 'true'");
        }
    }

    static /* synthetic */ void appendConfigInfo$default(StringBuilder stringBuilder, SemanticsConfiguration semanticsConfiguration, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        OutputKt.appendConfigInfo(stringBuilder, semanticsConfiguration, string);
    }
}

