/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.junit4;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.test.InternalTestApi;
import androidx.compose.ui.test.junit4.GoldenConfig;
import androidx.compose.ui.test.junit4.ScreenshotResultProto;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Surface;

@InternalTestApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0006\u0010\u0011\u001a\u00020\nJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u001c\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\bH\u0002J,\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\bJ\u0016\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/compose/ui/test/junit4/SkiaTestAlbum;", "", "config", "Landroidx/compose/ui/test/junit4/GoldenConfig;", "(Landroidx/compose/ui/test/junit4/GoldenConfig;)V", "getConfig", "()Landroidx/compose/ui/test/junit4/GoldenConfig;", "imageExtension", "", "report", "Landroidx/compose/ui/test/junit4/SkiaTestAlbum$Report;", "screenshots", "", "Landroidx/compose/ui/test/junit4/ScreenshotResultProto;", "calcHash", "", "input", "check", "compareImages", "", "actual", "expected", "dumpImage", "", "path", "data", "ensureDir", "inModuleImagePath", "id", "suffix", "readExpectedImage", "reportResult", "status", "Landroidx/compose/ui/test/junit4/ScreenshotResultProto$Status;", "comparisonStatistics", "snap", "surface", "Lorg/jetbrains/skia/Surface;", "write", "image", "Lorg/jetbrains/skia/Image;", "Report", "ui-test-junit4"})
@StabilityInferred(parameters=0)
public final class SkiaTestAlbum {
    @NotNull
    private final GoldenConfig config;
    @NotNull
    private final Map<String, ScreenshotResultProto> screenshots;
    @NotNull
    private final Report report;
    @NotNull
    private final String imageExtension;
    public static final int $stable = 8;

    public SkiaTestAlbum(@NotNull GoldenConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.screenshots = new LinkedHashMap();
        this.report = new Report(this.screenshots);
        this.imageExtension = ".png";
    }

    @NotNull
    public final GoldenConfig getConfig() {
        return this.config;
    }

    public final void snap(@NotNull Surface surface, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.write(surface.makeImageSnapshot(), id);
    }

    public final void write(@NotNull Image image, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CharSequence charSequence = id;
        if (!new Regex("^[A-Za-z0-9_-]+$").matches(charSequence)) {
            throw new IllegalArgumentException("The given golden identifier '" + id + "' does not satisfy the naming requirement. Allowed characters are: '[A-Za-z0-9_-]'");
        }
        Data data = Image.encodeToData$default((Image)image, null, (int)0, (int)3, null);
        Intrinsics.checkNotNull((Object)data);
        byte[] actual = data.getBytes();
        byte[] expected = this.readExpectedImage(id);
        if (expected == null) {
            SkiaTestAlbum.reportResult$default(this, ScreenshotResultProto.Status.MISSING_GOLDEN, id, actual, null, 8, null);
            return;
        }
        ScreenshotResultProto.Status status = this.compareImages(actual, expected) ? ScreenshotResultProto.Status.PASSED : ScreenshotResultProto.Status.FAILED;
        SkiaTestAlbum.reportResult$default(this, status, id, actual, null, 8, null);
    }

    @NotNull
    public final Report check() {
        return this.report;
    }

    private final void dumpImage(String path, byte[] data) {
        File file = new File(this.config.getFsGoldenPath(), path);
        FilesKt.writeBytes((File)file, (byte[])data);
    }

    private final String inModuleImagePath(String id, String suffix) {
        return suffix == null ? this.config.getModulePrefix() + '/' + id + this.imageExtension : this.config.getModulePrefix() + '/' + id + '_' + suffix + this.imageExtension;
    }

    static /* synthetic */ String inModuleImagePath$default(SkiaTestAlbum skiaTestAlbum, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return skiaTestAlbum.inModuleImagePath(string, string2);
    }

    private final byte[] readExpectedImage(String id) {
        File file = new File(this.config.getFsGoldenPath(), SkiaTestAlbum.inModuleImagePath$default(this, id, null, 2, null));
        if (!file.exists()) {
            return null;
        }
        return ByteStreamsKt.readBytes((InputStream)new FileInputStream(file));
    }

    private final byte[] calcHash(byte[] input) {
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"SHA-256\")\n            .digest(input)");
        return byArray;
    }

    private final boolean compareImages(byte[] actual, byte[] expected) {
        return Arrays.equals(this.calcHash(actual), this.calcHash(expected));
    }

    private final void ensureDir() {
        new File(this.config.getFsGoldenPath(), this.config.getModulePrefix()).mkdirs();
    }

    private final void reportResult(ScreenshotResultProto.Status status, String id, byte[] actual, String comparisonStatistics) {
        String currentScreenshotFileName = null;
        if (status != ScreenshotResultProto.Status.PASSED) {
            currentScreenshotFileName = this.inModuleImagePath(id, "actual");
            this.ensureDir();
            this.dumpImage(currentScreenshotFileName, actual);
        } else {
            currentScreenshotFileName = SkiaTestAlbum.inModuleImagePath$default(this, id, null, 2, null);
        }
        Map<String, ScreenshotResultProto> map = this.screenshots;
        String string = comparisonStatistics;
        if (string == null) {
            string = "";
        }
        Object object = string;
        String string2 = this.config.getRepoGoldenPath();
        String string3 = SkiaTestAlbum.inModuleImagePath$default(this, id, null, 2, null);
        String string4 = SkiaTestAlbum.inModuleImagePath$default(this, id, null, 2, null);
        object = new ScreenshotResultProto(status, (String)object, string2, string3, currentScreenshotFileName, null, string4);
        map.put(id, (ScreenshotResultProto)object);
    }

    static /* synthetic */ void reportResult$default(SkiaTestAlbum skiaTestAlbum, ScreenshotResultProto.Status status, String string, byte[] byArray, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        skiaTestAlbum.reportResult(status, string, byArray, string2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/test/junit4/SkiaTestAlbum$Report;", "", "screenshots", "", "", "Landroidx/compose/ui/test/junit4/ScreenshotResultProto;", "(Ljava/util/Map;)V", "getScreenshots", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "ui-test-junit4"})
    @StabilityInferred(parameters=0)
    public static final class Report {
        @NotNull
        private final Map<String, ScreenshotResultProto> screenshots;
        public static final int $stable = 8;

        public Report(@NotNull Map<String, ScreenshotResultProto> screenshots) {
            Intrinsics.checkNotNullParameter(screenshots, (String)"screenshots");
            this.screenshots = screenshots;
        }

        @NotNull
        public final Map<String, ScreenshotResultProto> getScreenshots() {
            return this.screenshots;
        }

        @NotNull
        public final Map<String, ScreenshotResultProto> component1() {
            return this.screenshots;
        }

        @NotNull
        public final Report copy(@NotNull Map<String, ScreenshotResultProto> screenshots) {
            Intrinsics.checkNotNullParameter(screenshots, (String)"screenshots");
            return new Report(screenshots);
        }

        public static /* synthetic */ Report copy$default(Report report, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = report.screenshots;
            }
            return report.copy(map);
        }

        @NotNull
        public String toString() {
            return "Report(screenshots=" + this.screenshots + ')';
        }

        public int hashCode() {
            return ((Object)this.screenshots).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Report)) {
                return false;
            }
            Report report = (Report)other;
            return Intrinsics.areEqual(this.screenshots, report.screenshots);
        }
    }
}

