/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.platform.AwtFontUtils;
import androidx.compose.ui.text.platform.InternalFontApiChecker;
import androidx.compose.ui.text.platform.ReflectionUtil;
import java.awt.Font;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u001a\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u001f\"\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020\u0018J\n\u0010#\u001a\u0004\u0018\u00010\u0001H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010%\u001a\u00020\u001d2\b\b\u0002\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u0004\u0018\u00010\u0001*\u00020\u0018H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/compose/ui/text/platform/AwtFontUtils;", "", "()V", "CFontClass", "Ljava/lang/Class;", "CompositeFontClass", "kotlin.jvm.PlatformType", "CompositeFont_getSlotFontMethod", "Ljava/lang/reflect/Method;", "Font2DClass", "Font2DHandle_font2DField", "Ljava/lang/reflect/Field;", "Font2D_getFamilyNameMethod", "Font2D_getTypographicFamilyNameMethod", "Font2D_handleField", "FontManagerClass", "FontManagerFactoryClass", "FontManagerFactory_getInstanceMethod", "FontManager_findFont2DMethod", "LOGICAL_FALLBACK", "", "PhysicalFontClass", "font2DHandlesCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/awt/Font;", "isAbleToResolveFontProperties", "", "getFont2DMethodOrNull", "methodName", "", "parameters", "", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getPreferredFontFamilyName", "font", "getSunFontManagerInstance", "resolvePhysicalFontFamilyNameOrNull", "familyName", "style", "obtainFont2DOrNull", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAwtFontUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtFontUtils.kt\nandroidx/compose/ui/text/platform/AwtFontUtils\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n72#2,2:173\n1#3:175\n*S KotlinDebug\n*F\n+ 1 AwtFontUtils.kt\nandroidx/compose/ui/text/platform/AwtFontUtils\n*L\n156#1:173,2\n156#1:175\n*E\n"})
public final class AwtFontUtils {
    @NotNull
    public static final AwtFontUtils INSTANCE = new AwtFontUtils();
    private static final Class<?> FontManagerFactoryClass;
    private static final Class<?> FontManagerClass;
    private static final Class<?> Font2DClass;
    private static final Class<?> CompositeFontClass;
    private static final Class<?> PhysicalFontClass;
    @Nullable
    private static final Class<?> CFontClass;
    @Nullable
    private static final Method FontManagerFactory_getInstanceMethod;
    @Nullable
    private static final Method FontManager_findFont2DMethod;
    @Nullable
    private static final Method Font2D_getTypographicFamilyNameMethod;
    @Nullable
    private static final Method Font2D_getFamilyNameMethod;
    @Nullable
    private static final Field Font2D_handleField;
    @Nullable
    private static final Field Font2DHandle_font2DField;
    @Nullable
    private static final Method CompositeFont_getSlotFontMethod;
    private static final int LOGICAL_FALLBACK = 2;
    @NotNull
    private static final ConcurrentHashMap<Font, Object> font2DHandlesCache;
    private static final boolean isAbleToResolveFontProperties;
    public static final int $stable;

    private AwtFontUtils() {
    }

    @Nullable
    public final String resolvePhysicalFontFamilyNameOrNull(@NotNull String familyName, int style) {
        String string;
        Object object;
        Object object2;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        if (!isAbleToResolveFontProperties) {
            return null;
        }
        Object fontManager = this.getSunFontManagerInstance();
        Method method = FontManager_findFont2DMethod;
        if (method != null) {
            objectArray = new Object[]{familyName, style, 2};
            object2 = method.invoke(fontManager, objectArray);
        } else {
            object2 = object = null;
        }
        if (object == null) {
            return null;
        }
        Object font2D = object;
        if (CompositeFontClass.isInstance(font2D)) {
            Object object3;
            Object object4;
            Method method2 = CompositeFont_getSlotFontMethod;
            if (method2 != null) {
                objectArray = new Object[]{0};
                object4 = method2.invoke(font2D, objectArray);
            } else {
                object4 = null;
            }
            Object physicalFontObject = object4;
            Method method3 = Font2D_getFamilyNameMethod;
            if (method3 != null) {
                objectArray = new Object[]{Locale.getDefault()};
                object3 = method3.invoke(physicalFontObject, objectArray);
            } else {
                object3 = null;
            }
            string = (String)object3;
        } else {
            Class<?> clazz = CFontClass;
            boolean bl = clazz != null ? clazz.isInstance(font2D) : false;
            if (bl) {
                String nativeFontName = ReflectionUtil.INSTANCE.getFieldValueOrNull(CFontClass, font2D, String.class, "nativeFontName");
                string = this.getPreferredFontFamilyName(new Font(nativeFontName, 0, 10));
            } else if (PhysicalFontClass.isInstance(font2D)) {
                Method method4 = Font2D_getTypographicFamilyNameMethod;
                string = (String)(method4 != null ? method4.invoke(font2D, new Object[0]) : null);
            } else {
                string = null;
            }
        }
        return string;
    }

    public static /* synthetic */ String resolvePhysicalFontFamilyNameOrNull$default(AwtFontUtils awtFontUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return awtFontUtils.resolvePhysicalFontFamilyNameOrNull(string, n);
    }

    @Nullable
    public final String getPreferredFontFamilyName(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        if (!isAbleToResolveFontProperties) {
            return null;
        }
        Object object = this.obtainFont2DOrNull(font);
        if (object == null) {
            return null;
        }
        Object font2D = object;
        Method method = Font2D_getTypographicFamilyNameMethod;
        Object object2 = method != null ? method.invoke(font2D, new Object[0]) : null;
        return object2 instanceof String ? (String)object2 : null;
    }

    private final Object obtainFont2DOrNull(Font $this$obtainFont2DOrNull) {
        ConcurrentMap $this$getOrPut$iv = font2DHandlesCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get($this$obtainFont2DOrNull);
        if (object == null) {
            Object object2;
            boolean bl = false;
            Object fontManager = INSTANCE.getSunFontManagerInstance();
            Method method = FontManager_findFont2DMethod;
            if (method != null) {
                Object[] objectArray = new Object[]{$this$obtainFont2DOrNull.getName(), $this$obtainFont2DOrNull.getStyle(), 2};
                object2 = method.invoke(fontManager, objectArray);
            } else {
                object2 = null;
            }
            Object font2D = object2;
            Field field = Font2D_handleField;
            Object default$iv = field != null ? field.get(font2D) : null;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent($this$obtainFont2DOrNull, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object handle = object;
        Field field = Font2DHandle_font2DField;
        return field != null ? field.get(handle) : null;
    }

    private final Object getSunFontManagerInstance() {
        Method method = FontManagerFactory_getInstanceMethod;
        return method != null ? method.invoke(null, new Object[0]) : null;
    }

    private final Method getFont2DMethodOrNull(String methodName, Class<?> ... parameters) {
        Class<?> clazz = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"Font2DClass");
        return ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, methodName, Arrays.copyOf(parameters, parameters.length));
    }

    private static final boolean Font2D_handleField$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean Font2DHandle_font2DField$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        InternalFontApiChecker.INSTANCE.isSunFontApiAccessible();
        FontManagerFactoryClass = Class.forName("sun.font.FontManagerFactory");
        FontManagerClass = Class.forName("sun.font.FontManager");
        Font2DClass = Class.forName("sun.font.Font2D");
        CompositeFontClass = Class.forName("sun.font.CompositeFont");
        PhysicalFontClass = Class.forName("sun.font.PhysicalFont");
        CFontClass = OsArch_jvmKt.getHostOs().isMacOS() ? Class.forName("sun.font.CFont") : null;
        Class<?> clazz = FontManagerFactoryClass;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"FontManagerFactoryClass");
        FontManagerFactory_getInstanceMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz, "getInstance", new Class[0]);
        Class<?> clazz2 = FontManagerClass;
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"FontManagerClass");
        Class[] classArray = new Class[3];
        classArray[0] = String.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        Intrinsics.checkNotNull(Integer.TYPE);
        FontManager_findFont2DMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz2, "findFont2D", classArray);
        Font2D_getTypographicFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getTypographicFamilyName", new Class[0]);
        classArray = new Class[]{Locale.class};
        Font2D_getFamilyNameMethod = INSTANCE.getFont2DMethodOrNull("getFamilyName", classArray);
        Class<?> clazz3 = Font2DClass;
        Intrinsics.checkNotNullExpressionValue(clazz3, (String)"Font2DClass");
        Font2D_handleField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz3, arg_0 -> AwtFontUtils.Font2D_handleField$lambda$0(Font2D_handleField.1.INSTANCE, arg_0));
        Class<?> clazz4 = Class.forName("sun.font.Font2DHandle");
        Intrinsics.checkNotNullExpressionValue(clazz4, (String)"forName(...)");
        Font2DHandle_font2DField = ReflectionUtil.INSTANCE.findFieldInHierarchy(clazz4, arg_0 -> AwtFontUtils.Font2DHandle_font2DField$lambda$1(Font2DHandle_font2DField.1.INSTANCE, arg_0));
        Class<?> clazz5 = CompositeFontClass;
        Intrinsics.checkNotNullExpressionValue(clazz5, (String)"CompositeFontClass");
        classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        CompositeFont_getSlotFontMethod = ReflectionUtil.INSTANCE.getDeclaredMethodOrNull(clazz5, "getSlotFont", classArray);
        font2DHandlesCache = new ConcurrentHashMap();
        isAbleToResolveFontProperties = InternalFontApiChecker.INSTANCE.isRunningOnJetBrainsRuntime() && InternalFontApiChecker.INSTANCE.isSunFontApiAccessible() && Font2D_getTypographicFamilyNameMethod != null;
        $stable = 8;
    }
}

