/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextForegroundStyle;
import androidx.compose.ui.text.style.TextOverflow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/text/TextPainter;", "", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "ui-text"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nTextPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPainter.kt\nandroidx/compose/ui/text/TextPainter\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,389:1\n54#2:390\n59#2:392\n85#3:391\n90#3:393\n53#3,3:395\n33#4:394\n*S KotlinDebug\n*F\n+ 1 TextPainter.kt\nandroidx/compose/ui/text/TextPainter\n*L\n57#1:390\n58#1:392\n57#1:391\n58#1:393\n59#1:395,3\n59#1:394\n*E\n"})
public final class TextPainter {
    @NotNull
    public static final TextPainter INSTANCE = new TextPainter();
    public static final int $stable;

    private TextPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        DrawStyle drawStyle;
        Shadow shadow;
        Shadow shadow2;
        TextDecoration textDecoration;
        SpanStyle style;
        TextDecoration textDecoration2;
        boolean needClipping;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        boolean bl = needClipping = textLayoutResult.getHasVisualOverflow() && !TextOverflow.equals-impl0(textLayoutResult.getLayoutInput().getOverflow-gIe3tQ8(), TextOverflow.Companion.getVisible-gIe3tQ8());
        if (needClipping) {
            long arg0$iv = textLayoutResult.getSize-YbymL2g();
            boolean bl2 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            float width = (int)(value$iv$iv >> 32);
            long arg0$iv2 = textLayoutResult.getSize-YbymL2g();
            boolean bl3 = false;
            long value$iv$iv2 = arg0$iv2;
            boolean $i$f$unpackInt2 = false;
            float height = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            boolean $i$f$Size = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(width);
            long v2$iv$iv = Float.floatToRawIntBits(height);
            Rect bounds = RectKt.Rect-tz77jQw((long)Offset.Companion.getZero-F1C5BW0(), (long)Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            canvas.save();
            Canvas.clipRect-mtrdD-E$default((Canvas)canvas, (Rect)bounds, (int)0, (int)2, null);
        }
        if ((textDecoration2 = (style = textLayoutResult.getLayoutInput().getStyle().getSpanStyle$ui_text()).getTextDecoration()) == null) {
            textDecoration2 = textDecoration = TextDecoration.Companion.getNone();
        }
        if ((shadow2 = style.getShadow()) == null) {
            shadow2 = shadow = Shadow.Companion.getNone();
        }
        if ((drawStyle = style.getDrawStyle()) == null) {
            drawStyle = (DrawStyle)Fill.INSTANCE;
        }
        DrawStyle drawStyle2 = drawStyle;
        try {
            Brush brush = style.getBrush();
            if (brush != null) {
                float alpha = style.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? style.getTextForegroundStyle$ui_text().getAlpha() : 1.0f;
                MultiParagraph.paint-hn5TExg$default(textLayoutResult.getMultiParagraph(), canvas, brush, alpha, shadow, textDecoration, drawStyle2, 0, 64, null);
            } else {
                long color = style.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? style.getTextForegroundStyle$ui_text().getColor-0d7_KjU() : Color.Companion.getBlack-0d7_KjU();
                MultiParagraph.paint-LG529CI$default(textLayoutResult.getMultiParagraph(), canvas, color, shadow, textDecoration, drawStyle2, 0, 32, null);
            }
        }
        finally {
            if (needClipping) {
                canvas.restore();
            }
        }
    }
}

