/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.ui.platform.l10n

import androidx.compose.ui.platform.Strings
import androidx.compose.ui.platform.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhHK() = mapOf(
    Strings.NextPage to "下一頁",
    Strings.PreviousPage to "上一頁",
    Strings.FirstPage to "第一頁",
    Strings.LastPage to "最後一頁",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhCN() = mapOf(
    Strings.NextPage to "下一页",
    Strings.PreviousPage to "上一页",
    Strings.FirstPage to "第一页",
    Strings.LastPage to "最后页",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zhTW() = mapOf(
    Strings.NextPage to "下一頁",
    Strings.PreviousPage to "上一頁",
    Strings.FirstPage to "第一頁",
    Strings.LastPage to "最後一頁",
)
