/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.base.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.base.parsers.HtmlParser;
import org.jetbrains.dokka.base.parsers.Parser;
import org.jetbrains.dokka.base.parsers.factories.DocTagsFromStringFactory;
import org.jetbrains.dokka.model.doc.DocTag;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/dokka/base/parsers/HtmlParser;", "Lorg/jetbrains/dokka/base/parsers/Parser;", "()V", "htmlToDocNode", "Lorg/jetbrains/dokka/model/doc/DocTag;", "string", "", "parseStringToDocNode", "extractedString", "preparse", "text", "replaceLinksWithHrefs", "javadoc", "NodeFilterImpl", "base"})
public final class HtmlParser
extends Parser {
    private final DocTag htmlToDocNode(String string) {
        Document document = Jsoup.parse((String)string);
        NodeFilterImpl nodeFilterImpl = new NodeFilterImpl();
        NodeTraversor.filter((NodeFilter)nodeFilterImpl, (Node)document.root());
        return nodeFilterImpl.collect();
    }

    private final String replaceLinksWithHrefs(String javadoc) {
        return new Regex("\\{@link .*?}").replace((CharSequence)javadoc, (Function1)replaceLinksWithHrefs.1.INSTANCE);
    }

    @Override
    @NotNull
    public DocTag parseStringToDocNode(@NotNull String extractedString) {
        Intrinsics.checkNotNullParameter((Object)extractedString, (String)"extractedString");
        return this.htmlToDocNode(extractedString);
    }

    @Override
    @NotNull
    public String preparse(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.replaceLinksWithHrefs(text);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\bJ\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u001a\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/dokka/base/parsers/HtmlParser$NodeFilterImpl;", "Lorg/jsoup/select/NodeFilter;", "(Lorg/jetbrains/dokka/base/parsers/HtmlParser;)V", "currentDepth", "", "nodesCache", "", "", "Lorg/jetbrains/dokka/model/doc/DocTag;", "collect", "head", "Lorg/jsoup/select/NodeFilter$FilterResult;", "node", "Lorg/jsoup/nodes/Node;", "depth", "tail", "base"})
    public final class NodeFilterImpl
    implements NodeFilter {
        private final Map<Integer, List<DocTag>> nodesCache;
        private int currentDepth;

        @NotNull
        public final DocTag collect() {
            List<DocTag> list = this.nodesCache.get(this.currentDepth);
            Intrinsics.checkNotNull(list);
            return list.get(0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public NodeFilter.FilterResult tail(@Nullable Node node, int depth) {
            DocTag docTag;
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            String nodeName = node2.nodeName();
            Attributes nodeAttributes = node.attributes();
            if (CollectionsKt.listOf((Object[])new String[]{"#document", "html", "head"}).contains(nodeName)) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            String body = null;
            Map params = null;
            if (Intrinsics.areEqual((Object)nodeName, (Object)"#text") ^ true) {
                void $this$mapTo$iv$iv;
                body = "";
                Attributes attributes = nodeAttributes;
                Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"nodeAttributes");
                Iterable $this$map$iv = (Iterable)attributes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Attribute attribute = (Attribute)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getKey(), (Object)it.getValue());
                    collection.add(pair);
                }
                params = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            } else {
                String string = nodeAttributes.get("#text");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeAttributes[\"#text\"]");
                body = string;
                params = MapsKt.emptyMap();
            }
            if (depth < this.currentDepth) {
                String string = nodeName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName");
                boolean bl = false;
                DocTag docTag2 = DocTagsFromStringFactory.getInstance$default(DocTagsFromStringFactory.INSTANCE, string, CollectionsKt.toList((Iterable)this.nodesCache.getOrDefault(this.currentDepth, new ArrayList())), params, body, null, 16, null);
                boolean bl2 = false;
                boolean bl3 = false;
                DocTag it = docTag2;
                boolean bl4 = false;
                boolean bl5 = false;
                this.nodesCache.put(this.currentDepth, new ArrayList());
                this.currentDepth = depth;
                docTag = docTag2;
            } else {
                String string = nodeName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName");
                docTag = DocTagsFromStringFactory.getInstance$default(DocTagsFromStringFactory.INSTANCE, string, CollectionsKt.emptyList(), params, body, null, 16, null);
            }
            DocTag docNode = docTag;
            boolean bl = false;
            Collection collection = this.nodesCache.getOrDefault(depth, new ArrayList());
            boolean bl6 = false;
            collection.add(docNode);
            return NodeFilter.FilterResult.CONTINUE;
        }

        @NotNull
        public NodeFilter.FilterResult head(@Nullable Node node, int depth) {
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            String nodeName = node2.nodeName();
            if (this.currentDepth < depth) {
                this.currentDepth = depth;
                boolean bl = false;
                this.nodesCache.put(this.currentDepth, new ArrayList());
            }
            if (CollectionsKt.listOf((Object[])new String[]{"#document", "html", "head"}).contains(nodeName)) {
                return NodeFilter.FilterResult.CONTINUE;
            }
            return NodeFilter.FilterResult.CONTINUE;
        }

        public NodeFilterImpl() {
            boolean bl = false;
            this.nodesCache = new LinkedHashMap();
        }
    }
}

