/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.base.parsers;

import com.intellij.psi.PsiElement;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.base.parsers.MarkdownParser$Companion$WhenMappings;
import org.jetbrains.dokka.base.parsers.Parser;
import org.jetbrains.dokka.base.parsers.factories.DocTagsFromIElementFactory;
import org.jetbrains.dokka.links.DRI;
import org.jetbrains.dokka.model.doc.Author;
import org.jetbrains.dokka.model.doc.Constructor;
import org.jetbrains.dokka.model.doc.CustomTagWrapper;
import org.jetbrains.dokka.model.doc.Description;
import org.jetbrains.dokka.model.doc.DocTag;
import org.jetbrains.dokka.model.doc.DocumentationLink;
import org.jetbrains.dokka.model.doc.DocumentationNode;
import org.jetbrains.dokka.model.doc.Param;
import org.jetbrains.dokka.model.doc.Property;
import org.jetbrains.dokka.model.doc.Receiver;
import org.jetbrains.dokka.model.doc.Return;
import org.jetbrains.dokka.model.doc.Sample;
import org.jetbrains.dokka.model.doc.See;
import org.jetbrains.dokka.model.doc.Since;
import org.jetbrains.dokka.model.doc.Suppress;
import org.jetbrains.dokka.model.doc.TagWrapper;
import org.jetbrains.dokka.model.doc.Text;
import org.jetbrains.dokka.model.doc.Throws;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 D2\u00020\u0001:\u0001DB\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001a0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0004H\u0016J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u00102\u001a\u00020\u0004H\u0002J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00106\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00108\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u00109\u001a\b\u0012\u0004\u0012\u00020\u000e0\n*\b\u0012\u0004\u0012\u00020\u00100\nH\u0002J \u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0\n*\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010;\u001a\u00020*H\u0002J\u0018\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\n*\b\u0012\u0004\u0012\u00020\u00100\nH\u0002J\u001a\u0010=\u001a\u00020>*\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010?\u001a\u00020>*\u00020\u0004H\u0002J\u0018\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00100\n*\b\u0012\u0004\u0012\u00020\u00100\nH\u0002J\u0018\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00100\n*\b\u0012\u0004\u0012\u00020\u00100\nH\u0002J\f\u0010B\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0018\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000e0\n*\b\u0012\u0004\u0012\u00020\u000e0\nH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/dokka/base/parsers/MarkdownParser;", "Lorg/jetbrains/dokka/base/parsers/Parser;", "externalDri", "Lkotlin/Function1;", "", "Lorg/jetbrains/dokka/links/DRI;", "(Lkotlin/jvm/functions/Function1;)V", "destinationLinksMap", "", "notLeafNodes", "", "Lorg/intellij/markdown/IElementType;", "text", "autoLinksHandler", "Lorg/jetbrains/dokka/model/doc/DocTag;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "blockquotesHandler", "cellHandler", "codeBlocksHandler", "codeFencesHandler", "codeLineHandler", "codeSpansHandler", "defaultHandler", "emphasisHandler", "getAllDestinationLinks", "Lkotlin/Pair;", "headerHandler", "headersHandler", "horizontalRulesHandler", "imagesHandler", "inlineLinksHandler", "linksHandler", "linkText", "link", "linkTitle", "listsHandler", "markdownFileHandler", "mergedLeafNode", "Lorg/intellij/markdown/ast/LeafASTNode;", "nodes", "index", "", "startOffset", "sIndex", "parseStringToDocNode", "extractedString", "preparse", "referenceLinksHandler", "resolveDRI", "mdLink", "rowHandler", "strikeThroughHandler", "strongHandler", "tableHandler", "textHandler", "visitNode", "evaluateChildren", "evaluateChildrenWithDroppedEnclosingTokens", "count", "filterTabSeparators", "isNotLeaf", "", "isRemoteLink", "mergeLeafASTNodes", "removeUselessTokens", "transform", "trimSurroundingTokensIfText", "Companion", "base"})
public class MarkdownParser
extends Parser {
    private Map<String, String> destinationLinksMap;
    private String text;
    private final List<IElementType> notLeafNodes;
    private final Function1<String, DRI> externalDri;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public DocTag parseStringToDocNode(@NotNull String extractedString) {
        Intrinsics.checkNotNullParameter((Object)extractedString, (String)"extractedString");
        GFMFlavourDescriptor gfmFlavourDescriptor = new GFMFlavourDescriptor();
        ASTNode markdownAstRoot = new org.intellij.markdown.parser.MarkdownParser((MarkdownFlavourDescriptor)gfmFlavourDescriptor).buildMarkdownTreeFromString(extractedString);
        this.destinationLinksMap = MapsKt.toMap((Iterable)this.getAllDestinationLinks(extractedString, markdownAstRoot));
        this.text = extractedString;
        return this.visitNode(markdownAstRoot);
    }

    @Override
    @NotNull
    public String preparse(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return text;
    }

    private final DocTag headersHandler(ASTNode node) {
        Object v0;
        DocTagsFromIElementFactory docTagsFromIElementFactory;
        IElementType iElementType;
        MarkdownParser markdownParser;
        block2: {
            Iterable iterable = node.getChildren();
            markdownParser = this;
            iElementType = node.getType();
            docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ASTNode it = (ASTNode)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.ATX_CONTENT)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Object var13_13 = v0;
        ASTNode aSTNode = var13_13;
        if (aSTNode == null) {
            throw (Throwable)new IllegalStateException("Wrong AST Tree. ATX Header does not contain expected content");
        }
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, markdownParser.visitNode(aSTNode).getChildren(), null, null, null, 28, null);
    }

    private final DocTag horizontalRulesHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.HORIZONTAL_RULE, null, null, null, null, 30, null);
    }

    private final DocTag emphasisHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), this.evaluateChildrenWithDroppedEnclosingTokens(node.getChildren(), 1), null, null, null, 28, null);
    }

    private final DocTag strongHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), this.evaluateChildrenWithDroppedEnclosingTokens(node.getChildren(), 2), null, null, null, 28, null);
    }

    private final List<DocTag> evaluateChildrenWithDroppedEnclosingTokens(List<? extends ASTNode> $this$evaluateChildrenWithDroppedEnclosingTokens, int count) {
        return this.evaluateChildren(CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)$this$evaluateChildrenWithDroppedEnclosingTokens, (int)count), (int)count));
    }

    /*
     * WARNING - void declaration
     */
    private final DocTag blockquotesHandler(ASTNode node) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Iterable iterable = node.getChildren();
        MarkdownParser markdownParser = this;
        IElementType iElementType = node.getType();
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$filterIsInstance = false;
        void var4_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CompositeASTNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, markdownParser.evaluateChildren(list), null, null, null, 28, null);
    }

    /*
     * WARNING - void declaration
     */
    private final DocTag listsHandler(ASTNode node) {
        Map map2;
        Collection<DocTag> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        Object nestedList;
        ListItemCompositeNode it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = node.getChildren();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ListItemCompositeNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (ListItemCompositeNode)element$iv$iv;
            boolean bl = false;
            if (CollectionsKt.listOf((Object[])new IElementType[]{MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.UNORDERED_LIST}).contains(((ASTNode)CollectionsKt.last((List)it.getChildren())).getType())) {
                nestedList = (ASTNode)CollectionsKt.last((List)it.getChildren());
                List list2 = it.getChildren();
                if (list2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<org.intellij.markdown.ast.ASTNode>");
                }
                TypeIntrinsics.asMutableList((Object)list2).remove(CollectionsKt.getLastIndex((List)it.getChildren()));
                list = CollectionsKt.listOf((Object[])new ASTNode[]{(ASTNode)it, nestedList});
            } else {
                list = CollectionsKt.listOf((Object)it);
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List children = (List)destination$iv$iv;
        $this$flatMap$iv = children;
        IElementType iElementType = node.getType();
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DocTag docTag;
            list$iv$iv = (ASTNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) {
                void $this$filterIsInstanceTo$iv$iv2;
                void $this$filterIsInstance$iv2;
                nestedList = it.getChildren();
                MarkdownParser markdownParser = this;
                IElementType iElementType2 = it.getType();
                DocTagsFromIElementFactory docTagsFromIElementFactory2 = DocTagsFromIElementFactory.INSTANCE;
                boolean $i$f$filterIsInstance2 = false;
                void var17_22 = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof CompositeASTNode)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv2;
                docTag = DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory2, iElementType2, markdownParser.evaluateChildren(list), null, null, null, 28, null);
            } else {
                docTag = this.visitNode((ASTNode)it);
            }
            DocTag docTag2 = docTag;
            collection.add(docTag2);
        }
        collection = (List)destination$iv$iv;
        if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.ORDERED_LIST)) {
            ASTNode listNumberNode = (ASTNode)CollectionsKt.first((List)((ASTNode)CollectionsKt.first((List)node.getChildren())).getChildren());
            String string = this.text;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            }
            String string2 = string;
            int n = listNumberNode.getStartOffset();
            int n2 = listNumberNode.getEndOffset();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string4;
            n = 0;
            String string5 = string2;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"start", (Object)StringsKt.dropLast((String)((Object)StringsKt.trim((CharSequence)string5)).toString(), (int)1)));
        } else {
            map2 = MapsKt.emptyMap();
        }
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, (List)collection, map2, null, null, 24, null);
    }

    private final DRI resolveDRI(String mdLink) {
        DRI dRI;
        String string = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)mdLink, (CharSequence)"["), (CharSequence)"]");
        boolean bl = false;
        boolean bl2 = false;
        String link = string;
        boolean bl3 = false;
        try {
            new URL(link);
            dRI = null;
        }
        catch (MalformedURLException e) {
            dRI = (DRI)this.externalDri.invoke((Object)link);
        }
        return dRI;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> getAllDestinationLinks(String text, ASTNode node) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        List list;
        Collection collection;
        void $this$mapTo$iv$iv;
        ASTNode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = node.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_DEFINITION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ASTNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = text;
            int n = ((ASTNode)it.getChildren().get(0)).getStartOffset();
            int n2 = ((ASTNode)it.getChildren().get(0)).getEndOffset();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n = 0;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            string = text;
            n = ((ASTNode)it.getChildren().get(2)).getStartOffset();
            n2 = ((ASTNode)it.getChildren().get(2)).getEndOffset();
            bl2 = false;
            String string6 = string;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            list = TuplesKt.to((Object)string5, (Object)string7);
            collection.add(list);
        }
        $this$map$iv = node.getChildren();
        collection = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CompositeASTNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        $this$filterIsInstance$iv = list;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (CompositeASTNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getAllDestinationLinks(text, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    private final DocTag referenceLinksHandler(ASTNode node) {
        ASTNode aSTNode;
        Object v2;
        int n;
        ASTNode linkLabel;
        block10: {
            Object v0;
            Object object2;
            block9: {
                Iterable iterable = node.getChildren();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object object2 : iterable2) {
                    ASTNode it = (ASTNode)object2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_LABEL)) continue;
                    v0 = object2;
                    break block9;
                }
                v0 = null;
            }
            ASTNode aSTNode2 = v0;
            if (aSTNode2 == null) {
                throw (Throwable)new IllegalStateException("Wrong AST Tree. Reference link does not contain expected content");
            }
            linkLabel = aSTNode2;
            List list = node.getChildren();
            boolean bl = false;
            List list2 = list;
            n = 0;
            object2 = list2.listIterator(list2.size());
            while (object2.hasPrevious()) {
                Object e = object2.previous();
                ASTNode it = (ASTNode)e;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                v2 = e;
                break block10;
            }
            v2 = null;
        }
        if ((aSTNode = (ASTNode)v2) == null) {
            aSTNode = linkLabel;
        }
        ASTNode linkText = aSTNode;
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        String string2 = string;
        int n2 = linkLabel.getStartOffset();
        n = linkLabel.getEndOffset();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n2, n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String linkKey = string4;
        Map<String, String> map2 = this.destinationLinksMap;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"destinationLinksMap");
        }
        String string5 = linkKey;
        n = 0;
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        String string8 = map2.get(string7);
        if (string8 == null) {
            string8 = linkKey;
        }
        String link = string8;
        return MarkdownParser.linksHandler$default(this, linkText, link, null, 4, null);
    }

    private final DocTag inlineLinksHandler(ASTNode node) {
        Object v4;
        int n;
        ASTNode linkDestination;
        ASTNode linkText;
        block9: {
            Object v2;
            block8: {
                Object v0;
                block7: {
                    Iterable iterable = node.getChildren();
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object object : iterable2) {
                        ASTNode it = (ASTNode)object;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                        v0 = object;
                        break block7;
                    }
                    v0 = null;
                }
                ASTNode aSTNode = v0;
                if (aSTNode == null) {
                    throw (Throwable)new IllegalStateException("Wrong AST Tree. Inline link does not contain expected content");
                }
                linkText = aSTNode;
                Iterable iterable = node.getChildren();
                boolean bl = false;
                Iterable iterable3 = iterable;
                boolean bl4 = false;
                for (Object object : iterable3) {
                    ASTNode it = (ASTNode)object;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_DESTINATION)) continue;
                    v2 = object;
                    break block8;
                }
                v2 = null;
            }
            ASTNode aSTNode = v2;
            if (aSTNode == null) {
                throw (Throwable)new IllegalStateException("Wrong AST Tree. Inline link does not contain expected content");
            }
            linkDestination = aSTNode;
            Iterable iterable = node.getChildren();
            boolean bl = false;
            Iterable iterable4 = iterable;
            n = 0;
            for (Object e : iterable4) {
                ASTNode it = (ASTNode)e;
                boolean bl6 = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TITLE)) continue;
                v4 = e;
                break block9;
            }
            v4 = null;
        }
        ASTNode linkTitle = v4;
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        String string2 = string;
        int n2 = linkDestination.getStartOffset();
        n = linkDestination.getEndOffset();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n2, n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String link = string4;
        return this.linksHandler(linkText, link, linkTitle);
    }

    private final DocTag markdownFileHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), this.evaluateChildren(node.getChildren()), null, null, null, 28, null);
    }

    private final DocTag autoLinksHandler(ASTNode node) {
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        String string2 = string;
        int n = node.getStartOffset() + 1;
        int n2 = node.getEndOffset() - 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String link = string4;
        return MarkdownParser.linksHandler$default(this, node, link, null, 4, null);
    }

    private final DocTag linksHandler(ASTNode linkText, String link, ASTNode linkTitle) {
        DocTag docTag;
        Map params;
        String string;
        DRI dri = this.resolveDRI(link);
        if (linkTitle == null) {
            string = link;
        } else {
            String string2 = this.text;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            }
            String string3 = string2;
            int n = linkTitle.getStartOffset() + 1;
            int n2 = linkTitle.getEndOffset() - 1;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        String linkTextString = string;
        Map map2 = params = linkTitle == null ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"href", (Object)link)) : MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"href", (Object)link), TuplesKt.to((Object)"title", (Object)linkTextString)});
        if (dri == null && !this.isRemoteLink(link)) {
            DRI dRI = null;
            String string6 = StringsKt.removeSurrounding((String)linkTextString, (CharSequence)"[", (CharSequence)"]");
            List<DocTag> list = this.evaluateChildren(CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)linkText.getChildren(), (int)1), (int)1));
            Map map3 = params;
            docTag = DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.TEXT, list, map3, string6, dRI, 16, null);
        } else {
            DRI dRI = dri;
            String string7 = null;
            List<DocTag> list = this.evaluateChildren(CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)linkText.getChildren(), (int)1), (int)1));
            Map map4 = params;
            docTag = DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownElementTypes.INLINE_LINK, list, map4, string7, dRI, 8, null);
        }
        return docTag;
    }

    static /* synthetic */ DocTag linksHandler$default(MarkdownParser markdownParser, ASTNode aSTNode, String string, ASTNode aSTNode2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: linksHandler");
        }
        if ((n & 4) != 0) {
            aSTNode2 = null;
        }
        return markdownParser.linksHandler(aSTNode, string, aSTNode2);
    }

    private final DocTag codeLineHandler(ASTNode node) {
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        String string2 = string;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownElementTypes.CODE_BLOCK, null, null, string4, null, 22, null);
    }

    private final DocTag textHandler(ASTNode node) {
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        String string2 = string;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.TEXT, null, null, this.transform(string4), null, 22, null);
    }

    private final DocTag strikeThroughHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), this.evaluateChildrenWithDroppedEnclosingTokens(node.getChildren(), 2), null, null, null, 28, null);
    }

    private final DocTag tableHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, GFMElementTypes.TABLE, this.evaluateChildren(this.filterTabSeparators(node.getChildren())), null, null, null, 28, null);
    }

    private final DocTag headerHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, GFMElementTypes.HEADER, this.evaluateChildren(this.filterTabSeparators(node.getChildren())), null, null, null, 28, null);
    }

    private final DocTag rowHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, GFMElementTypes.ROW, this.evaluateChildren(this.filterTabSeparators(node.getChildren())), null, null, null, 28, null);
    }

    private final DocTag cellHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, GFMTokenTypes.CELL, this.trimSurroundingTokensIfText(this.evaluateChildren(this.filterTabSeparators(node.getChildren()))), null, null, null, 28, null);
    }

    private final boolean isRemoteLink(String $this$isRemoteLink) {
        boolean bl;
        try {
            new URL($this$isRemoteLink);
            bl = true;
        }
        catch (MalformedURLException e) {
            bl = false;
        }
        return bl;
    }

    private final DocTag imagesHandler(ASTNode node) {
        Object object;
        Object src;
        block17: {
            block16: {
                int n;
                int n2;
                ASTNode description;
                boolean bl;
                block15: {
                    Object object2;
                    block14: {
                        Object object3;
                        ASTNode destination;
                        block13: {
                            Object v0;
                            Object it;
                            Object object42;
                            List $this$with;
                            block12: {
                                List list = ((ASTNode)CollectionsKt.last((List)node.getChildren())).getChildren();
                                boolean bl2 = false;
                                boolean bl3 = false;
                                $this$with = list;
                                boolean bl4 = false;
                                Iterable iterable = $this$with;
                                boolean bl5 = false;
                                Iterable iterable2 = iterable;
                                boolean bl6 = false;
                                for (Object object42 : iterable2) {
                                    it = (ASTNode)object42;
                                    boolean bl7 = false;
                                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_DESTINATION)) continue;
                                    v0 = object42;
                                    break block12;
                                }
                                v0 = null;
                            }
                            destination = v0;
                            Iterable iterable = $this$with;
                            boolean bl8 = false;
                            Iterable iterable3 = iterable;
                            bl = false;
                            object42 = iterable3.iterator();
                            while (object42.hasNext()) {
                                Object it2 = it = object42.next();
                                boolean bl9 = false;
                                if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                                object3 = it;
                                break block13;
                            }
                            object3 = null;
                        }
                        description = object3;
                        object2 = destination;
                        if (object2 == null) break block14;
                        ASTNode aSTNode = object2;
                        boolean bl10 = false;
                        bl = false;
                        ASTNode it = aSTNode;
                        boolean bl11 = false;
                        String string = this.text;
                        if (string == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                        }
                        String it2 = string;
                        int n3 = it.getStartOffset();
                        n2 = it.getEndOffset();
                        n = 0;
                        String string2 = it2;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n3, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"href", (Object)string3));
                        if (object2 != null) break block15;
                    }
                    object2 = src = MapsKt.emptyMap();
                }
                if ((object = description) == null) break block16;
                ASTNode aSTNode = object;
                bl = false;
                boolean bl12 = false;
                ASTNode it = aSTNode;
                boolean bl13 = false;
                String string = this.text;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                }
                String string4 = string;
                n2 = it.getStartOffset() + 1;
                n = it.getEndOffset() - 1;
                boolean bl14 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = MapsKt.mapOf((Pair)TuplesKt.to((Object)"alt", (Object)string6));
                if (object != null) break block17;
            }
            object = MapsKt.emptyMap();
        }
        Object alt = object;
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), null, MapsKt.plus((Map)src, (Map)alt), null, null, 26, null);
    }

    private final DocTag codeSpansHandler(ASTNode node) {
        IElementType iElementType = node.getType();
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        String string2 = string;
        int n = node.getStartOffset() + 1;
        int n2 = node.getEndOffset() - 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, iElementType, CollectionsKt.listOf((Object)DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.TEXT, null, null, StringsKt.trimIndent((String)StringsKt.replace$default((String)string4, (char)'\n', (char)' ', (boolean)false, (int)4, null)), null, 22, null)), null, null, null, 28, null);
    }

    /*
     * WARNING - void declaration
     */
    private final DocTag codeFencesHandler(ASTNode node) {
        Object object;
        Object object2;
        IElementType iElementType;
        DocTagsFromIElementFactory docTagsFromIElementFactory;
        block14: {
            block13: {
                void it;
                Iterator iterator;
                Object object32;
                boolean bl;
                Object object4;
                DocTagsFromIElementFactory docTagsFromIElementFactory2;
                IElementType iElementType2;
                Object object5;
                Iterable iterable;
                block12: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list;
                    Iterable $this$dropLastWhile$iv;
                    ASTNode it2;
                    List $this$dropWhile$iv;
                    iterable = node.getChildren();
                    object5 = this;
                    iElementType2 = node.getType();
                    docTagsFromIElementFactory2 = DocTagsFromIElementFactory.INSTANCE;
                    boolean $i$f$dropWhile = false;
                    boolean yielding$iv = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : $this$dropWhile$iv) {
                        if (yielding$iv) {
                            list$iv.add(item$iv);
                            continue;
                        }
                        it2 = (ASTNode)item$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) ^ true) continue;
                        list$iv.add(item$iv);
                        yielding$iv = true;
                    }
                    object4 = list$iv;
                    $this$dropWhile$iv = object4;
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            ASTNode it3 = (ASTNode)iterator$iv.previous();
                            boolean bl3 = false;
                            if (Intrinsics.areEqual((Object)it3.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) ^ true) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    object4 = list;
                    $this$dropLastWhile$iv = (Iterable)object4;
                    boolean $i$f$map = false;
                    void iterator$iv = $this$map$iv;
                    Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it4;
                        ASTNode bl2 = (ASTNode)item$iv$iv;
                        object4 = destination$iv$iv22;
                        boolean bl4 = false;
                        void var15_28 = Intrinsics.areEqual((Object)it4.getType(), (Object)MarkdownTokenTypes.EOL) ? (ASTNode)new LeafASTNode(MarkdownTokenTypes.HARD_LINE_BREAK, 0, 0) : it4;
                        object4.add(var15_28);
                    }
                    object4 = (List)destination$iv$iv22;
                    iterable = node.getChildren();
                    object5 = ((MarkdownParser)object5).evaluateChildren((List<? extends ASTNode>)object4);
                    bl = false;
                    Iterable iterable2 = iterable;
                    boolean destination$iv$iv22 = false;
                    for (Object object32 : iterable2) {
                        it2 = (ASTNode)object32;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) continue;
                        iterator = object32;
                        break block12;
                    }
                    iterator = null;
                }
                object4 = iterator;
                docTagsFromIElementFactory = docTagsFromIElementFactory2;
                iElementType = iElementType2;
                object2 = object5;
                object = (ASTNode)object4;
                if (object == null) break block13;
                iterable = object;
                bl = false;
                boolean bl6 = false;
                Iterable destination$iv$iv22 = iterable;
                object5 = object2;
                iElementType2 = iElementType;
                docTagsFromIElementFactory2 = docTagsFromIElementFactory;
                boolean bl7 = false;
                String string = this.text;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"text");
                }
                object32 = string;
                int n = it.getStartOffset();
                int n2 = it.getEndOffset();
                boolean bl8 = false;
                Object object6 = object32;
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object6).substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"lang", (Object)string2));
                docTagsFromIElementFactory = docTagsFromIElementFactory2;
                iElementType = iElementType2;
                object2 = object5;
                object = object4;
                if (object != null) break block14;
            }
            object = MapsKt.emptyMap();
        }
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, (List)object2, (Map)object, null, null, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    private final DocTag codeBlocksHandler(ASTNode node) {
        Collection<DocTag> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.mergeLeafASTNodes(node.getChildren());
        IElementType iElementType = node.getType();
        DocTagsFromIElementFactory docTagsFromIElementFactory = DocTagsFromIElementFactory.INSTANCE;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (this.text == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"text");
            }
            int n = it.getStartOffset();
            int n2 = it.getEndOffset();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            DocTag docTag = DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownTokenTypes.TEXT, null, null, string3, null, 22, null);
            collection.add(docTag);
        }
        collection = (List)destination$iv$iv;
        return DocTagsFromIElementFactory.getInstance$default(docTagsFromIElementFactory, iElementType, (List)collection, null, null, null, 28, null);
    }

    private final DocTag defaultHandler(ASTNode node) {
        return DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, MarkdownElementTypes.PARAGRAPH, this.evaluateChildren(node.getChildren()), null, null, null, 28, null);
    }

    private final DocTag visitNode(ASTNode node) {
        IElementType iElementType = node.getType();
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6) ? this.headersHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HORIZONTAL_RULE) ? this.horizontalRulesHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG) ? this.strongHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH) ? this.emphasisHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK) ? this.referenceLinksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK) ? this.inlineLinksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.AUTOLINK) ? this.autoLinksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE) ? this.blockquotesHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST) ? this.listsHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) ? this.codeBlocksHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE) ? this.codeFencesHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN) ? this.codeSpansHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.IMAGE) ? this.imagesHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HARD_LINE_BREAK) ? DocTagsFromIElementFactory.getInstance$default(DocTagsFromIElementFactory.INSTANCE, node.getType(), null, null, null, null, 30, null) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE) ? this.codeLineHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) ? this.textHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.MARKDOWN_FILE) ? this.markdownFileHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.STRIKETHROUGH) ? this.strikeThroughHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.TABLE) ? this.tableHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.HEADER) ? this.headerHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.ROW) ? this.rowHandler(node) : (Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CELL) ? this.cellHandler(node) : this.defaultHandler(node))))))))))))))))))))));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> filterTabSeparators(List<? extends ASTNode> $this$filterTabSeparators) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $this$filterTabSeparators;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.TABLE_SEPARATOR)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> evaluateChildren(List<? extends ASTNode> $this$evaluateChildren) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.mergeLeafASTNodes(this.removeUselessTokens($this$evaluateChildren));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DocTag docTag = this.visitNode((ASTNode)it);
            collection.add(docTag);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ASTNode> removeUselessTokens(List<? extends ASTNode> $this$removeUselessTokens) {
        $this$filterIndexed$iv = $this$removeUselessTokens;
        $i$f$filterIndexed = false;
        var4_4 = $this$filterIndexed$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIndexedTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (T item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            var12_12 = index$iv$iv$iv++;
            var13_13 = false;
            if (var12_12 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            var14_14 = item$iv$iv$iv;
            index$iv$iv = var12_12;
            $i$a$-forEachIndexed-CollectionsKt___CollectionsKt$filterIndexedTo$1$iv$iv = false;
            var17_17 = (ASTNode)element$iv$iv;
            index = index$iv$iv;
            $i$a$-filterIndexed-MarkdownParser$removeUselessTokens$1 = false;
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.LINK_DEFINITION)) ** GOTO lbl-1000
            if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.EOL)) ** GOTO lbl-1000
            v0 = (ASTNode)CollectionsKt.getOrNull($this$removeUselessTokens, (int)(index - 1));
            if (!Intrinsics.areEqual((Object)(v0 != null ? v0.getType() : null), (Object)MarkdownTokenTypes.HARD_LINE_BREAK)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DocTag> trimSurroundingTokensIfText(List<? extends DocTag> $this$trimSurroundingTokensIfText) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$trimSurroundingTokensIfText;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            DocTag docTag;
            void elemTransformed;
            DocTag docTag2;
            boolean bl;
            String string;
            void elem;
            void index;
            int n = index$iv$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DocTag docTag3 = (DocTag)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            if (index == false && elem instanceof Text) {
                string = ((Text)elem).getBody();
                bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                docTag2 = (DocTag)Text.copy$default((Text)((Text)elem), (String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), null, null, (int)6, null);
            } else {
                docTag2 = elemTransformed = elem;
            }
            if (index == CollectionsKt.getLastIndex($this$trimSurroundingTokensIfText) && elemTransformed instanceof Text) {
                string = ((Text)elemTransformed).getBody();
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                docTag = (DocTag)Text.copy$default((Text)((Text)elemTransformed), (String)((Object)StringsKt.trimEnd((CharSequence)string3)).toString(), null, null, (int)6, null);
            } else {
                docTag = elemTransformed;
            }
            void var19_19 = docTag;
            collection.add(var19_19);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isNotLeaf(List<? extends ASTNode> $this$isNotLeaf, int index) {
        int n = index;
        return 0 <= n && CollectionsKt.getLastIndex($this$isNotLeaf) >= n ? $this$isNotLeaf.get(index) instanceof CompositeASTNode || this.notLeafNodes.contains($this$isNotLeaf.get(index).getType()) : false;
    }

    private final List<ASTNode> mergeLeafASTNodes(List<? extends ASTNode> $this$mergeLeafASTNodes) {
        boolean bl = false;
        List children = new ArrayList();
        for (int index = 0; index <= CollectionsKt.getLastIndex($this$mergeLeafASTNodes); ++index) {
            LeafASTNode leafASTNode;
            boolean bl2;
            Collection collection;
            LeafASTNode $this$run;
            boolean bl3;
            boolean bl4;
            if (this.isNotLeaf($this$mergeLeafASTNodes, index)) {
                Collection collection2 = children;
                ASTNode aSTNode = $this$mergeLeafASTNodes.get(index);
                boolean bl5 = false;
                collection2.add(aSTNode);
                continue;
            }
            int startOffset = $this$mergeLeafASTNodes.get(index).getStartOffset();
            int sIndex = index;
            while (index < CollectionsKt.getLastIndex($this$mergeLeafASTNodes)) {
                if (this.isNotLeaf($this$mergeLeafASTNodes, index + 1) || $this$mergeLeafASTNodes.get(index + 1).getStartOffset() != $this$mergeLeafASTNodes.get(index).getEndOffset()) {
                    if (this.mergedLeafNode($this$mergeLeafASTNodes, index, startOffset, sIndex) != null) {
                        LeafASTNode leafASTNode2;
                        bl4 = false;
                        bl3 = false;
                        $this$run = leafASTNode2;
                        boolean bl6 = false;
                        collection = children;
                        bl2 = false;
                        collection.add($this$run);
                    }
                    break;
                }
                ++index;
            }
            if (index != CollectionsKt.getLastIndex($this$mergeLeafASTNodes) || this.mergedLeafNode($this$mergeLeafASTNodes, index, startOffset, sIndex) == null) continue;
            bl4 = false;
            bl3 = false;
            $this$run = leafASTNode;
            boolean bl7 = false;
            collection = children;
            bl2 = false;
            collection.add($this$run);
        }
        return children;
    }

    private final LeafASTNode mergedLeafNode(List<? extends ASTNode> nodes, int index, int startOffset, int sIndex) {
        int endOffset = nodes.get(index).getEndOffset();
        String string = this.text;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        CharSequence charSequence = string;
        boolean bl = false;
        String string2 = charSequence;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = this.transform(string3);
        bl = false;
        String string4 = charSequence;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        bl = false;
        if (charSequence.length() > 0) {
            boolean bl2;
            block7: {
                Iterable $this$any$iv = nodes.subList(sIndex, index);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ASTNode it = (ASTNode)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_LINE)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            IElementType type = bl2 ? MarkdownTokenTypes.CODE_LINE : MarkdownTokenTypes.TEXT;
            return new LeafASTNode(type, startOffset, endOffset);
        }
        return null;
    }

    private final String transform(String $this$transform) {
        CharSequence charSequence = $this$transform;
        Regex regex = new Regex("\n\n+");
        String string = "";
        boolean bl = false;
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\n");
        string = " ";
        bl = false;
        charSequence = regex.replace(charSequence, string);
        regex = new Regex(" >+ +");
        string = " ";
        bl = false;
        return regex.replace(charSequence, string);
    }

    public MarkdownParser(@NotNull Function1<? super String, DRI> externalDri2) {
        Intrinsics.checkNotNullParameter(externalDri2, (String)"externalDri");
        this.externalDri = externalDri2;
        this.notLeafNodes = CollectionsKt.listOf((Object[])new IElementType[]{MarkdownTokenTypes.HORIZONTAL_RULE, MarkdownTokenTypes.HARD_LINE_BREAK});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0002J&\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/dokka/base/parsers/MarkdownParser$Companion;", "", "()V", "findParent", "Lcom/intellij/psi/PsiElement;", "kDoc", "getAllKDocTags", "", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "kDocImpl", "parseFromKDocTag", "Lorg/jetbrains/dokka/model/doc/DocumentationNode;", "kDocTag", "externalDri", "Lkotlin/Function1;", "", "Lorg/jetbrains/dokka/links/DRI;", "base"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DocumentationNode parseFromKDocTag(@Nullable KDocTag kDocTag, @NotNull Function1<? super String, DRI> externalDri2) {
            DocumentationNode documentationNode;
            Intrinsics.checkNotNullParameter(externalDri2, (String)"externalDri");
            if (kDocTag == null) {
                documentationNode = new DocumentationNode(CollectionsKt.emptyList());
            } else {
                Collection<TagWrapper> collection;
                void $this$mapTo$iv$iv;
                Function1<String, DocTag> $fun$parseStringToDocNode$1 = new Function1<String, DocTag>(externalDri2){
                    final /* synthetic */ Function1 $externalDri;

                    @NotNull
                    public final DocTag invoke(@NotNull String text) {
                        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                        return new MarkdownParser((Function1<? super String, DRI>)this.$externalDri).parseStringToDocNode(text);
                    }
                    {
                        this.$externalDri = function1;
                        super(1);
                    }
                };
                Iterable $this$map$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)kDocTag), (Iterable)this.getAllKDocTags(this.findParent((PsiElement)kDocTag)));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TagWrapper tagWrapper;
                    void it;
                    KDocTag kDocTag2 = (KDocTag)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    KDocKnownTag kDocKnownTag = it.getKnownTag();
                    if (kDocKnownTag == null) {
                        if (it.getName() == null) {
                            tagWrapper = (TagWrapper)new Description($fun$parseStringToDocNode$1.invoke(it.getContent()));
                        } else {
                            DocTag docTag = $fun$parseStringToDocNode$1.invoke(it.getContent());
                            String string = it.getName();
                            Intrinsics.checkNotNull((Object)string);
                            tagWrapper = (TagWrapper)new CustomTagWrapper(docTag, string);
                        }
                    } else {
                        switch (MarkdownParser$Companion$WhenMappings.$EnumSwitchMapping$0[kDocKnownTag.ordinal()]) {
                            case 1: {
                                tagWrapper = (TagWrapper)new Author($fun$parseStringToDocNode$1.invoke(it.getContent()));
                                break;
                            }
                            case 2: {
                                DocTag docTag = $fun$parseStringToDocNode$1.invoke(it.getContent());
                                String string = it.getSubjectName();
                                boolean bl2 = false;
                                String string2 = string;
                                if (string2 == null) {
                                    string2 = "";
                                }
                                tagWrapper = (TagWrapper)new Throws(docTag, string2);
                                break;
                            }
                            case 3: {
                                DocTag docTag = $fun$parseStringToDocNode$1.invoke(it.getContent());
                                String string = it.getSubjectName();
                                boolean bl2 = false;
                                String string3 = string;
                                if (string3 == null) {
                                    string3 = "";
                                }
                                tagWrapper = (TagWrapper)new Throws(docTag, string3);
                                break;
                            }
                            case 4: {
                                DocTag docTag = $fun$parseStringToDocNode$1.invoke(it.getContent());
                                String string = it.getSubjectName();
                                boolean bl2 = false;
                                String string4 = string;
                                if (string4 == null) {
                                    string4 = "";
                                }
                                tagWrapper = (TagWrapper)new Param(docTag, string4);
                                break;
                            }
                            case 5: {
                                tagWrapper = (TagWrapper)new Receiver($fun$parseStringToDocNode$1.invoke(it.getContent()));
                                break;
                            }
                            case 6: {
                                tagWrapper = (TagWrapper)new Return($fun$parseStringToDocNode$1.invoke(it.getContent()));
                                break;
                            }
                            case 7: {
                                void it2;
                                DocTag docTag = $fun$parseStringToDocNode$1.invoke(it.getContent());
                                String string = it.getSubjectName();
                                boolean bl2 = false;
                                String string5 = string;
                                if (string5 == null) {
                                    string5 = "";
                                }
                                string = $fun$parseStringToDocNode$1.invoke('[' + it.getSubjectName() + ']');
                                bl2 = false;
                                boolean bl3 = false;
                                String string6 = string;
                                String string7 = string5;
                                DocTag docTag2 = docTag;
                                boolean bl4 = false;
                                DocTag link = (DocTag)((DocTag)it2.getChildren().get(0)).getChildren().get(0);
                                DRI dRI = link instanceof DocumentationLink ? ((DocumentationLink)link).getDri() : null;
                                DRI dRI2 = dRI;
                                String string8 = string7;
                                DocTag docTag3 = docTag2;
                                tagWrapper = (TagWrapper)new See(docTag3, string8, dRI2);
                                break;
                            }
                            case 8: {
                                tagWrapper = (TagWrapper)new Since($fun$parseStringToDocNode$1.invoke(it.getContent()));
                                break;
                            }
                            case 9: {
                                tagWrapper = (TagWrapper)new Constructor($fun$parseStringToDocNode$1.invoke(it.getContent()));
                                break;
                            }
                            case 10: {
                                DocTag docTag = $fun$parseStringToDocNode$1.invoke(it.getContent());
                                String string = it.getSubjectName();
                                boolean bl2 = false;
                                String string9 = string;
                                if (string9 == null) {
                                    string9 = "";
                                }
                                tagWrapper = (TagWrapper)new Property(docTag, string9);
                                break;
                            }
                            case 11: {
                                DocTag docTag = $fun$parseStringToDocNode$1.invoke(it.getContent());
                                String string = it.getSubjectName();
                                boolean bl2 = false;
                                String string10 = string;
                                if (string10 == null) {
                                    string10 = "";
                                }
                                tagWrapper = (TagWrapper)new Sample(docTag, string10);
                                break;
                            }
                            case 12: {
                                tagWrapper = (TagWrapper)new Suppress($fun$parseStringToDocNode$1.invoke(it.getContent()));
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    TagWrapper tagWrapper2 = tagWrapper;
                    collection.add(tagWrapper2);
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                documentationNode = new DocumentationNode(list);
            }
            return documentationNode;
        }

        private final PsiElement findParent(PsiElement kDoc) {
            PsiElement psiElement;
            if (kDoc instanceof KDocSection) {
                PsiElement psiElement2 = ((KDocSection)kDoc).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"kDoc.parent");
                psiElement = this.findParent(psiElement2);
            } else {
                psiElement = kDoc;
            }
            return psiElement;
        }

        /*
         * WARNING - void declaration
         */
        private final List<KDocTag> getAllKDocTags(PsiElement kDocImpl) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterNotTo$iv$iv;
            PsiElement[] $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = kDocImpl.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"kDocImpl.children");
            PsiElement[] $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void var10_12 : $this$filterIsInstanceTo$iv$iv) {
                if (!(var10_12 instanceof KDocTag)) continue;
                destination$iv$iv.add(var10_12);
            }
            PsiElement[] $this$filterNot$iv = (PsiElement[])((List)destination$iv$iv);
            boolean $i$f$filterNot = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                KDocTag it = (KDocTag)element$iv$iv;
                boolean bl = false;
                if (it instanceof KDocSection) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            PsiElement[] psiElementArray3 = kDocImpl.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"kDocImpl.children");
            $this$filterNot$iv = psiElementArray3;
            Collection collection2 = collection;
            boolean $i$f$flatMap = false;
            $this$filterNotTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv;
            int n = ((Iterator<T>)iterator).length;
            for (int i = 0; i < n; ++i) {
                Iterator iterator2;
                Iterator it = iterator2 = iterator[i];
                boolean bl = false;
                Iterator iterator3 = it;
                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"it");
                Iterable list$iv$iv = Companion.getAllKDocTags((PsiElement)iterator3);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return CollectionsKt.plus((Collection)collection2, (Iterable)list);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

