/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.base.resolvers.shared;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.base.resolvers.shared.PackageList;
import org.jetbrains.dokka.base.resolvers.shared.RecognizedLinkFormat;
import org.jetbrains.dokka.base.resolvers.shared.UtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001c\u0010\u0004\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u001f\u0010\u001c\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0005H\u00c6\u0003J\u0015\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003JS\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001e\b\u0002\u0010\u0004\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u0016\u0010%\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u0006\u0010&\u001a\u00020\u0006J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R+\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\u0010R'\u0010\u0004\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lorg/jetbrains/dokka/base/resolvers/shared/PackageList;", "", "linkFormat", "Lorg/jetbrains/dokka/base/resolvers/shared/RecognizedLinkFormat;", "modules", "", "", "Lorg/jetbrains/dokka/base/resolvers/shared/Module;", "", "locations", "url", "Ljava/net/URL;", "(Lorg/jetbrains/dokka/base/resolvers/shared/RecognizedLinkFormat;Ljava/util/Map;Ljava/util/Map;Ljava/net/URL;)V", "getLinkFormat", "()Lorg/jetbrains/dokka/base/resolvers/shared/RecognizedLinkFormat;", "getLocations", "()Ljava/util/Map;", "moduleByPackage", "getModuleByPackage", "moduleByPackage$delegate", "Lkotlin/Lazy;", "getModules", "packages", "getPackages", "()Ljava/util/Set;", "getUrl", "()Ljava/net/URL;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "moduleFor", "packageName", "toString", "Companion", "plugin-base"})
public final class PackageList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RecognizedLinkFormat linkFormat;
    @NotNull
    private final Map<String, Set<String>> modules;
    @NotNull
    private final Map<String, String> locations;
    @NotNull
    private final URL url;
    @NotNull
    private final Lazy moduleByPackage$delegate;
    @NotNull
    public static final String PACKAGE_LIST_NAME = "package-list";
    @NotNull
    public static final String MODULE_DELIMITER = "module:";
    @NotNull
    public static final String DOKKA_PARAM_PREFIX = "$dokka";
    @NotNull
    public static final String SINGLE_MODULE_NAME = "";
    @NotNull
    private static final ConcurrentHashMap<Pair<URL, Integer>, PackageList> cache = new ConcurrentHashMap();

    public PackageList(@NotNull RecognizedLinkFormat linkFormat, @NotNull Map<String, ? extends Set<String>> modules, @NotNull Map<String, String> locations, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)linkFormat, (String)"linkFormat");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.linkFormat = linkFormat;
        this.modules = modules;
        this.locations = locations;
        this.url = url;
        this.moduleByPackage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, String>>(this){
            final /* synthetic */ PackageList this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<String, String> invoke() {
                Map map = new LinkedHashMap<K, V>();
                PackageList packageList = this.this$0;
                Map $this$invoke_u24lambda_u242 = map;
                boolean bl = false;
                Map<String, Set<String>> $this$forEach$iv = packageList.getModules();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Set<String>> element$iv;
                    Map.Entry<String, Set<String>> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String module = entry.getKey();
                    Set<String> packages = entry.getValue();
                    Iterable $this$forEach$iv2 = packages;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String pkg = (String)element$iv2;
                        boolean bl3 = false;
                        if ($this$invoke_u24lambda_u242.containsKey(pkg)) continue;
                        $this$invoke_u24lambda_u242.put(pkg, module);
                    }
                }
                return map;
            }
        }));
    }

    @NotNull
    public final RecognizedLinkFormat getLinkFormat() {
        return this.linkFormat;
    }

    @NotNull
    public final Map<String, Set<String>> getModules() {
        return this.modules;
    }

    @NotNull
    public final Map<String, String> getLocations() {
        return this.locations;
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    private final Map<String, String> getModuleByPackage() {
        Lazy lazy = this.moduleByPackage$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Set<String> getPackages() {
        return this.getModuleByPackage().keySet();
    }

    @Nullable
    public final String moduleFor(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.getModuleByPackage().get(packageName);
    }

    @NotNull
    public final RecognizedLinkFormat component1() {
        return this.linkFormat;
    }

    @NotNull
    public final Map<String, Set<String>> component2() {
        return this.modules;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.locations;
    }

    @NotNull
    public final URL component4() {
        return this.url;
    }

    @NotNull
    public final PackageList copy(@NotNull RecognizedLinkFormat linkFormat, @NotNull Map<String, ? extends Set<String>> modules, @NotNull Map<String, String> locations, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)linkFormat, (String)"linkFormat");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new PackageList(linkFormat, modules, locations, url);
    }

    public static /* synthetic */ PackageList copy$default(PackageList packageList, RecognizedLinkFormat recognizedLinkFormat, Map map, Map map2, URL uRL, int n, Object object) {
        if ((n & 1) != 0) {
            recognizedLinkFormat = packageList.linkFormat;
        }
        if ((n & 2) != 0) {
            map = packageList.modules;
        }
        if ((n & 4) != 0) {
            map2 = packageList.locations;
        }
        if ((n & 8) != 0) {
            uRL = packageList.url;
        }
        return packageList.copy(recognizedLinkFormat, map, map2, uRL);
    }

    @NotNull
    public String toString() {
        return "PackageList(linkFormat=" + this.linkFormat + ", modules=" + this.modules + ", locations=" + this.locations + ", url=" + this.url + ')';
    }

    public int hashCode() {
        int result = this.linkFormat.hashCode();
        result = result * 31 + ((Object)this.modules).hashCode();
        result = result * 31 + ((Object)this.locations).hashCode();
        result = result * 31 + this.url.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackageList)) {
            return false;
        }
        PackageList packageList = (PackageList)other;
        if (this.linkFormat != packageList.linkFormat) {
            return false;
        }
        if (!Intrinsics.areEqual(this.modules, packageList.modules)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.locations, packageList.locations)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.url, (Object)packageList.url);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\fH\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J)\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eH\u0002J,\u0010\u001f\u001a\u0018\u0012\b\u0012\u00060\u0004j\u0002` \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040!0\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eH\u0002J(\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001e0\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/dokka/base/resolvers/shared/PackageList$Companion;", "", "()V", "DOKKA_PARAM_PREFIX", "", "MODULE_DELIMITER", "PACKAGE_LIST_NAME", "SINGLE_MODULE_NAME", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "Ljava/net/URL;", "", "Lorg/jetbrains/dokka/base/resolvers/shared/PackageList;", "clearCache", "", "download", "url", "jdkVersion", "linkFormat", "Lorg/jetbrains/dokka/base/resolvers/shared/RecognizedLinkFormat;", "formatName", "load", "offlineMode", "", "loadWithoutCache", "loadWithoutCache$plugin_base", "splitLocations", "", "locations", "", "splitPackages", "Lorg/jetbrains/dokka/base/resolvers/shared/Module;", "", "packages", "splitParams", "params", "plugin-base"})
    @SourceDebugExtension(value={"SMAP\nPackageList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageList.kt\norg/jetbrains/dokka/base/resolvers/shared/PackageList$Companion\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n72#2,2:124\n1#3:126\n1#3:127\n1#3:132\n1#3:177\n54#4,4:128\n2707#5,10:133\n1007#5:150\n1041#5,3:151\n1044#5,3:161\n487#6,7:143\n381#6,7:154\n1557#7:164\n1628#7,3:165\n1187#7,2:168\n1261#7,4:170\n1797#7,3:174\n*E\n*S KotlinDebug\n*F\n+ 1 PackageList.kt\norg/jetbrains/dokka/base/resolvers/shared/PackageList$Companion\n*L\n61#1,2:124\n61#1:126\n83#1:132\n83#1,4:128\n83#1,10:133\n95#1:150\n95#1,3:151\n95#1,3:161\n87#1,7:143\n95#1,7:154\n97#1:164\n97#1,3:165\n98#1,2:168\n98#1,4:170\n101#1,3:174\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearCache() {
            cache.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PackageList load(@NotNull URL url, int jdkVersion, boolean offlineMode) {
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (offlineMode) {
                String string = url.getProtocol();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.protocol");
                String string2 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string2, (Object)"file")) {
                    return null;
                }
            }
            ConcurrentMap concurrentMap = cache;
            Pair key$iv = TuplesKt.to((Object)url, (Object)jdkVersion);
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                PackageList packageList = Companion.download(url, jdkVersion);
                if (packageList == null) {
                    return null;
                }
                PackageList default$iv = packageList;
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            return (PackageList)object;
        }

        public static /* synthetic */ PackageList load$default(Companion companion2, URL uRL, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return companion2.load(uRL, n, bl);
        }

        @Nullable
        public final PackageList loadWithoutCache$plugin_base(@NotNull URL url, int jdkVersion, boolean offlineMode) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (offlineMode) {
                String string = url.getProtocol();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.protocol");
                String string2 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string2, (Object)"file")) {
                    return null;
                }
            }
            return this.download(url, jdkVersion);
        }

        public static /* synthetic */ PackageList loadWithoutCache$plugin_base$default(Companion companion2, URL uRL, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return companion2.loadWithoutCache$plugin_base(uRL, n, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final PackageList download(URL url, int jdkVersion) {
            void $this$useLines$iv;
            Object $this$download_u24lambda_u241;
            Object object = this;
            try {
                $this$download_u24lambda_u241 = object;
                boolean bl = false;
                $this$download_u24lambda_u241 = Result.constructor-impl((Object)UtilsKt.readContent$default(url, 0, 0, 3, null));
            }
            catch (Throwable bl) {
                $this$download_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$download_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it = $this$download_u24lambda_u241 = throwable;
                boolean bl = false;
                System.out.println((Object)("Failed to download package-list from " + url + ", this might suggest that remote resource is not available, module is empty or dokka output got corrupted"));
                return null;
            }
            ResultKt.throwOnFailure((Object)object);
            InputStream packageListStream = (InputStream)object;
            $this$download_u24lambda_u241 = packageListStream;
            Charset it = Charsets.UTF_8;
            Closeable bl = new InputStreamReader((InputStream)$this$download_u24lambda_u241, it);
            int n = 8192;
            $this$download_u24lambda_u241 = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader((Reader)bl, n);
            boolean $i$f$useLines = false;
            bl = $this$useLines$iv;
            n = 8192;
            bl = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader((Reader)bl, n);
            Throwable throwable2 = null;
            try {
                BufferedReader it$iv = (BufferedReader)bl;
                boolean bl2 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl3 = false;
                Sequence $this$partition$iv = lines;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    String it2 = (String)element$iv;
                    boolean bl4 = false;
                    if (StringsKt.startsWith$default((String)it2, (String)PackageList.DOKKA_PARAM_PREFIX, (boolean)false, (int)2, null)) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                it$iv = new Pair(first$iv, second$iv);
            }
            catch (Throwable it$iv) {
                throwable2 = it$iv;
                throw it$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)bl, (Throwable)throwable2);
            }
            object = it$iv;
            List params = (List)object.component1();
            List packages = (List)object.component2();
            Map<String, List<String>> paramsMap = this.splitParams(params);
            List<String> list = paramsMap.get("format");
            RecognizedLinkFormat format = this.linkFormat(list != null ? (String)CollectionsKt.singleOrNull(list) : null, jdkVersion);
            List list2 = paramsMap.get("location");
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Map<String, String> $this$filterKeys$iv = this.splitLocations(list2);
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                String p0 = entry$iv.getKey();
                boolean $i$f$download$stub_for_inlining = false;
                boolean bl5 = false;
                boolean bl6 = ((CharSequence)p0).length() > 0;
                if (!bl6) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map locations = result$iv;
            Map<String, Set<String>> modulesMap = this.splitPackages(packages);
            return new PackageList(format, modulesMap, locations, url);
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, List<String>> splitParams(List<String> params) {
            void $this$groupByTo$iv$iv;
            Sequence $this$groupBy$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)params), (Function1)splitParams.1.INSTANCE);
            boolean $i$f$groupBy = false;
            Sequence sequence = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                String key;
                List list = (List)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = key = (String)list.get(0);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                List list2 = (List)element$iv$iv;
                List list3 = list$iv$iv;
                boolean bl3 = false;
                String value = (String)list2.get(1);
                list3.add(value);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> splitLocations(List<String> locations) {
            void $this$associateTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = locations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                object = new String[]{"\u001f"};
                collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])object, (boolean)false, (int)2, (int)2, null));
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                object = (List)element$iv$iv;
                boolean bl = false;
                String key = (String)object.get(0);
                String value = (String)object.get(1);
                object = TuplesKt.to((Object)key, (Object)value);
                map.put(object.getFirst(), object.getSecond());
            }
            return destination$iv$iv2;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, Set<String>> splitPackages(List<String> packages) {
            void $this$fold$iv;
            Iterable iterable = packages;
            Pair initial$iv = TuplesKt.to((Object)PackageList.SINGLE_MODULE_NAME, (Object)new LinkedHashMap());
            boolean $i$f$fold = false;
            Pair accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void el;
                String string = (String)element$iv;
                Pair pair = accumulator$iv;
                boolean bl = false;
                String lastModule = (String)pair.component1();
                Map acc = (Map)pair.component2();
                String currentModule = null;
                if (StringsKt.startsWith$default((String)el, (String)PackageList.MODULE_DELIMITER, (boolean)false, (int)2, null)) {
                    currentModule = StringsKt.substringAfter$default((String)el, (String)PackageList.MODULE_DELIMITER, null, (int)2, null);
                } else if (!StringsKt.isBlank((CharSequence)((CharSequence)el))) {
                    currentModule = lastModule;
                    acc.put(currentModule, SetsKt.plus((Set)acc.getOrDefault(lastModule, SetsKt.emptySet()), (Object)el));
                } else {
                    currentModule = lastModule;
                }
                accumulator$iv = TuplesKt.to((Object)currentModule, (Object)acc);
            }
            return (Map)accumulator$iv.getSecond();
        }

        private final RecognizedLinkFormat linkFormat(String formatName, int jdkVersion) {
            Object object;
            block3: {
                block2: {
                    object = formatName;
                    if (object == null) break block2;
                    String it = object;
                    boolean bl = false;
                    RecognizedLinkFormat recognizedLinkFormat = RecognizedLinkFormat.Companion.fromString(it);
                    object = recognizedLinkFormat;
                    if (recognizedLinkFormat != null) break block3;
                }
                object = jdkVersion < 8 ? RecognizedLinkFormat.Javadoc1 : (jdkVersion < 10 ? RecognizedLinkFormat.Javadoc8 : RecognizedLinkFormat.Javadoc10);
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

