/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Platform;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            ObjectArrays.checkElementNotNull(array[i2], i2);
        }
        return array;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element, int index2) {
        if (element == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element;
    }
}

