/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableAsList;
import java.util.Spliterator;
import java.util.Spliterators;

final class RegularImmutableSet<E>
extends ImmutableSet.Indexed<E> {
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(ObjectArrays.EMPTY_ARRAY, 0, null, 0);
    private final transient Object[] elements;
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] elements, int hashCode2, Object[] table2, int mask) {
        this.elements = elements;
        this.table = table2;
        this.mask = mask;
        this.hashCode = hashCode2;
    }

    @Override
    public boolean contains(Object target) {
        Object[] table2 = this.table;
        if (target == null || table2 == null) {
            return false;
        }
        int i2 = Hashing.smearedHash(target);
        Object candidate2;
        while ((candidate2 = table2[i2 &= this.mask]) != null) {
            if (candidate2.equals(target)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    E get(int i2) {
        return (E)this.elements[i2];
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1297);
    }

    @Override
    int copyIntoArray(Object[] dst, int offset2) {
        System.arraycopy(this.elements, 0, dst, offset2, this.elements.length);
        return offset2 + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.table == null ? ImmutableList.of() : new RegularImmutableAsList(this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

