/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Node;
import com.google.gwt.dev.js.rhino.TokenStream;

public class IRFactory {
    private TokenStream ts;

    public IRFactory(TokenStream ts) {
        this.ts = ts;
    }

    public Node createScript(Node body2) {
        Node result2 = new Node(147);
        Node children2 = body2.getFirstChild();
        if (children2 != null) {
            result2.addChildrenToBack(children2);
        }
        return result2;
    }

    public Node createLeaf(int nodeType, CodePosition location2) {
        return new Node(nodeType, location2);
    }

    public Node createLeaf(int nodeType, int nodeOp, CodePosition location2) {
        return new Node(nodeType, nodeOp, location2);
    }

    public int getLeafType(Node leaf) {
        return leaf.getType();
    }

    public Node createSwitch(CodePosition location2) {
        return new Node(115, location2);
    }

    public Node createVariables(CodePosition location2) {
        return new Node(123, location2);
    }

    public Node createExprStatement(Object expr, CodePosition location2) {
        return new Node(140, (Node)expr, location2);
    }

    public Node createName(String name, CodePosition location2) {
        return Node.newString(44, name, location2);
    }

    public Node createString(String string, CodePosition location2) {
        return Node.newString(string, location2);
    }

    public Node createIntNumber(double number, CodePosition location2) {
        return Node.newIntNumber(number, location2);
    }

    public Node createNumber(double number, CodePosition location2) {
        return Node.newNumber(number, location2);
    }

    public Node createCatch(Node varName, Node catchCond, Node stmts, CodePosition location2) {
        if (catchCond == null) {
            catchCond = new Node(109, 52, location2);
        }
        return new Node(125, varName, catchCond, stmts, location2);
    }

    public Node createThrow(Node expr, CodePosition location2) {
        return new Node(62, expr, location2);
    }

    public Node createReturn(Node expr, CodePosition location2) {
        return expr == null ? new Node(5, location2) : new Node(5, expr, location2);
    }

    public Node createLabel(Node label2, CodePosition location2) {
        Node result2 = new Node(136, location2);
        result2.addChildToBack(label2);
        return result2;
    }

    public Node createBreak(Node label2, CodePosition location2) {
        Node result2 = new Node(121, location2);
        if (label2 == null) {
            return result2;
        }
        result2.addChildToBack(label2);
        return result2;
    }

    public Node createContinue(Node label2, CodePosition location2) {
        Node result2 = new Node(122, location2);
        if (label2 == null) {
            return result2;
        }
        result2.addChildToBack(label2);
        return result2;
    }

    public Node createDebugger(CodePosition location2) {
        Node result2 = new Node(146, location2);
        return result2;
    }

    public Node createBlock(CodePosition location2) {
        return new Node(133, location2);
    }

    public Node createFunction(Node name, Node args, Node statements, CodePosition location2) {
        if (name == null) {
            name = this.createName("", location2);
        }
        return new Node(110, name, args, statements, location2);
    }

    public Node createWhile(Node cond, Node body2, CodePosition location2) {
        return new Node(118, cond, body2, location2);
    }

    public Node createDoWhile(Node body2, Node cond, CodePosition location2) {
        return new Node(119, body2, cond, location2);
    }

    public Node createFor(Node init, Node test, Node incr, Node body2, CodePosition location2) {
        return new Node(120, init, test, incr, body2, location2);
    }

    public Node createForIn(Node lhs, Node obj, Node body2, CodePosition location2) {
        return new Node(120, lhs, obj, body2, location2);
    }

    public Node createTryCatchFinally(Node tryblock, Node catchblocks, Node finallyblock, CodePosition location2) {
        if (finallyblock == null) {
            return new Node(75, tryblock, catchblocks, location2);
        }
        return new Node(75, tryblock, catchblocks, finallyblock, location2);
    }

    public Node createWith(Node obj, Node body2, CodePosition location2) {
        return new Node(124, obj, body2, location2);
    }

    public Node createArrayLiteral(Node obj) {
        return obj;
    }

    public Node createObjectLiteral(Node obj) {
        return obj;
    }

    public Node createRegExp(String string, String flags, CodePosition location2) {
        return flags.length() == 0 ? new Node(56, Node.newString(string, location2), location2) : new Node(56, Node.newString(string, location2), Node.newString(flags, location2), location2);
    }

    public Node createIf(Node cond, Node ifTrue, Node ifFalse, CodePosition location2) {
        if (ifFalse == null) {
            return new Node(113, cond, ifTrue, location2);
        }
        return new Node(113, cond, ifTrue, ifFalse, location2);
    }

    public Node createTernary(Node cond, Node ifTrue, Node ifFalse, CodePosition location2) {
        return new Node(98, cond, ifTrue, ifFalse, location2);
    }

    public Node createUnary(int nodeType, Node child, CodePosition location2) {
        return new Node(nodeType, child, location2);
    }

    public Node createUnary(int nodeType, int nodeOp, Node child, CodePosition location2) {
        return new Node(nodeType, child, nodeOp, location2);
    }

    public Node createBinary(int nodeType, Node left, Node right, CodePosition location2) {
        switch (nodeType) {
            case 108: {
                nodeType = 39;
                right.setType(46);
                break;
            }
            case 90: {
                nodeType = 41;
            }
        }
        return new Node(nodeType, left, right, location2);
    }

    public Node createBinary(int nodeType, int nodeOp, Node left, Node right, CodePosition location2) {
        if (nodeType == 97) {
            return this.createAssignment(nodeOp, left, right, location2);
        }
        return new Node(nodeType, left, right, nodeOp, location2);
    }

    public Node createAssignment(int nodeOp, Node left, Node right, CodePosition location2) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: 
            case 41: 
            case 44: {
                break;
            }
            default: {
                this.ts.reportSyntaxError("msg.bad.lhs.assign", null);
            }
        }
        return new Node(97, left, right, nodeOp, location2);
    }
}

