/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.cglib.core;

import com.google.inject.internal.asm.$Attribute;
import com.google.inject.internal.asm.$Type;
import com.google.inject.internal.cglib.core.$ClassInfo;
import com.google.inject.internal.cglib.core.$CodeGenerationException;
import com.google.inject.internal.cglib.core.$Constants;
import com.google.inject.internal.cglib.core.$MethodInfo;
import com.google.inject.internal.cglib.core.$Signature;
import com.google.inject.internal.cglib.core.$TypeUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class $ReflectUtils {
    private static final Map primitives = new HashMap(8);
    private static final Map transforms = new HashMap(8);
    private static final ClassLoader defaultLoader = (class$net$sf$cglib$core$ReflectUtils == null ? (class$net$sf$cglib$core$ReflectUtils = $ReflectUtils.class$("com.google.inject.internal.cglib.core.$ReflectUtils")) : class$net$sf$cglib$core$ReflectUtils).getClassLoader();
    private static Method DEFINE_CLASS;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final String[] CGLIB_PACKAGES;
    static /* synthetic */ Class class$net$sf$cglib$core$ReflectUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$security$ProtectionDomain;
    static /* synthetic */ Class class$java$lang$Object;

    private $ReflectUtils() {
    }

    public static $Type[] getExceptionTypes(Member member) {
        if (member instanceof Method) {
            return $TypeUtils.getTypes(((Method)member).getExceptionTypes());
        }
        if (member instanceof Constructor) {
            return $TypeUtils.getTypes(((Constructor)member).getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static $Signature getSignature(Member member) {
        if (member instanceof Method) {
            return new $Signature(member.getName(), $Type.getMethodDescriptor((Method)member));
        }
        if (member instanceof Constructor) {
            $Type[] types = $TypeUtils.getTypes(((Constructor)member).getParameterTypes());
            return new $Signature("<init>", $Type.getMethodDescriptor($Type.VOID_TYPE, types));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String desc) {
        return $ReflectUtils.findConstructor(desc, defaultLoader);
    }

    public static Constructor findConstructor(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            String className2 = desc.substring(0, lparen).trim();
            return $ReflectUtils.getClass(className2, loader).getConstructor($ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e) {
            throw new $CodeGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new $CodeGenerationException(e);
        }
    }

    public static Method findMethod(String desc) {
        return $ReflectUtils.findMethod(desc, defaultLoader);
    }

    public static Method findMethod(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            int dot = desc.lastIndexOf(46, lparen);
            String className2 = desc.substring(0, dot).trim();
            String methodName = desc.substring(dot + 1, lparen).trim();
            return $ReflectUtils.getClass(className2, loader).getDeclaredMethod(methodName, $ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e) {
            throw new $CodeGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new $CodeGenerationException(e);
        }
    }

    private static Class[] parseTypes(String desc, ClassLoader loader) throws ClassNotFoundException {
        int comma;
        int lparen = desc.indexOf(40);
        int rparen = desc.indexOf(41, lparen);
        ArrayList<String> params2 = new ArrayList<String>();
        int start = lparen + 1;
        while ((comma = desc.indexOf(44, start)) >= 0) {
            params2.add(desc.substring(start, comma).trim());
            start = comma + 1;
        }
        if (start < rparen) {
            params2.add(desc.substring(start, rparen).trim());
        }
        Class[] types = new Class[params2.size()];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = $ReflectUtils.getClass((String)params2.get(i2), loader);
        }
        return types;
    }

    private static Class getClass(String className2, ClassLoader loader) throws ClassNotFoundException {
        return $ReflectUtils.getClass(className2, loader, CGLIB_PACKAGES);
    }

    private static Class getClass(String className2, ClassLoader loader, String[] packages2) throws ClassNotFoundException {
        String save2 = className2;
        int dimensions = 0;
        int index2 = 0;
        while ((index2 = className2.indexOf("[]", index2) + 1) > 0) {
            ++dimensions;
        }
        StringBuffer brackets = new StringBuffer(className2.length() - dimensions);
        for (int i2 = 0; i2 < dimensions; ++i2) {
            brackets.append('[');
        }
        className2 = className2.substring(0, className2.length() - 2 * dimensions);
        String prefix = dimensions > 0 ? brackets + "L" : "";
        String suffix = dimensions > 0 ? ";" : "";
        try {
            return Class.forName(prefix + className2 + suffix, false, loader);
        }
        catch (ClassNotFoundException ignore) {
            for (int i3 = 0; i3 < packages2.length; ++i3) {
                try {
                    return Class.forName(prefix + packages2[i3] + '.' + className2 + suffix, false, loader);
                }
                catch (ClassNotFoundException ignore2) {
                    continue;
                }
            }
            if (dimensions == 0) {
                Class c = (Class)primitives.get(className2);
                if (c != null) {
                    return c;
                }
            } else {
                String transform2 = (String)transforms.get(className2);
                if (transform2 != null) {
                    try {
                        return Class.forName(brackets + transform2, false, loader);
                    }
                    catch (ClassNotFoundException ignore3) {
                        // empty catch block
                    }
                }
            }
            throw new ClassNotFoundException(save2);
        }
    }

    public static Object newInstance(Class type2) {
        return $ReflectUtils.newInstance(type2, $Constants.EMPTY_CLASS_ARRAY, null);
    }

    public static Object newInstance(Class type2, Class[] parameterTypes, Object[] args) {
        return $ReflectUtils.newInstance($ReflectUtils.getConstructor(type2, parameterTypes), args);
    }

    public static Object newInstance(Constructor cstruct, Object[] args) {
        boolean flag = cstruct.isAccessible();
        try {
            Object result2;
            cstruct.setAccessible(true);
            Object t = result2 = cstruct.newInstance(args);
            return t;
        }
        catch (InstantiationException e) {
            throw new $CodeGenerationException(e);
        }
        catch (IllegalAccessException e) {
            throw new $CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new $CodeGenerationException(e.getTargetException());
        }
        finally {
            cstruct.setAccessible(flag);
        }
    }

    public static Constructor getConstructor(Class type2, Class[] parameterTypes) {
        try {
            Constructor constructor = type2.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new $CodeGenerationException(e);
        }
    }

    public static String[] getNames(Class[] classes2) {
        if (classes2 == null) {
            return null;
        }
        String[] names2 = new String[classes2.length];
        for (int i2 = 0; i2 < names2.length; ++i2) {
            names2[i2] = classes2[i2].getName();
        }
        return names2;
    }

    public static Class[] getClasses(Object[] objects) {
        Class[] classes2 = new Class[objects.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            classes2[i2] = objects[i2].getClass();
        }
        return classes2;
    }

    public static Method findNewInstance(Class iface) {
        Method m = $ReflectUtils.findInterfaceMethod(iface);
        if (!m.getName().equals("newInstance")) {
            throw new IllegalArgumentException(iface + " missing newInstance method");
        }
        return m;
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] properties2, boolean read2, boolean write2) {
        HashSet<Method> methods2 = new HashSet<Method>();
        for (int i2 = 0; i2 < properties2.length; ++i2) {
            PropertyDescriptor pd = properties2[i2];
            if (read2) {
                methods2.add(pd.getReadMethod());
            }
            if (!write2) continue;
            methods2.add(pd.getWriteMethod());
        }
        methods2.remove(null);
        return methods2.toArray(new Method[methods2.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class type2) {
        return $ReflectUtils.getPropertiesHelper(type2, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class type2) {
        return $ReflectUtils.getPropertiesHelper(type2, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class type2) {
        return $ReflectUtils.getPropertiesHelper(type2, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class type2, boolean read2, boolean write2) {
        try {
            BeanInfo info = Introspector.getBeanInfo(type2, class$java$lang$Object == null ? (class$java$lang$Object = $ReflectUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] all2 = info.getPropertyDescriptors();
            if (read2 && write2) {
                return all2;
            }
            ArrayList<PropertyDescriptor> properties2 = new ArrayList<PropertyDescriptor>(all2.length);
            for (int i2 = 0; i2 < all2.length; ++i2) {
                PropertyDescriptor pd = all2[i2];
                if ((!read2 || pd.getReadMethod() == null) && (!write2 || pd.getWriteMethod() == null)) continue;
                properties2.add(pd);
            }
            return properties2.toArray(new PropertyDescriptor[properties2.size()]);
        }
        catch (IntrospectionException e) {
            throw new $CodeGenerationException(e);
        }
    }

    public static Method findDeclaredMethod(Class type2, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        for (Class cl = type2; cl != null; cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static List addAllMethods(Class type2, List list2) {
        list2.addAll(Arrays.asList(type2.getDeclaredMethods()));
        Class superclass = type2.getSuperclass();
        if (superclass != null) {
            $ReflectUtils.addAllMethods(superclass, list2);
        }
        Class<?>[] interfaces = type2.getInterfaces();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            $ReflectUtils.addAllMethods(interfaces[i2], list2);
        }
        return list2;
    }

    public static List addAllInterfaces(Class type2, List list2) {
        Class superclass = type2.getSuperclass();
        if (superclass != null) {
            list2.addAll(Arrays.asList(type2.getInterfaces()));
            $ReflectUtils.addAllInterfaces(superclass, list2);
        }
        return list2;
    }

    public static Method findInterfaceMethod(Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        Method[] methods2 = iface.getDeclaredMethods();
        if (methods2.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + iface);
        }
        return methods2[0];
    }

    public static Class defineClass(String className2, byte[] b2, ClassLoader loader) throws Exception {
        Object[] args = new Object[]{className2, b2, new Integer(0), new Integer(b2.length), PROTECTION_DOMAIN};
        Class c = (Class)DEFINE_CLASS.invoke((Object)loader, args);
        Class.forName(className2, true, loader);
        return c;
    }

    public static int findPackageProtected(Class[] classes2) {
        for (int i2 = 0; i2 < classes2.length; ++i2) {
            if (Modifier.isPublic(classes2[i2].getModifiers())) continue;
            return i2;
        }
        return 0;
    }

    public static $MethodInfo getMethodInfo(final Member member, final int modifiers2) {
        final $Signature sig = $ReflectUtils.getSignature(member);
        return new $MethodInfo(){
            private $ClassInfo ci;

            public $ClassInfo getClassInfo() {
                if (this.ci == null) {
                    this.ci = $ReflectUtils.getClassInfo(member.getDeclaringClass());
                }
                return this.ci;
            }

            public int getModifiers() {
                return modifiers2;
            }

            public $Signature getSignature() {
                return sig;
            }

            public $Type[] getExceptionTypes() {
                return $ReflectUtils.getExceptionTypes(member);
            }

            public $Attribute getAttribute() {
                return null;
            }
        };
    }

    public static $MethodInfo getMethodInfo(Member member) {
        return $ReflectUtils.getMethodInfo(member, member.getModifiers());
    }

    public static $ClassInfo getClassInfo(final Class clazz) {
        final $Type type2 = $Type.getType(clazz);
        final $Type sc = clazz.getSuperclass() == null ? null : $Type.getType(clazz.getSuperclass());
        return new $ClassInfo(){

            public $Type getType() {
                return type2;
            }

            public $Type getSuperType() {
                return sc;
            }

            public $Type[] getInterfaces() {
                return $TypeUtils.getTypes(clazz.getInterfaces());
            }

            public int getModifiers() {
                return clazz.getModifiers();
            }
        };
    }

    public static Method[] findMethods(String[] namesAndDescriptors, Method[] methods2) {
        HashMap<String, Method> map2 = new HashMap<String, Method>();
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            Method method = methods2[i2];
            map2.put(method.getName() + $Type.getMethodDescriptor(method), method);
        }
        Method[] result2 = new Method[namesAndDescriptors.length / 2];
        for (int i3 = 0; i3 < result2.length; ++i3) {
            result2[i3] = (Method)map2.get(namesAndDescriptors[i3 * 2] + namesAndDescriptors[i3 * 2 + 1]);
            if (result2[i3] != null) continue;
        }
        return result2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$net$sf$cglib$core$ReflectUtils == null ? (class$net$sf$cglib$core$ReflectUtils = $ReflectUtils.class$("com.google.inject.internal.cglib.core.$ReflectUtils")) : class$net$sf$cglib$core$ReflectUtils).getProtectionDomain();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> loader = Class.forName("java.lang.ClassLoader");
                    DEFINE_CLASS = loader.getDeclaredMethod("defineClass", class$java$lang$String == null ? (class$java$lang$String = $ReflectUtils.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = $ReflectUtils.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, class$java$security$ProtectionDomain == null ? (class$java$security$ProtectionDomain = $ReflectUtils.class$("java.security.ProtectionDomain")) : class$java$security$ProtectionDomain);
                    DEFINE_CLASS.setAccessible(true);
                }
                catch (ClassNotFoundException e) {
                    throw new $CodeGenerationException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new $CodeGenerationException(e);
                }
                return null;
            }
        });
        CGLIB_PACKAGES = new String[]{"java.lang"};
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

