/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBundle {
    private static final Logger LOG = Logger.getInstance("#com.intellij.AbstractBundle");
    private Reference<ResourceBundle> myBundle;
    @NonNls
    private final String myPathToBundle;
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = ConcurrentFactoryMap.createWeakMap(new Function<ClassLoader, Map<String, ResourceBundle>>(){

        @Override
        public Map<String, ResourceBundle> fun(ClassLoader k) {
            return ContainerUtil.createConcurrentSoftValueMap();
        }
    });

    protected AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(0);
        }
        this.myPathToBundle = pathToBundle;
    }

    public String getMessage(@NotNull String key, Object ... params2) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(1);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(2);
        }
        return CommonBundle.message(this.getBundle(), key, params2);
    }

    private ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(this.myBundle);
        if (bundle == null) {
            bundle = AbstractBundle.getResourceBundle(this.myPathToBundle, this.getClass().getClassLoader());
            this.myBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static ResourceBundle getResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        Map<String, ResourceBundle> map2;
        ResourceBundle result2;
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(3);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(4);
        }
        if ((result2 = (map2 = ourCache.get(loader)).get(pathToBundle)) == null) {
            try {
                ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
                result2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
                ResourceBundle.clearCache(loader);
                result2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            }
            map2.put(pathToBundle, result2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/AbstractBundle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceBundle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

