/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    @Nullable
    public static PsiMethod getAnyAbstractMethod(@NotNull PsiClass aClass2) {
        PsiMethod[] methods2;
        PsiMethod methodToImplement;
        if (aClass2 == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        if ((methodToImplement = ClassUtil.getAnyMethodToImplement(aClass2)) != null) {
            return methodToImplement;
        }
        for (PsiMethod method : methods2 = aClass2.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod getAnyMethodToImplement(@NotNull PsiClass aClass2) {
        PsiClass superClass;
        if (aClass2 == null) {
            ClassUtil.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = superClass = aClass2 instanceof PsiAnonymousClass ? PsiUtil.resolveClassInClassTypeOnly(((PsiAnonymousClass)aClass2).getBaseClassType()) : aClass2.getSuperClass();
        if (superClass != null && !superClass.hasModifierProperty("abstract") && !superClass.isEnum() && aClass2.getImplementsListTypes().length == 0) {
            return null;
        }
        THashSet<PsiMethod> alreadyImplemented = new THashSet<PsiMethod>();
        for (HierarchicalMethodSignature signatureHierarchical : aClass2.getVisibleSignatures()) {
            for (PsiMethod superS : signatureHierarchical.getMethod().findSuperMethods()) {
                ClassUtil.add(superS, alreadyImplemented);
            }
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass2.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature signatureHierarchical : aClass2.getVisibleSignatures()) {
            PsiMethod method = signatureHierarchical.getMethod();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) continue;
            if (!(aClass2.equals(containingClass) || !method.hasModifierProperty("abstract") || method.hasModifierProperty("static") || method.hasModifierProperty("private") || alreadyImplemented.contains(method))) {
                return method;
            }
            ArrayList<HierarchicalMethodSignature> superSignatures = new ArrayList<HierarchicalMethodSignature>(signatureHierarchical.getInaccessibleSuperSignatures());
            superSignatures.addAll(signatureHierarchical.getSuperSignatures());
            for (HierarchicalMethodSignature superSignatureHierarchical : superSignatures) {
                PsiMethod superMethod = superSignatureHierarchical.getMethod();
                if (!superMethod.hasModifierProperty("abstract") || resolveHelper.isAccessible(superMethod, method, null)) continue;
                return superMethod;
            }
        }
        return null;
    }

    private static boolean add(PsiMethod method, Set<PsiMethod> alreadyImplemented) {
        boolean already = alreadyImplemented.add(method);
        if (!already) {
            return already;
        }
        for (PsiMethod superSig : method.findSuperMethods()) {
            already &= ClassUtil.add(superSig, alreadyImplemented);
        }
        return already;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "aClass";
        objectArray2[1] = "com/intellij/codeInsight/ClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyAbstractMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyMethodToImplement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

