/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectHighlightsUtil {
    public static final ExtensionPointName<Condition<PsiElement>> EP_NAME = ExtensionPointName.create("com.intellij.elementsToHighlightFilter");
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil");
    private static final int STARTING_TREE_HEIGHT = 100;

    private CollectHighlightsUtil() {
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root2, int startOffset, int endOffset) {
        if (root2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(0);
        }
        List<PsiElement> list2 = CollectHighlightsUtil.getElementsInRange(root2, startOffset, endOffset, false);
        if (list2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root2, int startOffset, int endOffset, boolean includeAllParents) {
        PsiElement commonParent;
        if (root2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(2);
        }
        if ((commonParent = CollectHighlightsUtil.findCommonParent(root2, startOffset, endOffset)) == null) {
            ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
            if (arrayList == null) {
                CollectHighlightsUtil.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        List<PsiElement> list2 = CollectHighlightsUtil.getElementsToHighlight(commonParent, startOffset, endOffset);
        PsiElement parent2 = commonParent;
        while (parent2 != null && parent2 != root2) {
            list2.add(parent2);
            parent2 = includeAllParents ? parent2.getParent() : null;
        }
        list2.add(root2);
        List<PsiElement> list3 = list2;
        if (list3 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @NotNull
    private static List<PsiElement> getElementsToHighlight(@NotNull PsiElement parent2, int startOffset, int endOffset) {
        if (parent2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(5);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        int currentOffset = parent2.getTextRange().getStartOffset();
        Condition<PsiElement>[] filters = Extensions.getExtensions(EP_NAME);
        int offset2 = currentOffset;
        TIntStack starts = new TIntStack(100);
        Stack<PsiElement> elements = new Stack<PsiElement>(100);
        Stack<PsiElement> children2 = new Stack<PsiElement>(100);
        PsiElement element = parent2;
        PsiElement child = PsiUtilCore.NULL_PSI_ELEMENT;
        while (true) {
            boolean startChildrenVisiting;
            ProgressIndicatorProvider.checkCanceled();
            for (Condition<PsiElement> filter2 : filters) {
                if (filter2.value(element)) continue;
                assert (child == PsiUtilCore.NULL_PSI_ELEMENT);
                child = null;
                break;
            }
            if (child == PsiUtilCore.NULL_PSI_ELEMENT) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                if (startChildrenVisiting) {
                    offset2 += element.getTextLength();
                }
                if (elements.isEmpty()) break;
                int start = starts.pop();
                if (startOffset <= start && offset2 <= endOffset) {
                    assert (element != null);
                    assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
                    result2.add(element);
                }
                element = (PsiElement)elements.pop();
                child = (PsiElement)children2.pop();
                continue;
            }
            if (offset2 > endOffset) break;
            children2.push(child.getNextSibling());
            starts.push(offset2);
            assert (element != null);
            assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
            elements.push(element);
            element = child;
            child = PsiUtilCore.NULL_PSI_ELEMENT;
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement root2, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return null;
        }
        PsiElement left = CollectHighlightsUtil.findElementAtInRoot(root2, startOffset);
        PsiElement right = CollectHighlightsUtil.findElementAtInRoot(root2, endOffset - 1);
        if (left == null || right == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(left, right);
        if (commonParent == null) {
            LOG.error("No common parent for " + left + " and " + right + "; root: " + root2 + "; startOffset: " + startOffset + "; endOffset: " + endOffset);
        }
        LOG.assertTrue(commonParent.getTextRange() != null, commonParent);
        for (PsiElement parent2 = commonParent.getParent(); parent2 != null && commonParent.getTextRange().equals(parent2.getTextRange()); parent2 = parent2.getParent()) {
            commonParent = parent2;
        }
        return commonParent;
    }

    @Nullable
    private static PsiElement findElementAtInRoot(PsiElement root2, int offset2) {
        if (root2 instanceof PsiFile) {
            return ((PsiFile)root2).getViewProvider().findElementAt(offset2, root2.getLanguage());
        }
        return root2.findElementAt(offset2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsInRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInRange";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToHighlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

