/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Divider {
    private static final int STARTING_TREE_HEIGHT = 10;
    private static final Key<Reference<DividedElements>> DIVIDED_ELEMENTS_KEY = Key.create("DIVIDED_ELEMENTS");
    private static final PsiElement HAVE_TO_GET_CHILDREN = PsiUtilCore.NULL_PSI_ELEMENT;

    public static void divideInsideAndOutsideAllRoots(@NotNull PsiFile file2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull Condition<PsiFile> rootFilter, @NotNull Processor<DividedElements> processor) {
        if (file2 == null) {
            Divider.$$$reportNull$$$0(0);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(2);
        }
        if (rootFilter == null) {
            Divider.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(4);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root2 = viewProvider.getPsi(language);
            if (!rootFilter.value(root2)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root2, restrictRange, priorityRange, processor);
        }
    }

    static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull Processor<DividedElements> processor) {
        DividedElements elements;
        if (root2 == null) {
            Divider.$$$reportNull$$$0(5);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(6);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(8);
        }
        long modificationStamp = root2.getModificationStamp();
        DividedElements cached = SoftReference.dereference(root2.getUserData(DIVIDED_ELEMENTS_KEY));
        if (cached == null || cached.modificationStamp != modificationStamp || !cached.restrictRange.equals(restrictRange) || !cached.priorityRange.contains(priorityRange)) {
            elements = new DividedElements(modificationStamp, root2, restrictRange, priorityRange);
            Divider.divideInsideAndOutsideInOneRoot(root2, restrictRange, priorityRange, elements.inside, elements.insideRanges, elements.outside, elements.outsideRanges, elements.parents, elements.parentRanges, true);
            root2.putUserData(DIVIDED_ELEMENTS_KEY, new java.lang.ref.SoftReference<DividedElements>(elements));
        } else {
            elements = cached;
        }
        processor.process(elements);
    }

    private static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull List<PsiElement> inside, @NotNull List<ProperTextRange> insideRanges, @NotNull List<PsiElement> outside, @NotNull List<ProperTextRange> outsideRanges, @NotNull List<PsiElement> outParents, @NotNull List<ProperTextRange> outParentRanges, boolean includeParents) {
        if (root2 == null) {
            Divider.$$$reportNull$$$0(9);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(10);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(11);
        }
        if (inside == null) {
            Divider.$$$reportNull$$$0(12);
        }
        if (insideRanges == null) {
            Divider.$$$reportNull$$$0(13);
        }
        if (outside == null) {
            Divider.$$$reportNull$$$0(14);
        }
        if (outsideRanges == null) {
            Divider.$$$reportNull$$$0(15);
        }
        if (outParents == null) {
            Divider.$$$reportNull$$$0(16);
        }
        if (outParentRanges == null) {
            Divider.$$$reportNull$$$0(17);
        }
        int startOffset = restrictRange.getStartOffset();
        int endOffset = restrictRange.getEndOffset();
        Condition<PsiElement>[] filters = Extensions.getExtensions(CollectHighlightsUtil.EP_NAME);
        TIntStack starts = new TIntStack(10);
        starts.push(startOffset);
        Stack<PsiFile> elements = new Stack<PsiFile>(10);
        Stack<PsiElement> children2 = new Stack<PsiElement>(10);
        PsiElement element = root2;
        PsiElement child = HAVE_TO_GET_CHILDREN;
        int offset2 = 0;
        while (true) {
            boolean startChildrenVisiting;
            ProgressManager.checkCanceled();
            for (Condition<PsiElement> filter2 : filters) {
                if (filter2.value(element)) continue;
                assert (child == HAVE_TO_GET_CHILDREN);
                child = null;
                break;
            }
            if (child == HAVE_TO_GET_CHILDREN) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                int start;
                if (startChildrenVisiting) {
                    offset2 += element.getTextLength();
                }
                if (startOffset <= (start = starts.pop()) && offset2 <= endOffset) {
                    if (priorityRange.containsRange(start, offset2)) {
                        inside.add(element);
                        insideRanges.add(new ProperTextRange(start, offset2));
                    } else {
                        outside.add(element);
                        outsideRanges.add(new ProperTextRange(start, offset2));
                    }
                }
                if (elements.isEmpty()) break;
                element = (PsiElement)elements.pop();
                child = (PsiElement)children2.pop();
                continue;
            }
            if (offset2 > endOffset) break;
            children2.push(child.getNextSibling());
            starts.push(offset2);
            elements.push((PsiFile)element);
            element = child;
            child = HAVE_TO_GET_CHILDREN;
        }
        if (includeParents) {
            PsiElement parent2;
            PsiElement psiElement = !outside.isEmpty() ? outside.get(outside.size() - 1) : (parent2 = !inside.isEmpty() ? inside.get(inside.size() - 1) : CollectHighlightsUtil.findCommonParent(root2, startOffset, endOffset));
            while (parent2 != null && !(parent2 instanceof PsiFile)) {
                if ((parent2 = parent2.getParent()) == null) continue;
                outParents.add(parent2);
                TextRange textRange = parent2.getTextRange();
                assert (textRange != null) : "Text range for " + parent2 + " is null. " + parent2.getClass() + "; root: " + root2 + ": " + root2.getVirtualFile();
                outParentRanges.add(ProperTextRange.create(textRange));
            }
        }
        assert (inside.size() == insideRanges.size());
        assert (outside.size() == outsideRanges.size());
        assert (outParents.size() == outParentRanges.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFilter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insideRanges";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outsideRanges";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParents";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParentRanges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideAllRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideInOneRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DividedElements {
        private final long modificationStamp;
        @NotNull
        public final PsiFile root;
        @NotNull
        private final TextRange restrictRange;
        @NotNull
        private final TextRange priorityRange;
        public final List<PsiElement> inside;
        final List<ProperTextRange> insideRanges;
        public final List<PsiElement> outside;
        final List<ProperTextRange> outsideRanges;
        public final List<PsiElement> parents;
        final List<ProperTextRange> parentRanges;

        /*
         * WARNING - void declaration
         */
        private DividedElements(long modificationStamp, @NotNull PsiFile root2, @NotNull TextRange restrictRange, @NotNull TextRange textRange) {
            void priorityRange;
            if (root2 == null) {
                DividedElements.$$$reportNull$$$0(0);
            }
            if (restrictRange == null) {
                DividedElements.$$$reportNull$$$0(1);
            }
            if (textRange == null) {
                DividedElements.$$$reportNull$$$0(2);
            }
            this.inside = new ArrayList<PsiElement>();
            this.insideRanges = new ArrayList<ProperTextRange>();
            this.outside = new ArrayList<PsiElement>();
            this.outsideRanges = new ArrayList<ProperTextRange>();
            this.parents = new ArrayList<PsiElement>();
            this.parentRanges = new ArrayList<ProperTextRange>();
            this.modificationStamp = modificationStamp;
            this.root = root2;
            this.restrictRange = restrictRange;
            this.priorityRange = priorityRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "restrictRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "priorityRange";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/Divider$DividedElements";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

