/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingSessionImpl
implements HighlightingSession {
    @NotNull
    private final PsiFile myPsiFile;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    private final Map<TextRange, RangeMarker> myRanges2markersCache;
    private final TransferToEDTQueue<Runnable> myEDTQueue;
    private static final Key<ConcurrentMap<PsiFile, HighlightingSession>> HIGHLIGHTING_SESSION = Key.create("HIGHLIGHTING_SESSION");

    private HighlightingSessionImpl(@NotNull PsiFile psiFile, @NotNull DaemonProgressIndicator progressIndicator, EditorColorsScheme editorColorsScheme) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(1);
        }
        this.myRanges2markersCache = new THashMap<TextRange, RangeMarker>();
        this.myPsiFile = psiFile;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myProject = psiFile.getProject();
        this.myDocument = PsiDocumentManager.getInstance(this.myProject).getDocument(psiFile);
        this.myEDTQueue = new TransferToEDTQueue<Runnable>("Apply highlighting results", runnable -> {
            runnable.run();
            return true;
        }, o -> this.myProject.isDisposed() || this.getProgressIndicator().isCanceled()){

            @Override
            protected void schedule(@NotNull Runnable updateRunnable) {
                if (updateRunnable == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(updateRunnable, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateRunnable", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl$1", "schedule"));
            }
        };
    }

    void applyInEDT(@NotNull Runnable runnable) {
        if (runnable == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(2);
        }
        this.myEDTQueue.offer(runnable);
    }

    public static HighlightingSession getHighlightingSession(@NotNull PsiFile psiFile, @NotNull ProgressIndicator progressIndicator) {
        Map map2;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(3);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(4);
        }
        return (map2 = (Map)((DaemonProgressIndicator)progressIndicator).getUserData(HIGHLIGHTING_SESSION)) == null ? null : (HighlightingSession)map2.get(psiFile);
    }

    @NotNull
    static HighlightingSession getOrCreateHighlightingSession(@NotNull PsiFile psiFile, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme) {
        HighlightingSession session;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(5);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(6);
        }
        if ((session = HighlightingSessionImpl.getHighlightingSession(psiFile, progressIndicator)) == null) {
            ConcurrentMap<PsiFile, HighlightingSession> map2 = progressIndicator.getUserData(HIGHLIGHTING_SESSION);
            if (map2 == null) {
                map2 = progressIndicator.putUserDataIfAbsent(HIGHLIGHTING_SESSION, ContainerUtil.newConcurrentMap());
            }
            session = ConcurrencyUtil.cacheOrGet(map2, psiFile, new HighlightingSessionImpl(psiFile, progressIndicator, editorColorsScheme));
        }
        HighlightingSession highlightingSession = session;
        if (highlightingSession == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(7);
        }
        return highlightingSession;
    }

    static void waitForAllSessionsHighlightInfosApplied(@NotNull DaemonProgressIndicator progressIndicator) {
        ConcurrentMap<PsiFile, HighlightingSession> map2;
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(8);
        }
        if ((map2 = progressIndicator.getUserData(HIGHLIGHTING_SESSION)) != null) {
            for (HighlightingSession session : map2.values()) {
                ((HighlightingSessionImpl)session).waitForHighlightInfosApplied();
            }
        }
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(9);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(10);
        }
        return document;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(11);
        }
        return progressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(12);
        }
        return project;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    void queueHighlightInfo(@NotNull HighlightInfo info, @NotNull TextRange restrictedRange, int groupId) {
        if (info == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(13);
        }
        if (restrictedRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(14);
        }
        this.myEDTQueue.offer(() -> {
            if (restrictedRange == null) {
                HighlightingSessionImpl.$$$reportNull$$$0(17);
            }
            if (info == null) {
                HighlightingSessionImpl.$$$reportNull$$$0(18);
            }
            EditorColorsScheme colorsScheme = this.getColorsScheme();
            UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.myProject, this.getDocument(), this.getPsiFile(), restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), info, colorsScheme, groupId, this.myRanges2markersCache);
        });
    }

    void queueDisposeHighlighterFor(@NotNull HighlightInfo info) {
        RangeHighlighterEx highlighter;
        if (info == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(15);
        }
        if ((highlighter = info.getHighlighter()) == null) {
            return;
        }
        this.myEDTQueue.offer(() -> {
            Object actualInfo;
            if (info == null) {
                HighlightingSessionImpl.$$$reportNull$$$0(16);
            }
            if ((actualInfo = highlighter.getErrorStripeTooltip()) == info && info.getHighlighter() == highlighter) {
                highlighter.dispose();
            }
        });
    }

    void waitForHighlightInfosApplied() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEDTQueue.drain();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateHighlightingSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyInEDT";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingSession";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHighlightingSession";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllSessionsHighlightInfosApplied";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queueHighlightInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "queueDisposeHighlighterFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$queueDisposeHighlighterFor$3";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$queueHighlightInfo$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

