/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightNamesUtil {
    private static final Logger LOG = Logger.getInstance(HighlightNamesUtil.class);

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMethod method, @NotNull PsiElement elementToHighlight, boolean isDeclaration, @NotNull TextAttributesScheme colorsScheme) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(0);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(1);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(2);
        }
        return HighlightNamesUtil.highlightMethodName(method, elementToHighlight, elementToHighlight.getTextRange(), colorsScheme, isDeclaration);
    }

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMember methodOrClass, @NotNull PsiElement elementToHighlight, @NotNull TextRange range, @NotNull TextAttributesScheme colorsScheme, boolean isDeclaration) {
        HighlightInfoType type2;
        if (methodOrClass == null) {
            HighlightNamesUtil.$$$reportNull$$$0(3);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(4);
        }
        if (range == null) {
            HighlightNamesUtil.$$$reportNull$$$0(5);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(6);
        }
        boolean isInherited = false;
        if (!isDeclaration && HighlightNamesUtil.isCalledOnThis(elementToHighlight)) {
            PsiClass enclosingClass;
            PsiClass containingClass = methodOrClass instanceof PsiMethod ? methodOrClass.getContainingClass() : null;
            PsiClass psiClass = enclosingClass = containingClass == null ? null : PsiTreeUtil.getParentOfType(elementToHighlight, PsiClass.class);
            while (enclosingClass != null && !(isInherited = enclosingClass.isInheritor(containingClass, true))) {
                enclosingClass = PsiTreeUtil.getParentOfType((PsiElement)enclosingClass, PsiClass.class, true);
            }
        }
        LOG.assertTrue(methodOrClass instanceof PsiMethod || !isDeclaration);
        HighlightInfoType highlightInfoType = type2 = methodOrClass instanceof PsiMethod ? HighlightNamesUtil.getMethodNameHighlightType((PsiMethod)methodOrClass, isDeclaration, isInherited) : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        if (type2 != null) {
            TextAttributes attributes2 = HighlightNamesUtil.mergeWithScopeAttributes(methodOrClass, type2, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type2).range(range);
            if (attributes2 != null) {
                builder.textAttributes(attributes2);
            }
            return builder.createUnconditionally();
        }
        return null;
    }

    private static boolean isCalledOnThis(@NotNull PsiElement elementToHighlight) {
        PsiElement qualifier;
        PsiMethodCallExpression methodCallExpression;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(7);
        }
        return (methodCallExpression = PsiTreeUtil.getParentOfType(elementToHighlight, PsiMethodCallExpression.class)) != null && ((qualifier = methodCallExpression.getMethodExpression().getQualifier()) == null || qualifier instanceof PsiThisExpression);
    }

    private static TextAttributes mergeWithScopeAttributes(@Nullable PsiElement element, @NotNull HighlightInfoType type2, @NotNull TextAttributesScheme colorsScheme) {
        if (type2 == null) {
            HighlightNamesUtil.$$$reportNull$$$0(8);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(9);
        }
        TextAttributes regularAttributes = HighlightInfo.getAttributesByType(element, type2, colorsScheme);
        if (element == null) {
            return regularAttributes;
        }
        TextAttributes scopeAttributes = HighlightNamesUtil.getScopeAttributes(element, colorsScheme);
        return TextAttributes.merge(scopeAttributes, regularAttributes);
    }

    @NotNull
    static HighlightInfo highlightClassName(@Nullable PsiClass aClass2, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement parent2;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement identifier;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(10);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(11);
        }
        TextRange range = elementToHighlight.getTextRange();
        if (elementToHighlight instanceof PsiJavaCodeReferenceElement && (identifier = (referenceElement = (PsiJavaCodeReferenceElement)elementToHighlight).getReferenceNameElement()) != null) {
            range = identifier.getTextRange();
        }
        if ((parent2 = elementToHighlight.getParent()) instanceof PsiAnnotation) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)parent2;
            range = new TextRange(psiAnnotation.getTextRange().getStartOffset(), range.getEndOffset());
        }
        HighlightInfoType type2 = HighlightNamesUtil.getClassNameHighlightType(aClass2, elementToHighlight);
        TextAttributes attributes2 = HighlightNamesUtil.mergeWithScopeAttributes(aClass2, type2, colorsScheme);
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type2).range(range);
        if (attributes2 != null) {
            builder.textAttributes(attributes2);
        }
        HighlightInfo highlightInfo = builder.createUnconditionally();
        if (highlightInfo == null) {
            HighlightNamesUtil.$$$reportNull$$$0(12);
        }
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo highlightVariableName(@NotNull PsiVariable variable2, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        HighlightInfoType varType;
        if (variable2 == null) {
            HighlightNamesUtil.$$$reportNull$$$0(13);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(14);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(15);
        }
        if ((varType = HighlightNamesUtil.getVariableNameHighlightType(variable2)) == null) {
            return null;
        }
        if (variable2 instanceof PsiField) {
            TextAttributes attributes2 = HighlightNamesUtil.mergeWithScopeAttributes(variable2, varType, colorsScheme);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(varType).range(elementToHighlight.getTextRange());
            if (attributes2 != null) {
                builder.textAttributes(attributes2);
            }
            return builder.createUnconditionally();
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(varType).range(elementToHighlight);
        return RainbowHighlighter.isRainbowEnabledWithInheritance(colorsScheme, JavaLanguage.INSTANCE) ? builder.createUnconditionally() : builder.create();
    }

    @Nullable
    static HighlightInfo highlightClassNameInQualifier(@NotNull PsiJavaCodeReferenceElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement resolved;
        PsiElement qualifierExpression;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(16);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(17);
        }
        if ((qualifierExpression = element.getQualifier()) instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifierExpression).resolve()) instanceof PsiClass) {
            return HighlightNamesUtil.highlightClassName((PsiClass)resolved, qualifierExpression, colorsScheme);
        }
        return null;
    }

    private static HighlightInfoType getMethodNameHighlightType(@NotNull PsiMethod method, boolean isDeclaration, boolean isInheritedMethod) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(18);
        }
        if (method.isConstructor()) {
            return isDeclaration ? JavaHighlightInfoTypes.CONSTRUCTOR_DECLARATION : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        }
        if (isDeclaration) {
            return JavaHighlightInfoTypes.METHOD_DECLARATION;
        }
        if (method.hasModifierProperty("static")) {
            return JavaHighlightInfoTypes.STATIC_METHOD;
        }
        if (isInheritedMethod) {
            return JavaHighlightInfoTypes.INHERITED_METHOD;
        }
        if (method.hasModifierProperty("abstract")) {
            return JavaHighlightInfoTypes.ABSTRACT_METHOD;
        }
        return JavaHighlightInfoTypes.METHOD_CALL;
    }

    @Nullable
    private static HighlightInfoType getVariableNameHighlightType(@NotNull PsiVariable var) {
        if (var == null) {
            HighlightNamesUtil.$$$reportNull$$$0(19);
        }
        if (var instanceof PsiLocalVariable || var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement) {
            return JavaHighlightInfoTypes.LOCAL_VARIABLE;
        }
        if (var instanceof PsiField) {
            return var.hasModifierProperty("static") ? (var.hasModifierProperty("final") ? JavaHighlightInfoTypes.STATIC_FINAL_FIELD : JavaHighlightInfoTypes.STATIC_FIELD) : (var.hasModifierProperty("final") ? JavaHighlightInfoTypes.INSTANCE_FINAL_FIELD : JavaHighlightInfoTypes.INSTANCE_FIELD);
        }
        if (var instanceof PsiParameter) {
            return ((PsiParameter)var).getDeclarationScope() instanceof PsiLambdaExpression ? JavaHighlightInfoTypes.LAMBDA_PARAMETER : JavaHighlightInfoTypes.PARAMETER;
        }
        return null;
    }

    @NotNull
    private static HighlightInfoType getClassNameHighlightType(@Nullable PsiClass aClass2, @Nullable PsiElement element) {
        if (element instanceof PsiJavaCodeReferenceElement && element.getParent() instanceof PsiAnonymousClass) {
            HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANONYMOUS_CLASS_NAME;
            if (highlightInfoType == null) {
                HighlightNamesUtil.$$$reportNull$$$0(20);
            }
            return highlightInfoType;
        }
        if (aClass2 != null) {
            if (aClass2.isAnnotationType()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANNOTATION_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(21);
                }
                return highlightInfoType;
            }
            if (aClass2.isInterface()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.INTERFACE_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(22);
                }
                return highlightInfoType;
            }
            if (aClass2.isEnum()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ENUM_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(23);
                }
                return highlightInfoType;
            }
            if (aClass2 instanceof PsiTypeParameter) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.TYPE_PARAMETER_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(24);
                }
                return highlightInfoType;
            }
            PsiModifierList modList = aClass2.getModifierList();
            if (modList != null && modList.hasModifierProperty("abstract")) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ABSTRACT_CLASS_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(25);
                }
                return highlightInfoType;
            }
        }
        HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.CLASS_NAME;
        if (highlightInfoType == null) {
            HighlightNamesUtil.$$$reportNull$$$0(26);
        }
        return highlightInfoType;
    }

    @Nullable
    static HighlightInfo highlightReassignedVariable(@NotNull PsiVariable variable2, @NotNull PsiElement elementToHighlight) {
        if (variable2 == null) {
            HighlightNamesUtil.$$$reportNull$$$0(27);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(28);
        }
        if (variable2 instanceof PsiLocalVariable) {
            return HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.REASSIGNED_LOCAL_VARIABLE).range(elementToHighlight).create();
        }
        if (variable2 instanceof PsiParameter) {
            return HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.REASSIGNED_PARAMETER).range(elementToHighlight).create();
        }
        return null;
    }

    private static TextAttributes getScopeAttributes(@NotNull PsiElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiFile file2;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(29);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(30);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return null;
        }
        TextAttributes result2 = null;
        DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance(file2.getProject());
        List<Pair<NamedScope, NamedScopesHolder>> scopes = validationManager.getScopeBasedHighlightingCachedScopes();
        for (Pair<NamedScope, NamedScopesHolder> scope : scopes) {
            PackageSet packageSet;
            NamedScope namedScope = scope.getFirst();
            TextAttributesKey scopeKey = ScopeAttributesUtil.getScopeTextAttributeKey(namedScope.getName());
            TextAttributes attributes2 = colorsScheme.getAttributes(scopeKey);
            if (attributes2 == null || attributes2.isEmpty() || (packageSet = namedScope.getValue()) == null || !packageSet.contains(file2, scope.getSecond())) continue;
            result2 = TextAttributes.merge(attributes2, result2);
        }
        return result2;
    }

    @NotNull
    public static TextRange getMethodDeclarationTextRange(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(31);
        }
        if (method instanceof SyntheticElement) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(32);
            }
            return textRange;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList(method.getModifierList());
        TextRange throwsRange = method.getThrowsList().getTextRange();
        LOG.assertTrue(throwsRange != null, method);
        int end = throwsRange.getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            HighlightNamesUtil.$$$reportNull$$$0(33);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getFieldDeclarationTextRange(@NotNull PsiField field) {
        if (field == null) {
            HighlightNamesUtil.$$$reportNull$$$0(34);
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList(field.getModifierList());
        int end = field.getNameIdentifier().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            HighlightNamesUtil.$$$reportNull$$$0(35);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getClassDeclarationTextRange(@NotNull PsiClass aClass2) {
        PsiElement endElement;
        PsiJavaCodeReferenceElement psiElement;
        if (aClass2 == null) {
            HighlightNamesUtil.$$$reportNull$$$0(36);
        }
        if (aClass2 instanceof PsiEnumConstantInitializer) {
            TextRange textRange = ((PsiEnumConstantInitializer)aClass2).getEnumConstant().getNameIdentifier().getTextRange();
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(37);
            }
            return textRange;
        }
        PsiElement psiElement2 = aClass2 instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass2).getBaseClassReference() : (psiElement = aClass2.getModifierList() == null ? aClass2.getNameIdentifier() : aClass2.getModifierList());
        if (psiElement == null) {
            TextRange textRange = new TextRange(aClass2.getTextRange().getStartOffset(), aClass2.getTextRange().getStartOffset());
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(38);
            }
            return textRange;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList(psiElement);
        PsiElement psiElement3 = endElement = aClass2 instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass2).getBaseClassReference() : aClass2.getImplementsList();
        if (endElement == null) {
            endElement = aClass2.getNameIdentifier();
        }
        TextRange endTextRange = endElement == null ? null : endElement.getTextRange();
        int end = endTextRange == null ? start : endTextRange.getEndOffset();
        TextRange textRange = new TextRange(start, end);
        if (textRange == null) {
            HighlightNamesUtil.$$$reportNull$$$0(39);
        }
        return textRange;
    }

    private static int stripAnnotationsFromModifierList(@NotNull PsiElement element) {
        TextRange textRange;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(40);
        }
        if ((textRange = element.getTextRange()) == null) {
            return 0;
        }
        PsiElement lastAnnotation = null;
        for (PsiElement child : element.getChildren()) {
            if (!(child instanceof PsiAnnotation)) continue;
            lastAnnotation = (PsiAnnotation)child;
        }
        if (lastAnnotation == null) {
            return textRange.getStartOffset();
        }
        ASTNode node = lastAnnotation.getNode();
        if (node != null) {
            while ((node = TreeUtil.nextLeaf(node)) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(node.getElementType())) {
            }
        }
        if (node != null) {
            return node.getTextRange().getStartOffset();
        }
        return textRange.getStartOffset();
    }

    static HighlightInfo highlightPackage(@NotNull PsiElement resolved, @NotNull PsiJavaCodeReferenceElement elementToHighlight, @NotNull TextAttributesScheme scheme) {
        TextRange range;
        PsiElement referenceNameElement;
        if (resolved == null) {
            HighlightNamesUtil.$$$reportNull$$$0(41);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(42);
        }
        if (scheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(43);
        }
        if ((referenceNameElement = elementToHighlight.getReferenceNameElement()) == null) {
            range = elementToHighlight.getTextRange();
        } else {
            PsiElement nextSibling = PsiTreeUtil.nextLeaf(referenceNameElement);
            if (nextSibling != null && nextSibling.getTextRange().isEmpty()) {
                nextSibling = PsiTreeUtil.nextLeaf(nextSibling);
            }
            range = PsiUtil.isJavaToken(nextSibling, JavaTokenType.DOT) ? new TextRange(referenceNameElement.getTextRange().getStartOffset(), nextSibling.getTextRange().getEndOffset()) : referenceNameElement.getTextRange();
        }
        HighlightInfoType type2 = JavaHighlightInfoTypes.CLASS_NAME;
        TextAttributes attributes2 = HighlightNamesUtil.mergeWithScopeAttributes(resolved, type2, scheme);
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type2).range(range);
        if (attributes2 != null) {
            builder.textAttributes(attributes2);
        }
        return builder.createUnconditionally();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 28: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodOrClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil";
                break;
            }
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 16: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightClassName";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameHighlightType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDeclarationTextRange";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDeclarationTextRange";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclarationTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "highlightMethodName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCalledOnThis";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithScopeAttributes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "highlightClassName";
                break;
            }
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "highlightVariableName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightClassNameInQualifier";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameHighlightType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNameHighlightType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "highlightReassignedVariable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getScopeAttributes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclarationTextRange";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDeclarationTextRange";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclarationTextRange";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "stripAnnotationsFromModifierList";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "highlightPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

