/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaGenericsUtil {
    public static boolean isReifiableType(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return JavaGenericsUtil.isReifiableType(((PsiArrayType)type2).getComponentType());
        }
        if (type2 instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiUtil.resolveClassInType(type2) instanceof PsiTypeParameter) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)PsiUtil.convertAnonymousToBaseType(type2);
            if (classType.isRaw()) {
                return true;
            }
            PsiType[] parameters2 = classType.getParameters();
            if (parameters2.length > 0) {
                for (PsiType parameter : parameters2) {
                    if (parameter instanceof PsiWildcardType && ((PsiWildcardType)parameter).getBound() == null) continue;
                    return false;
                }
                return true;
            }
            assert (parameters2.length == 0);
            PsiClassType.ClassResolveResult resolved = classType.resolveGenerics();
            PsiClass aClass2 = resolved.getElement();
            if (aClass2 instanceof PsiTypeParameter) {
                return false;
            }
            if (aClass2 != null && !aClass2.hasModifierProperty("static")) {
                PsiClass stopClassLevel = PsiUtil.isLocalClass(aClass2) ? null : aClass2.getContainingClass();
                PsiModifierListOwner enclosingStaticElement = PsiUtil.getEnclosingStaticElement(aClass2, stopClassLevel);
                PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiClass.class, true);
                if (containingClass != null && (enclosingStaticElement == null || PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false))) {
                    while (containingClass instanceof PsiAnonymousClass) {
                        containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, true);
                    }
                    if (containingClass == null || enclosingStaticElement != null && !PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false)) {
                        return true;
                    }
                    return JavaGenericsUtil.isReifiableType(JavaPsiFacade.getElementFactory(aClass2.getProject()).createType(containingClass, resolved.getSubstitutor()));
                }
            }
            return true;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isReifiableType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return false;
    }

    public static boolean isUncheckedWarning(@NotNull PsiJavaCodeReferenceElement expression2, @NotNull JavaResolveResult resolveResult, @NotNull LanguageLevel languageLevel) {
        PsiExpressionList argumentList2;
        PsiElement resolve2;
        if (expression2 == null) {
            JavaGenericsUtil.$$$reportNull$$$0(0);
        }
        if (resolveResult == null) {
            JavaGenericsUtil.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            JavaGenericsUtil.$$$reportNull$$$0(2);
        }
        if (!((resolve2 = resolveResult.getElement()) instanceof PsiMethod)) {
            return false;
        }
        PsiMethod psiMethod = (PsiMethod)resolve2;
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        int parametersCount = parameters2.length;
        if (parametersCount == 0) {
            return false;
        }
        PsiParameter varargParameter = parameters2[parametersCount - 1];
        if (!varargParameter.isVarArgs()) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, "java.lang.SafeVarargs", false, false)) {
            return false;
        }
        PsiType componentType = ((PsiEllipsisType)varargParameter.getType()).getComponentType();
        if (JavaGenericsUtil.isReifiableType(resolveResult.getSubstitutor().substitute(componentType))) {
            return false;
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof PsiCall && (argumentList2 = ((PsiCall)parent2).getArgumentList()) != null) {
            PsiExpression lastArg;
            PsiExpression[] args = argumentList2.getExpressions();
            if (args.length == parametersCount && (lastArg = args[args.length - 1]).getType() instanceof PsiArrayType) {
                return false;
            }
            for (int i2 = parametersCount - 1; i2 < args.length; ++i2) {
                if (JavaGenericsUtil.isReifiableType(resolveResult.getSubstitutor().substitute(args[i2].getType()))) continue;
                return true;
            }
            return args.length < parametersCount;
        }
        return false;
    }

    public static boolean isUncheckedCast(PsiType castType, PsiType operandType) {
        if (TypeConversionUtil.isAssignable(castType, operandType, false)) {
            return false;
        }
        if ((castType = castType.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType castClassType = (PsiClassType)castType;
            if ((operandType = operandType.getDeepComponentType()) instanceof PsiCapturedWildcardType) {
                operandType = ((PsiCapturedWildcardType)operandType).getUpperBound();
            }
            if (!(operandType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType operandClassType = (PsiClassType)operandType;
            PsiClassType.ClassResolveResult castResult = castClassType.resolveGenerics();
            PsiClassType.ClassResolveResult operandResult = operandClassType.resolveGenerics();
            PsiClass operandClass = operandResult.getElement();
            PsiClass castClass = castResult.getElement();
            if (operandClass == null || castClass == null) {
                return false;
            }
            if (castClass instanceof PsiTypeParameter) {
                return true;
            }
            if (castClassType.hasNonTrivialParameters()) {
                if (operandClassType.isRaw()) {
                    return true;
                }
                if (castClass.isInheritor(operandClass, true)) {
                    PsiSubstitutor castSubstitutor = castResult.getSubstitutor();
                    PsiElementFactory factory2 = JavaPsiFacade.getInstance(castClass.getProject()).getElementFactory();
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(castClass)) {
                        PsiSubstitutor modifiedSubstitutor = castSubstitutor.put(typeParameter, null);
                        PsiClassType otherType = factory2.createType(castClass, modifiedSubstitutor);
                        if (!TypeConversionUtil.isAssignable(operandType, otherType, false)) continue;
                        return true;
                    }
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(operandClass)) {
                        PsiType operand = operandResult.getSubstitutor().substitute(typeParameter);
                        if (!(operand instanceof PsiCapturedWildcardType)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isRawToGeneric(PsiType lType, PsiType rType) {
        if (lType instanceof PsiPrimitiveType || rType instanceof PsiPrimitiveType) {
            return false;
        }
        if (lType.equals(rType)) {
            return false;
        }
        if (lType instanceof PsiArrayType && rType instanceof PsiArrayType) {
            return JavaGenericsUtil.isRawToGeneric(((PsiArrayType)lType).getComponentType(), ((PsiArrayType)rType).getComponentType());
        }
        if (lType instanceof PsiArrayType || rType instanceof PsiArrayType) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType type2 : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(lType, type2)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType type3 : ((PsiIntersectionType)lType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(type3, rType)) continue;
                return true;
            }
            return false;
        }
        if (rType instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiCapturedWildcardType)rType).getUpperBound());
        }
        if (!(lType instanceof PsiClassType) || !(rType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult lResolveResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
        PsiClass lClass = lResolveResult.getElement();
        PsiClass rClass = rResolveResult.getElement();
        if (rClass instanceof PsiAnonymousClass) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiAnonymousClass)rClass).getBaseClassType());
        }
        PsiSubstitutor lSubstitutor = lResolveResult.getSubstitutor();
        PsiSubstitutor rSubstitutor = rResolveResult.getSubstitutor();
        if (lClass == null || rClass == null) {
            return false;
        }
        if (lClass instanceof PsiTypeParameter && !InheritanceUtil.isInheritorOrSelf(rClass, lClass, true)) {
            return true;
        }
        if (!lClass.getManager().areElementsEquivalent(lClass, rClass)) {
            if (lClass.isInheritor(rClass, true)) {
                lSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(rClass, lClass, lSubstitutor);
                lClass = rClass;
            } else if (rClass.isInheritor(lClass, true)) {
                rSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(lClass, rClass, rSubstitutor);
                rClass = lClass;
            } else {
                return false;
            }
        }
        Iterator<PsiTypeParameter> lIterator = PsiUtil.typeParametersIterator(lClass);
        Iterator<PsiTypeParameter> rIterator = PsiUtil.typeParametersIterator(rClass);
        while (lIterator.hasNext()) {
            if (!rIterator.hasNext()) {
                return false;
            }
            PsiTypeParameter lParameter = lIterator.next();
            PsiTypeParameter rParameter = rIterator.next();
            PsiType lTypeArg = lSubstitutor.substitute(lParameter);
            PsiType rTypeArg = rSubstitutor.substituteWithBoundsPromotion(rParameter);
            if (lTypeArg == null) continue;
            if (rTypeArg == null) {
                if (lTypeArg instanceof PsiWildcardType && ((PsiWildcardType)lTypeArg).getBound() == null) continue;
                return true;
            }
            if (TypeConversionUtil.typesAgree(lTypeArg, rTypeArg, true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType getCollectionItemType(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaGenericsUtil.$$$reportNull$$$0(3);
        }
        return JavaGenericsUtil.getCollectionItemType(expression2.getType(), expression2.getResolveScope());
    }

    @Nullable
    public static PsiType getCollectionItemType(@Nullable PsiType type2, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JavaGenericsUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof PsiArrayType) {
            return ((PsiArrayType)type2).getComponentType();
        }
        if (type2 instanceof PsiClassType) {
            PsiTypeParameter typeParameter;
            PsiClass myClass;
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass2 = resolveResult.getElement();
            if (aClass2 == null) {
                return null;
            }
            PsiManager manager = aClass2.getManager();
            String qName = aClass2.getQualifiedName();
            PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
            JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
            if (qName != null && (myClass = facade.findClass(qName, scope)) != null && myClass != aClass2) {
                PsiTypeParameter thisTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, myClass);
                if (thisTypeParameter == null) {
                    return null;
                }
                PsiTypeParameter thatTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, aClass2);
                if (thatTypeParameter != null) {
                    substitutor2 = substitutor2.put(thisTypeParameter, substitutor2.substitute(thatTypeParameter));
                }
                aClass2 = myClass;
            }
            if ((typeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, aClass2)) == null) {
                return null;
            }
            PsiClass owner = (PsiClass)typeParameter.getOwner();
            if (owner == null) {
                return null;
            }
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor(owner, aClass2, substitutor2);
            if (superClassSubstitutor == null) {
                return null;
            }
            PsiType itemType = superClassSubstitutor.substitute(typeParameter);
            return itemType == null ? PsiType.getJavaLangObject(manager, aClass2.getResolveScope()) : itemType;
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                PsiType itemType = JavaGenericsUtil.getCollectionItemType(conjunct, scope);
                if (itemType == null) continue;
                return itemType;
            }
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.getCollectionItemType(((PsiCapturedWildcardType)type2).getUpperBound(), scope);
        }
        return null;
    }

    @Nullable
    private static PsiTypeParameter getIterableTypeParameter(JavaPsiFacade facade, PsiClass context) {
        PsiClass iterable = facade.findClass("java.lang.Iterable", context.getResolveScope());
        if (iterable == null) {
            return null;
        }
        PsiTypeParameter[] typeParameters2 = iterable.getTypeParameters();
        if (typeParameters2.length != 1) {
            return null;
        }
        return typeParameters2[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaGenericsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncheckedWarning";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCollectionItemType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

