/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleGraphUtil {
    private JavaModuleGraphUtil() {
    }

    @Nullable
    public static PsiJavaModule findDescriptorByElement(@Nullable PsiElement element) {
        if (element != null) {
            PsiFileSystemItem fsItem;
            PsiFileSystemItem psiFileSystemItem = fsItem = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
            if (fsItem != null) {
                return JavaModuleGraphUtil.findDescriptorByFile(fsItem.getVirtualFile(), fsItem.getProject());
            }
        }
        return null;
    }

    @Nullable
    public static PsiJavaModule findDescriptorByFile(@Nullable VirtualFile file2, @NotNull Project project) {
        if (project == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(0);
        }
        return ModuleHighlightUtil.getModuleDescriptor(file2, project);
    }

    @Nullable
    public static Collection<PsiJavaModule> findCycle(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(1);
        }
        Project project = module2.getProject();
        List cycles = (List)CachedValuesManager.getManager(project).getCachedValue(project, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.findCycles(project), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        return (Collection)((Object)ContainerUtil.find(cycles, set -> {
            if (module2 == null) {
                JavaModuleGraphUtil.$$$reportNull$$$0(11);
            }
            return set.contains(module2);
        }));
    }

    public static boolean exports(@NotNull PsiJavaModule source2, @NotNull String packageName, @Nullable PsiJavaModule target) {
        Map exports;
        Set targets;
        if (source2 == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(2);
        }
        if (packageName == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(3);
        }
        return (targets = (Set)(exports = (Map)CachedValuesManager.getCachedValue(source2, () -> {
            if (source2 == null) {
                JavaModuleGraphUtil.$$$reportNull$$$0(10);
            }
            return CachedValueProvider.Result.create(JavaModuleGraphUtil.exportsMap(source2), source2.getContainingFile());
        })).get(packageName)) != null && (targets.isEmpty() || target != null && targets.contains(target.getName()));
    }

    public static boolean reads(@NotNull PsiJavaModule source2, @NotNull PsiJavaModule destination) {
        if (source2 == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(4);
        }
        if (destination == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(5);
        }
        return JavaModuleGraphUtil.getRequiresGraph(source2).reads(source2, destination);
    }

    @Nullable
    public static Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(6);
        }
        return JavaModuleGraphUtil.getRequiresGraph(module2).findConflict(module2);
    }

    @Nullable
    public static PsiJavaModule findOrigin(@NotNull PsiJavaModule module2, @NotNull String packageName) {
        if (module2 == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(7);
        }
        if (packageName == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(8);
        }
        return JavaModuleGraphUtil.getRequiresGraph(module2).findOrigin(module2, packageName);
    }

    private static List<Set<PsiJavaModule>> findCycles(Project project) {
        HashSet<PsiJavaModule> projectModules = ContainerUtil.newHashSet();
        for (Module module2 : ModuleManager.getInstance(project).getModules()) {
            List descriptors = Stream.of(ModuleRootManager.getInstance(module2).getSourceRoots(true)).map(root2 -> JavaModuleGraphUtil.findDescriptorByFile(root2, project)).filter(Objects::nonNull).collect(Collectors.toList());
            if (descriptors.size() > 1) {
                return Collections.emptyList();
            }
            if (descriptors.size() != 1) continue;
            projectModules.add((PsiJavaModule)descriptors.get(0));
        }
        if (!projectModules.isEmpty()) {
            ChameleonGraph graph2;
            DFSTBuilder builder;
            Collection components;
            MultiMap<PsiJavaModule, PsiJavaModule> relations = MultiMap.create();
            for (PsiJavaModule module3 : projectModules) {
                for (PsiRequiresStatement statement2 : module3.getRequires()) {
                    PsiJavaModule dependency = PsiJavaModuleReference.resolve(statement2, statement2.getModuleName(), true);
                    if (dependency == null || !projectModules.contains(dependency)) continue;
                    relations.putValue(module3, dependency);
                }
            }
            if (!relations.isEmpty() && !(components = (builder = new DFSTBuilder(graph2 = new ChameleonGraph(relations, false))).getComponents()).isEmpty()) {
                return components.stream().map(ContainerUtil::newLinkedHashSet).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, Set<String>> exportsMap(@NotNull PsiJavaModule source2) {
        if (source2 == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(9);
        }
        HashMap<String, Set<String>> map2 = ContainerUtil.newHashMap();
        for (PsiPackageAccessibilityStatement statement2 : source2.getExports()) {
            String pkg = statement2.getPackageName();
            List<String> targets = statement2.getModuleNames();
            map2.put(pkg, targets.isEmpty() ? Collections.emptySet() : ContainerUtil.newTroveSet(targets));
        }
        return map2;
    }

    private static RequiresGraph getRequiresGraph(PsiJavaModule module2) {
        Project project = module2.getProject();
        return (RequiresGraph)CachedValuesManager.getManager(project).getCachedValue(project, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.buildRequiresGraph(project), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
    }

    private static RequiresGraph buildRequiresGraph(Project project) {
        MultiMap<PsiJavaModule, PsiJavaModule> relations = MultiMap.create();
        THashSet<String> transitiveEdges = ContainerUtil.newTroveSet();
        JavaModuleNameIndex index2 = JavaModuleNameIndex.getInstance();
        GlobalSearchScope scope = ProjectScope.getAllScope(project);
        for (String key : index2.getAllKeys(project)) {
            for (PsiJavaModule module2 : index2.get(key, project, scope)) {
                JavaModuleGraphUtil.visit(module2, relations, transitiveEdges);
            }
        }
        Graph<PsiJavaModule> graph2 = GraphGenerator.generate(new ChameleonGraph(relations, true));
        return new RequiresGraph(graph2, transitiveEdges);
    }

    private static void visit(PsiJavaModule module2, MultiMap<PsiJavaModule, PsiJavaModule> relations, Set<String> transitiveEdges) {
        if (!relations.containsKey(module2)) {
            PsiJavaModule javaBase;
            relations.putValues(module2, Collections.emptyList());
            boolean explicitJavaBase = false;
            for (PsiRequiresStatement statement2 : module2.getRequires()) {
                String moduleName = statement2.getModuleName();
                if ("java.base".equals(moduleName)) {
                    explicitJavaBase = true;
                }
                for (PsiJavaModule dependency : PsiJavaModuleReference.multiResolve(statement2, moduleName, false)) {
                    relations.putValue(module2, dependency);
                    if (statement2.hasModifierProperty("transitive")) {
                        transitiveEdges.add(RequiresGraph.key(dependency, module2));
                    }
                    JavaModuleGraphUtil.visit(dependency, relations, transitiveEdges);
                }
            }
            if (!explicitJavaBase && !(module2 instanceof LightJavaModule) && (javaBase = PsiJavaModuleReference.resolve(module2, "java.base", false)) != null) {
                relations.putValue(module2, javaBase);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findDescriptorByFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findCycle";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "exports";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reads";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflict";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrigin";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "exportsMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$exports$2";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findCycle$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChameleonGraph<N>
    implements Graph<N> {
        private final Set<N> myNodes = new THashSet<N>();
        private final MultiMap<N, N> myEdges;
        private final boolean myInbound;

        public ChameleonGraph(MultiMap<N, N> edges, boolean inbound) {
            edges.entrySet().forEach(e -> {
                this.myNodes.add(e.getKey());
                this.myNodes.addAll((Collection)e.getValue());
            });
            this.myEdges = edges;
            this.myInbound = inbound;
        }

        @Override
        public Collection<N> getNodes() {
            return this.myNodes;
        }

        @Override
        public Iterator<N> getIn(N n) {
            return this.myInbound ? this.myEdges.get(n).iterator() : Collections.emptyIterator();
        }

        @Override
        public Iterator<N> getOut(N n) {
            return this.myInbound ? Collections.emptyIterator() : this.myEdges.get(n).iterator();
        }
    }

    private static class RequiresGraph {
        private final Graph<PsiJavaModule> myGraph;
        private final Set<String> myTransitiveEdges;

        public RequiresGraph(Graph<PsiJavaModule> graph2, Set<String> transitiveEdges) {
            this.myGraph = graph2;
            this.myTransitiveEdges = transitiveEdges;
        }

        public boolean reads(PsiJavaModule source2, PsiJavaModule destination) {
            Collection<PsiJavaModule> nodes = this.myGraph.getNodes();
            if (nodes.contains(destination) && nodes.contains(source2)) {
                Iterator<PsiJavaModule> directReaders = this.myGraph.getOut(destination);
                while (directReaders.hasNext()) {
                    PsiJavaModule next = directReaders.next();
                    if (!source2.equals(next) && (!this.myTransitiveEdges.contains(RequiresGraph.key(destination, next)) || !this.reads(source2, next))) continue;
                    return true;
                }
            }
            return false;
        }

        public Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(PsiJavaModule source2) {
            HashMap exports = ContainerUtil.newHashMap();
            return this.processExports(source2, (pkg, m) -> {
                PsiJavaModule existing = exports.put(pkg, m);
                return existing != null ? new Trinity<String, PsiJavaModule, PsiJavaModule>((String)pkg, existing, (PsiJavaModule)m) : null;
            });
        }

        public PsiJavaModule findOrigin(PsiJavaModule module2, String packageName) {
            return this.processExports(module2, (pkg, m) -> packageName.equals(pkg) ? m : null);
        }

        private <T> T processExports(PsiJavaModule start, BiFunction<String, PsiJavaModule, T> processor) {
            return this.myGraph.getNodes().contains(start) ? (T)this.processExports(start.getName(), start, 0, ContainerUtil.newHashSet(), processor) : null;
        }

        private <T> T processExports(String name, PsiJavaModule module2, int layer, Set<PsiJavaModule> visited2, BiFunction<String, PsiJavaModule, T> processor) {
            if (visited2.add(module2)) {
                if (layer == 1) {
                    for (PsiPackageAccessibilityStatement statement2 : module2.getExports()) {
                        T result2;
                        List<String> exportTargets = statement2.getModuleNames();
                        if (!exportTargets.isEmpty() && !exportTargets.contains(name) || (result2 = processor.apply(statement2.getPackageName(), module2)) == null) continue;
                        return result2;
                    }
                }
                if (layer < 2) {
                    Iterator<PsiJavaModule> iterator2 = this.myGraph.getIn(module2);
                    while (iterator2.hasNext()) {
                        T result3;
                        PsiJavaModule dependency = iterator2.next();
                        if (layer != 0 && !this.myTransitiveEdges.contains(RequiresGraph.key(dependency, module2)) || (result3 = this.processExports(name, dependency, 1, visited2, processor)) == null) continue;
                        return result3;
                    }
                }
            }
            return null;
        }

        public static String key(PsiJavaModule module2, PsiJavaModule exporter) {
            return module2.getName() + '/' + exporter.getName();
        }
    }
}

