/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.UnusedImportProvider;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.PomNamedTarget;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

class PostHighlightingVisitor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.PostHighlightingPass");
    private final RefCountHolder myRefCountHolder;
    @NotNull
    private final Project myProject;
    private final PsiFile myFile;
    @NotNull
    private final Document myDocument;
    private boolean myHasRedundantImports;
    private int myCurrentEntryIndex;
    private boolean myHasMissortedImports;
    private final UnusedSymbolLocalInspectionBase myUnusedSymbolInspection;
    private final HighlightDisplayKey myDeadCodeKey;
    private final HighlightInfoType myDeadCodeInfoType;
    private final UnusedDeclarationInspectionBase myDeadCodeInspection;
    private final Map<PsiMethod, Boolean> isOverriddenOrOverrides;

    private void optimizeImportsOnTheFlyLater(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(0);
        }
        if ((this.myHasRedundantImports || this.myHasMissortedImports) && !progress2.isCanceled()) {
            Disposable invokeFixLater = () -> TransactionGuard.getInstance().submitTransactionLater(this.myProject, () -> {
                if (!this.myFile.isValid() || !this.myFile.isWritable()) {
                    return;
                }
                IntentionAction optimizeImportsFix = QuickFixFactory.getInstance().createOptimizeImportsFix(true);
                if (optimizeImportsFix.isAvailable(this.myProject, null, this.myFile)) {
                    optimizeImportsFix.invoke(this.myProject, null, this.myFile);
                }
            });
            try {
                Disposer.register((DaemonProgressIndicator)progress2, invokeFixLater);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (progress2.isCanceled()) {
                Disposer.dispose(invokeFixLater);
                Disposer.dispose((DaemonProgressIndicator)progress2);
                progress2.checkCanceled();
            }
        }
    }

    PostHighlightingVisitor(@NotNull PsiFile file2, @NotNull Document document, @NotNull RefCountHolder refCountHolder) throws ProcessCanceledException {
        if (file2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(1);
        }
        if (document == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(2);
        }
        if (refCountHolder == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(3);
        }
        this.isOverriddenOrOverrides = ConcurrentFactoryMap.createMap(method -> {
            boolean overrides = SuperMethodsSearch.search(method, null, true, false).findFirst() != null;
            return overrides || OverridingMethodsSearch.search(method).findFirst() != null;
        });
        this.myProject = file2.getProject();
        this.myFile = file2;
        this.myDocument = document;
        this.myCurrentEntryIndex = -1;
        this.myRefCountHolder = refCountHolder;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        this.myDeadCodeKey = HighlightDisplayKey.find("unused");
        this.myDeadCodeInspection = (UnusedDeclarationInspectionBase)profile2.getUnwrappedTool("unused", (PsiElement)this.myFile);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || this.myDeadCodeInspection != null);
        this.myUnusedSymbolInspection = this.myDeadCodeInspection != null ? this.myDeadCodeInspection.getSharedLocalInspectionTool() : null;
        this.myDeadCodeInfoType = this.myDeadCodeKey == null ? HighlightInfoType.UNUSED_SYMBOL : new HighlightInfoType.HighlightInfoTypeImpl(profile2.getErrorLevel(this.myDeadCodeKey, this.myFile).getSeverity(), HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
    }

    void collectHighlights(@NotNull HighlightInfoHolder result2, @NotNull ProgressIndicator progress2) {
        PsiImportList importList;
        HighlightDisplayKey unusedImportKey;
        if (result2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(4);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(5);
        }
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        boolean unusedSymbolEnabled = profile2.isToolEnabled(this.myDeadCodeKey, this.myFile);
        GlobalUsageHelper globalUsageHelper = this.myRefCountHolder.getGlobalUsageHelper(this.myFile, this.myDeadCodeInspection, unusedSymbolEnabled);
        boolean errorFound = false;
        if (unusedSymbolEnabled) {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            Set<Language> relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                ProgressManager.checkCanceled();
                PsiFile psiRoot = viewProvider.getPsi(language);
                if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect(psiRoot)) continue;
                List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange(psiRoot, 0, this.myFile.getTextLength());
                for (PsiElement element : elements) {
                    PsiIdentifier identifier;
                    HighlightInfo info;
                    ProgressManager.checkCanceled();
                    if (!(element instanceof PsiIdentifier) || (info = this.processIdentifier(identifier = (PsiIdentifier)element, progress2, globalUsageHelper)) == null) continue;
                    errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                    result2.add(info);
                }
            }
        }
        if (this.isUnusedImportEnabled(unusedImportKey = HighlightDisplayKey.find("UNUSED_IMPORT")) && (importList = ((PsiJavaFile)this.myFile).getImportList()) != null) {
            PsiImportStatementBase[] imports;
            for (PsiImportStatementBase statement2 : imports = importList.getAllImportStatements()) {
                ProgressManager.checkCanceled();
                HighlightInfo info = this.processImport(statement2, unusedImportKey);
                if (info == null) continue;
                errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                result2.add(info);
            }
        }
        if (errorFound) {
            fileStatusMap.setErrorFoundFlag(this.myProject, this.myDocument, true);
        }
        this.optimizeImportsOnTheFlyLater(progress2);
    }

    private boolean isUnusedImportEnabled(HighlightDisplayKey unusedImportKey) {
        ImplicitUsageProvider[] implicitUsageProviders;
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        if (profile2.isToolEnabled(unusedImportKey, this.myFile) && this.myFile instanceof PsiJavaFile && HighlightingLevelManager.getInstance(this.myProject).shouldInspect(this.myFile)) {
            return true;
        }
        for (ImplicitUsageProvider provider : implicitUsageProviders = Extensions.getExtensions(ImplicitUsageProvider.EP_NAME)) {
            if (!(provider instanceof UnusedImportProvider) || !((UnusedImportProvider)((Object)provider)).isUnusedImportEnabled(this.myFile)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private HighlightInfo processIdentifier(@NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress2, @NotNull GlobalUsageHelper helper) {
        PsiElement declarationScope;
        PsiElement parent2;
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(6);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(7);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(8);
        }
        if (!((parent2 = identifier.getParent()) instanceof PsiVariable) && !(parent2 instanceof PsiMember)) {
            return null;
        }
        if (SuppressionUtil.inspectionResultSuppressed((PsiElement)identifier, this.myUnusedSymbolInspection)) {
            return null;
        }
        if (parent2 instanceof PsiLocalVariable && this.myUnusedSymbolInspection.LOCAL_VARIABLE) {
            return this.processLocalVariable((PsiLocalVariable)parent2, identifier, progress2);
        }
        if (parent2 instanceof PsiField && PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent2, this.myUnusedSymbolInspection.getFieldVisibility())) {
            return this.processField(this.myProject, (PsiField)parent2, identifier, progress2, helper);
        }
        if (parent2 instanceof PsiParameter && ((declarationScope = ((PsiParameter)parent2).getDeclarationScope()) instanceof PsiMethod ? PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)declarationScope, this.myUnusedSymbolInspection.getParameterVisibility()) : this.myUnusedSymbolInspection.LOCAL_VARIABLE)) {
            if (SuppressionUtil.isSuppressed(identifier, "UnusedParameters")) {
                return null;
            }
            return this.processParameter(this.myProject, (PsiParameter)parent2, identifier, progress2);
        }
        if (parent2 instanceof PsiMethod) {
            if (this.myUnusedSymbolInspection.isIgnoreAccessors() && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)parent2)) {
                return null;
            }
            if (PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent2, this.myUnusedSymbolInspection.getMethodVisibility())) {
                return this.processMethod(this.myProject, (PsiMethod)parent2, identifier, progress2, helper);
            }
        }
        if (parent2 instanceof PsiClass) {
            String acceptedVisibility;
            String string = acceptedVisibility = ((PsiClass)parent2).getContainingClass() == null ? this.myUnusedSymbolInspection.getClassVisibility() : this.myUnusedSymbolInspection.getInnerClassVisibility();
            if (PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent2, acceptedVisibility)) {
                return this.processClass(this.myProject, (PsiClass)parent2, identifier, progress2, helper);
            }
        }
        return null;
    }

    private static boolean compareVisibilities(PsiModifierListOwner listOwner, String visibility) {
        if (visibility != null) {
            while (listOwner != null) {
                if (VisibilityUtil.compare(VisibilityUtil.getVisibilityModifier(listOwner.getModifierList()), visibility) >= 0) {
                    return true;
                }
                listOwner = PsiTreeUtil.getParentOfType((PsiElement)listOwner, PsiModifierListOwner.class, true);
            }
        }
        return false;
    }

    @Nullable
    private HighlightInfo processLocalVariable(@NotNull PsiLocalVariable variable2, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress2) {
        if (variable2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(9);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(10);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(11);
        }
        if (variable2 instanceof PsiResourceVariable && PsiUtil.isIgnoredName(variable2.getName())) {
            return null;
        }
        if (UnusedSymbolUtil.isImplicitUsage(this.myProject, variable2, progress2)) {
            return null;
        }
        if (!this.myRefCountHolder.isReferenced(variable2)) {
            String message = JavaErrorMessages.message("local.variable.is.never.used", identifier.getText());
            HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
            IntentionAction fix = variable2 instanceof PsiResourceVariable ? QuickFixFactory.getInstance().createRenameToIgnoredFix(variable2) : QuickFixFactory.getInstance().createRemoveUnusedVariableFix(variable2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix, this.myDeadCodeKey);
            return highlightInfo;
        }
        boolean referenced = this.myRefCountHolder.isReferencedForRead(variable2);
        if (!referenced && !UnusedSymbolUtil.isImplicitRead(this.myProject, variable2, progress2)) {
            String message = JavaErrorMessages.message("local.variable.is.not.used.for.reading", identifier.getText());
            HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRemoveUnusedVariableFix(variable2), this.myDeadCodeKey);
            return highlightInfo;
        }
        if (!(variable2.hasInitializer() || (referenced = this.myRefCountHolder.isReferencedForWrite(variable2)) || UnusedSymbolUtil.isImplicitWrite(this.myProject, variable2, progress2))) {
            String message = JavaErrorMessages.message("local.variable.is.not.assigned", identifier.getText());
            HighlightInfo unusedSymbolInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
            QuickFixAction.registerQuickFixAction(unusedSymbolInfo, new EmptyIntentionAction(UnusedSymbolLocalInspectionBase.DISPLAY_NAME), this.myDeadCodeKey);
            return unusedSymbolInfo;
        }
        return null;
    }

    @Nullable
    private HighlightInfo processField(@NotNull Project project, @NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress2, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(12);
        }
        if (field == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(13);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(14);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(15);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(16);
        }
        if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
            return null;
        }
        if (field.hasModifierProperty("private")) {
            QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
            if (!this.myRefCountHolder.isReferenced(field) && !UnusedSymbolUtil.isImplicitUsage(this.myProject, field, progress2)) {
                String message = JavaErrorMessages.message("private.field.is.not.used", identifier.getText());
                HighlightInfo highlightInfo = this.suggestionsToMakeFieldUsed(field, identifier, message);
                if (!field.hasInitializer() && !field.hasModifierProperty("final")) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange(field), quickFixFactory.createCreateConstructorParameterFromFieldFix(field));
                }
                return highlightInfo;
            }
            boolean readReferenced = this.myRefCountHolder.isReferencedForRead(field);
            if (!readReferenced && !UnusedSymbolUtil.isImplicitRead(project, field, progress2)) {
                String message = JavaErrorMessages.message("private.field.is.not.used.for.reading", identifier.getText());
                return this.suggestionsToMakeFieldUsed(field, identifier, message);
            }
            if (field.hasInitializer()) {
                return null;
            }
            boolean writeReferenced = this.myRefCountHolder.isReferencedForWrite(field);
            if (!writeReferenced && !UnusedSymbolUtil.isImplicitWrite(project, field, progress2)) {
                String message = JavaErrorMessages.message("private.field.is.not.assigned", identifier.getText());
                HighlightInfo info = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
                QuickFixAction.registerQuickFixAction(info, quickFixFactory.createCreateGetterOrSetterFix(false, true, field), this.myDeadCodeKey);
                if (!field.hasModifierProperty("final")) {
                    QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange(field), quickFixFactory.createCreateConstructorParameterFromFieldFix(field));
                }
                SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes(field, annoName -> {
                    if (project == null) {
                        PostHighlightingVisitor.$$$reportNull$$$0(51);
                    }
                    QuickFixAction.registerQuickFixAction(info, quickFixFactory.createAddToImplicitlyWrittenFieldsFix(project, (String)annoName));
                    return true;
                });
                return info;
            }
        } else {
            if (UnusedSymbolUtil.isImplicitUsage(this.myProject, field, progress2) && !UnusedSymbolUtil.isImplicitWrite(this.myProject, field, progress2)) {
                return null;
            }
            if (UnusedSymbolUtil.isFieldUnused(this.myProject, this.myFile, field, progress2, helper)) {
                if (UnusedSymbolUtil.isImplicitWrite(this.myProject, field, progress2)) {
                    String message = JavaErrorMessages.message("private.field.is.not.used.for.reading", identifier.getText());
                    HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
                    QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSafeDeleteFix(field), this.myDeadCodeKey);
                    return highlightInfo;
                }
                return PostHighlightingVisitor.formatUnusedSymbolHighlightInfo(project, "field.is.not.used", field, "fields", this.myDeadCodeKey, this.myDeadCodeInfoType, identifier);
            }
        }
        return null;
    }

    private HighlightInfo suggestionsToMakeFieldUsed(@NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull String message) {
        if (field == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(17);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(18);
        }
        if (message == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(19);
        }
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRemoveUnusedVariableFix(field), this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, false, field), this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(false, true, field), this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, true, field), this.myDeadCodeKey);
        return highlightInfo;
    }

    private boolean isOverriddenOrOverrides(@NotNull PsiMethod method) {
        if (method == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(20);
        }
        return this.isOverriddenOrOverrides.get(method);
    }

    @Nullable
    private HighlightInfo processParameter(@NotNull Project project, @NotNull PsiParameter parameter, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress2) {
        HighlightInfo highlightInfo;
        PsiElement declarationScope;
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(21);
        }
        if (parameter == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(22);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(23);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(24);
        }
        if ((declarationScope = parameter.getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)declarationScope;
            if (PsiUtilCore.hasErrorElementChild(method)) {
                return null;
            }
            if ((method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || !method.hasModifierProperty("abstract") && !this.isOverriddenOrOverrides(method)) && !method.hasModifierProperty("native") && !JavaHighlightUtil.isSerializationRelatedMethod(method, method.getContainingClass()) && !PsiClassImplUtil.isMainOrPremainMethod(method)) {
                if (UnusedSymbolUtil.isInjected(project, method)) {
                    return null;
                }
                HighlightInfo highlightInfo2 = this.checkUnusedParameter(parameter, identifier, progress2);
                if (highlightInfo2 != null) {
                    QuickFixFactory.getInstance().registerFixesForUnusedParameter(parameter, highlightInfo2);
                    return highlightInfo2;
                }
            }
        } else if (declarationScope instanceof PsiForeachStatement && !PsiUtil.isIgnoredName(parameter.getName()) && (highlightInfo = this.checkUnusedParameter(parameter, identifier, progress2)) != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRenameToIgnoredFix(parameter), this.myDeadCodeKey);
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private HighlightInfo checkUnusedParameter(@NotNull PsiParameter parameter, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress2) {
        if (parameter == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(25);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(26);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(27);
        }
        if (!this.myRefCountHolder.isReferenced(parameter) && !UnusedSymbolUtil.isImplicitUsage(this.myProject, parameter, progress2)) {
            String message = JavaErrorMessages.message("parameter.is.not.used", identifier.getText());
            return UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
        }
        return null;
    }

    @Nullable
    private HighlightInfo processMethod(@NotNull Project project, @NotNull PsiMethod method, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress2, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(28);
        }
        if (method == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(29);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(30);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(31);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(32);
        }
        if (UnusedSymbolUtil.isMethodReferenced(this.myProject, this.myFile, method, progress2, helper)) {
            return null;
        }
        String key = method.hasModifierProperty("private") ? (method.isConstructor() ? "private.constructor.is.not.used" : "private.method.is.not.used") : (method.isConstructor() ? "constructor.is.not.used" : "method.is.not.used");
        String symbolName = HighlightMessageUtil.getSymbolName(method, PsiSubstitutor.EMPTY);
        String message = JavaErrorMessages.message(key, symbolName);
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, this.myDeadCodeInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSafeDeleteFix(method), this.myDeadCodeKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes(method, annoName -> {
            if (project == null) {
                PostHighlightingVisitor.$$$reportNull$$$0(50);
            }
            IntentionAction fix = QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, (String)annoName, "methods");
            QuickFixAction.registerQuickFixAction(highlightInfo, fix);
            return true;
        });
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processClass(@NotNull Project project, @NotNull PsiClass aClass2, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress2, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(33);
        }
        if (aClass2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(34);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(35);
        }
        if (progress2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(36);
        }
        if (helper == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(37);
        }
        if (UnusedSymbolUtil.isClassUsed(project, this.myFile, aClass2, progress2, helper)) {
            return null;
        }
        String pattern = aClass2.getContainingClass() != null && aClass2.hasModifierProperty("private") ? (aClass2.isInterface() ? "private.inner.interface.is.not.used" : "private.inner.class.is.not.used") : (aClass2.getParent() instanceof PsiDeclarationStatement ? "local.class.is.not.used" : (aClass2 instanceof PsiTypeParameter ? "type.parameter.is.not.used" : "class.is.not.used"));
        return PostHighlightingVisitor.formatUnusedSymbolHighlightInfo(this.myProject, pattern, aClass2, "classes", this.myDeadCodeKey, this.myDeadCodeInfoType, identifier);
    }

    private static HighlightInfo formatUnusedSymbolHighlightInfo(@NotNull Project project, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorMessages") String pattern, @NotNull PsiNameIdentifierOwner aClass2, @NotNull String element, HighlightDisplayKey highlightDisplayKey, @NotNull HighlightInfoType highlightInfoType, @NotNull PsiElement identifier) {
        if (project == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(38);
        }
        if (pattern == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(39);
        }
        if (aClass2 == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(40);
        }
        if (element == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(41);
        }
        if (highlightInfoType == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(42);
        }
        if (identifier == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(43);
        }
        String symbolName = aClass2.getName();
        String message = JavaErrorMessages.message(pattern, symbolName);
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, highlightInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSafeDeleteFix(aClass2), highlightDisplayKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)((Object)aClass2), annoName -> {
            if (project == null) {
                PostHighlightingVisitor.$$$reportNull$$$0(48);
            }
            if (element == null) {
                PostHighlightingVisitor.$$$reportNull$$$0(49);
            }
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, (String)annoName, element));
            return true;
        });
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        if (importStatement == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(44);
        }
        if (unusedImportKey == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(45);
        }
        if (importStatement.isForeignFileImport()) {
            return null;
        }
        if (PsiUtilCore.hasErrorElementChild(importStatement)) {
            return null;
        }
        boolean isRedundant = this.myRefCountHolder.isRedundant(importStatement);
        if (!isRedundant && !(importStatement instanceof PsiImportStaticStatement)) {
            String qName;
            PsiElement resolved;
            String packageName = ((PsiClassOwner)importStatement.getContainingFile()).getPackageName();
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            PsiElement psiElement = resolved = reference == null ? null : reference.resolve();
            if (resolved instanceof PsiPackage) {
                isRedundant = packageName.equals(((PsiQualifiedNamedElement)resolved).getQualifiedName());
            } else if (resolved instanceof PsiClass && !importStatement.isOnDemand() && (qName = ((PsiClass)resolved).getQualifiedName()) != null) {
                String name = ((PomNamedTarget)((Object)resolved)).getName();
                isRedundant = qName.equals(packageName + '.' + name);
            }
        }
        if (isRedundant) {
            return this.registerRedundantImport(importStatement, unusedImportKey);
        }
        int entryIndex = JavaCodeStyleManager.getInstance(this.myProject).findEntryIndex(importStatement);
        if (entryIndex < this.myCurrentEntryIndex) {
            this.myHasMissortedImports = true;
        }
        this.myCurrentEntryIndex = entryIndex;
        return null;
    }

    private HighlightInfo registerRedundantImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        if (importStatement == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(46);
        }
        if (unusedImportKey == null) {
            PostHighlightingVisitor.$$$reportNull$$$0(47);
        }
        String description2 = InspectionsBundle.message("unused.import.statement", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.UNUSED_IMPORT).range(importStatement).descriptionAndTooltip(description2).create();
        QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createOptimizeImportsFix(false), unusedImportKey);
        QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createEnableOptimizeImportsOnTheFlyFix(), unusedImportKey);
        this.myHasRedundantImports = true;
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refCountHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 30: 
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: 
            case 16: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 12: 
            case 21: 
            case 28: 
            case 33: 
            case 38: 
            case 48: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 41: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImportKey";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "optimizeImportsOnTheFlyLater";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectHighlights";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processIdentifier";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processLocalVariable";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "processField";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestionsToMakeFieldUsed";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "isOverriddenOrOverrides";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "processParameter";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUnusedParameter";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethod";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "formatUnusedSymbolHighlightInfo";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "processImport";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRedundantImport";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$formatUnusedSymbolHighlightInfo$5";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processMethod$4";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processField$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

