/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjustFunctionContextFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Function<PsiMethodCallExpression, Function<PsiType, String>> MAP_NAME_ADJUSTER = call2 -> type2 -> {
        PsiType inType;
        PsiExpression qualifier = call2.getMethodExpression().getQualifierExpression();
        if (qualifier != null && type2.equals(inType = StreamApiUtil.getStreamElementType(qualifier.getType()))) {
            return "map";
        }
        if (PsiType.INT.equals(type2)) {
            return "mapToInt";
        }
        if (PsiType.LONG.equals(type2)) {
            return "mapToLong";
        }
        if (PsiType.DOUBLE.equals(type2)) {
            return "mapToDouble";
        }
        return "mapToObj";
    };
    private static final Function<PsiType, String> FLAT_MAP_NAME_ADJUSTER = type2 -> {
        if (InheritanceUtil.isInheritor(type2, "java.util.stream.IntStream")) {
            return "flatMapToInt";
        }
        if (InheritanceUtil.isInheritor(type2, "java.util.stream.LongStream")) {
            return "flatMapToLong";
        }
        if (InheritanceUtil.isInheritor(type2, "java.util.stream.DoubleStream")) {
            return "flatMapToDouble";
        }
        if (InheritanceUtil.isInheritor(type2, "java.util.stream.Stream")) {
            return "flatMap";
        }
        return null;
    };
    private static final CallMapper<Function<PsiType, String>> METHOD_NAME_ADJUSTER = new CallMapper<Function<PsiMethodCallExpression, Function<PsiType, String>>>().register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.IntStream", "map", "mapToLong", "mapToDouble"), CallMatcher.instanceCall("java.util.stream.LongStream", "map", "mapToInt", "mapToDouble"), CallMatcher.instanceCall("java.util.stream.DoubleStream", "map", "mapToInt", "mapToLong")), MAP_NAME_ADJUSTER).register((CallMatcher)CallMatcher.instanceCall("java.util.stream.Stream", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble"), (Function<PsiMethodCallExpression, Function<PsiType, String>>)FLAT_MAP_NAME_ADJUSTER);
    private final String myOriginalName;
    private final String myNewName;

    protected AdjustFunctionContextFix(@NotNull PsiMethodCallExpression call2, @NotNull String targetMethodName) {
        if (call2 == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(0);
        }
        if (targetMethodName == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(1);
        }
        super(call2);
        this.myOriginalName = call2.getMethodExpression().getReferenceName();
        this.myNewName = targetMethodName;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethodCallExpression call2;
        if (project == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(5);
        }
        if ((call2 = ObjectUtils.tryCast(startElement, PsiMethodCallExpression.class)) == null) {
            return;
        }
        ExpressionUtils.bindCallTo(call2, this.myNewName);
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("adjust.method.accepting.functional.expression.fix.text", this.myOriginalName, this.myNewName);
        if (string == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("adjust.method.accepting.functional.expression.fix.family.name", new Object[0]);
        if (string == null) {
            AdjustFunctionContextFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Contract(value="null -> null")
    @Nullable
    public static AdjustFunctionContextFix createFix(PsiElement context) {
        PsiType actualReturnType;
        if (!(context instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)context;
        PsiFunctionalExpression fn = PsiTreeUtil.getParentOfType(context, PsiFunctionalExpression.class, false);
        if (fn == null) {
            return null;
        }
        PsiExpressionList expressionList = ObjectUtils.tryCast(fn.getParent(), PsiExpressionList.class);
        if (expressionList == null || expressionList.getExpressions().length != 1) {
            return null;
        }
        PsiMethodCallExpression call2 = ObjectUtils.tryCast(expressionList.getParent(), PsiMethodCallExpression.class);
        Function<PsiType, String> remapper2 = METHOD_NAME_ADJUSTER.mapFirst(call2);
        if (remapper2 == null) {
            return null;
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            actualReturnType = PsiMethodReferenceUtil.getMethodReferenceReturnType(methodRef);
        } else {
            actualReturnType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression2, true, () -> expression2.getType());
        }
        String targetMethodName = remapper2.apply(actualReturnType);
        if (targetMethodName == null) {
            return null;
        }
        return new AdjustFunctionContextFix(call2, targetMethodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AdjustFunctionContextFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AdjustFunctionContextFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

