/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.MergePackageAccessibilityStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeProvidesStatementsFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import gnu.trove.THashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeModuleStatementsFix<T extends PsiElement>
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected MergeModuleStatementsFix(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(0);
        }
        super(javaModule);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(4);
        }
        return PsiUtil.isLanguageLevel9OrHigher(file2);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(8);
        }
        if (startElement instanceof PsiJavaModule) {
            PsiJavaModule javaModule = (PsiJavaModule)startElement;
            List<T> statementsToMerge = this.getStatementsToMerge(javaModule);
            LOG.assertTrue(!statementsToMerge.isEmpty());
            String tempModuleText = "module " + javaModule.getName() + " {" + this.getReplacementText(statementsToMerge) + "}";
            PsiJavaModule tempModule = JavaPsiFacade.getInstance(project).getElementFactory().createModuleFromText(tempModuleText);
            List<T> tempStatements = this.getStatementsToMerge(tempModule);
            LOG.assertTrue(!tempStatements.isEmpty());
            PsiElement replacement = (PsiElement)tempStatements.get(0);
            PsiElement firstStatement = (PsiElement)statementsToMerge.get(0);
            CommentTracker commentTracker = new CommentTracker();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
            PsiElement resultingStatement = codeStyleManager.reformat(commentTracker.replace(firstStatement, replacement));
            for (int i2 = 1; i2 < statementsToMerge.size(); ++i2) {
                PsiElement statement2 = (PsiElement)statementsToMerge.get(i2);
                commentTracker.delete(statement2);
            }
            commentTracker.insertCommentsBefore(resultingStatement);
            if (editor != null) {
                int offset2 = resultingStatement.getTextRange().getEndOffset();
                editor.getCaretModel().moveToOffset(offset2);
            }
        }
    }

    @NotNull
    protected abstract String getReplacementText(List<T> var1);

    @NotNull
    protected abstract List<T> getStatementsToMerge(@NotNull PsiJavaModule var1);

    @NotNull
    protected static String joinUniqueNames(@NotNull List<String> names2) {
        if (names2 == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(9);
        }
        THashSet unique = new THashSet();
        String string = names2.stream().filter(name -> unique.add(name)).collect(Collectors.joining(","));
        if (string == null) {
            MergeModuleStatementsFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiElement statement2) {
        if (statement2 instanceof PsiPackageAccessibilityStatement) {
            return MergePackageAccessibilityStatementsFix.createFix((PsiPackageAccessibilityStatement)statement2);
        }
        if (statement2 instanceof PsiProvidesStatement) {
            return MergeProvidesStatementsFix.createFix((PsiProvidesStatement)statement2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "joinUniqueNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "joinUniqueNames";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

