/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnFixFactory
extends ArgumentFixerActionFactory {
    public static final ArgumentFixerActionFactory INSTANCE = new MethodReturnFixFactory();

    private MethodReturnFixFactory() {
    }

    @Override
    @Nullable
    protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
        PsiMethodCallExpression call2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(expression2), PsiMethodCallExpression.class);
        if (call2 == null) {
            return null;
        }
        PsiMethod method = call2.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiType type2 = GenericsUtil.getVariableTypeByExpressionType(toType);
        return JavaPsiFacade.getElementFactory(expression2.getProject()).createExpressionFromText("(" + type2.getCanonicalText() + ")null", expression2);
    }

    @Override
    public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
        if (exprType == null) {
            MethodReturnFixFactory.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            MethodReturnFixFactory.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MethodReturnFixFactory.$$$reportNull$$$0(2);
        }
        return !PsiType.VOID.equals(exprType) && exprType.equalsToText(exprType.getCanonicalText());
    }

    @Override
    public IntentionAction createFix(PsiExpressionList list2, int i2, PsiType toType) {
        PsiMethodCallExpression call2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(list2.getExpressions()[i2]), PsiMethodCallExpression.class);
        if (call2 == null) {
            return null;
        }
        PsiMethod method = call2.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiReferenceExpression ref = call2.getMethodExpression();
        if (!ReferencesSearch.search(method, new LocalSearchScope(list2)).forEach(r -> r == ref)) {
            return null;
        }
        return QuickFixFactory.getInstance().createMethodReturnFix(method, toType, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "exprType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parameterType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnFixFactory";
        objectArray[2] = "areTypesConvertible";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

