/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationPsiFix
extends LocalQuickFixOnPsiElement {
    protected final String myAnnotation;
    private final String[] myAnnotationsToRemove;
    private final PsiNameValuePair[] myPairs;
    protected final String myText;

    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, @NotNull PsiNameValuePair[] values2, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(0);
        }
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(1);
        }
        if (values2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(2);
        }
        if (annotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(3);
        }
        super(modifierListOwner);
        this.myAnnotation = fqn;
        ObjectUtils.assertAllElementsNotNull(values2);
        this.myPairs = values2;
        ObjectUtils.assertAllElementsNotNull(annotationsToRemove);
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myText = AddAnnotationPsiFix.calcText(modifierListOwner, this.myAnnotation);
    }

    public static String calcText(PsiModifierListOwner modifierListOwner, @NotNull String annotation2) {
        String name;
        if (annotation2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(4);
        }
        String shortName = annotation2.substring(annotation2.lastIndexOf(46) + 1);
        if (modifierListOwner instanceof PsiNamedElement && (name = ((PsiNamedElement)((Object)modifierListOwner)).getName()) != null) {
            FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(modifierListOwner.getLanguage());
            return CodeInsightBundle.message("inspection.i18n.quickfix.annotate.element.as", provider.getType(modifierListOwner), name, shortName);
        }
        return CodeInsightBundle.message("inspection.i18n.quickfix.annotate.as", shortName);
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file2, int offset2) {
        PsiElement id;
        PsiElement target;
        PsiReference reference = file2.findReferenceAt(offset2);
        if (reference != null && (target = reference.resolve()) instanceof PsiMember) {
            return (PsiMember)target;
        }
        PsiElement element = file2.findElementAt(offset2);
        PsiModifierListOwner listOwner = PsiTreeUtil.getParentOfType(element, PsiModifierListOwner.class, false);
        if (listOwner instanceof PsiParameter) {
            return listOwner;
        }
        if (listOwner instanceof PsiNameIdentifierOwner && (id = ((PsiNameIdentifierOwner)((Object)listOwner)).getNameIdentifier()) != null && id.getTextRange().containsOffset(offset2)) {
            return listOwner;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = "Add '" + StringUtil.getShortName(this.myAnnotation) + "' Annotation";
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(10);
        }
        return AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)startElement, this.myAnnotation);
    }

    public static boolean isAvailable(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotationFQN) {
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(11);
        }
        if (annotationFQN == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(12);
        }
        if (!modifierListOwner.isValid()) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(modifierListOwner)) {
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        return modifierList != null && !(modifierList instanceof LightElement) && !(modifierListOwner instanceof LightElement) && !AnnotationUtil.isAnnotated(modifierListOwner, annotationFQN, false, false, true);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(14);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(15);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(16);
        }
        PsiModifierListOwner myModifierListOwner = (PsiModifierListOwner)startElement;
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
        PsiModifierList modifierList = myModifierListOwner.getModifierList();
        if (modifierList == null || modifierList.findAnnotation(this.myAnnotation) != null) {
            return;
        }
        PsiClass aClass2 = JavaPsiFacade.getInstance(project).findClass(this.myAnnotation, myModifierListOwner.getResolveScope());
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = aClass2 != null && aClass2.getManager().isInProject(aClass2) && AnnotationsHighlightUtil.getRetentionPolicy(aClass2) == RetentionPolicy.RUNTIME ? ExternalAnnotationsManager.AnnotationPlace.IN_CODE : annotationsManager.chooseAnnotationsPlace(myModifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            for (String fqn : this.myAnnotationsToRemove) {
                annotationsManager.deannotate(myModifierListOwner, fqn);
            }
            try {
                annotationsManager.annotateExternally(myModifierListOwner, this.myAnnotation, file2, this.myPairs);
            }
            catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {}
        } else {
            PsiFile containingFile = myModifierListOwner.getContainingFile();
            WriteCommandAction.runWriteCommandAction(project, null, null, () -> {
                if (project == null) {
                    AddAnnotationPsiFix.$$$reportNull$$$0(20);
                }
                AddAnnotationPsiFix.removePhysicalAnnotations(myModifierListOwner, this.myAnnotationsToRemove);
                PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotation(this.myAnnotation, this.myPairs, modifierList);
                JavaCodeStyleManager.getInstance(project).shortenClassReferences(inserted);
            }, containingFile);
            if (containingFile != file2) {
                UndoUtil.markPsiFileForUndo(file2);
            }
        }
    }

    public static PsiAnnotation addPhysicalAnnotation(String fqn, PsiNameValuePair[] pairs, PsiModifierList modifierList) {
        PsiAnnotation inserted = modifierList.addAnnotation(fqn);
        for (PsiNameValuePair pair : pairs) {
            inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
        }
        return inserted;
    }

    public static void removePhysicalAnnotations(@NotNull PsiModifierListOwner owner, String ... fqns) {
        if (owner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(17);
        }
        if (fqns == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(18);
        }
        for (String fqn : fqns) {
            PsiAnnotation annotation2 = AnnotationUtil.findAnnotation(owner, true, fqn);
            if (annotation2 == null || AnnotationUtil.isInferredAnnotation(annotation2)) continue;
            annotation2.delete();
        }
    }

    @NotNull
    protected String[] getAnnotationsToRemove() {
        if (this.myAnnotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(19);
        }
        return this.myAnnotationsToRemove;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 7: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcText";
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removePhysicalAnnotations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

