/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ColorUtil {
    private ColorUtil() {
    }

    public static String generatePreviewHtml(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        return String.format("<div style=\"padding: 1px; width: 52px; height: 32px; background-color: #555555;\"><div style=\"width: 50px; height: 30px; background-color: #%s;\">&nbsp;</div></div>", com.intellij.ui.ColorUtil.toHex(color));
    }

    public static void appendColorPreview(PsiVariable variable2, StringBuilder buffer) {
        PsiType type2;
        PsiExpression initializer2 = variable2.getInitializer();
        if (initializer2 != null && (type2 = initializer2.getType()) != null && "java.awt.Color".equals(type2.getCanonicalText())) {
            Color c;
            PsiField psiField;
            PsiClass psiClass;
            PsiElement psiElement;
            PsiReference reference;
            if (initializer2 instanceof PsiNewExpression) {
                PsiExpressionList argumentList2 = ((PsiNewExpression)initializer2).getArgumentList();
                if (argumentList2 != null) {
                    PsiExpression[] expressions = argumentList2.getExpressions();
                    int[] values2 = ArrayUtil.newIntArray(expressions.length);
                    float[] values22 = new float[expressions.length];
                    int i2 = 0;
                    int j = 0;
                    PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance(initializer2.getProject()).getConstantEvaluationHelper();
                    for (PsiExpression each : expressions) {
                        Object o = helper.computeConstantExpression(each);
                        if (o instanceof Integer) {
                            values2[i2] = (Integer)o;
                            values2[i2] = values2[i2] > 255 && expressions.length > 1 ? 255 : (values2[i2] < 0 ? 0 : values2[i2]);
                            ++i2;
                            continue;
                        }
                        if (!(o instanceof Float)) continue;
                        values22[j] = ((Float)o).floatValue();
                        values22[j] = values22[j] > 1.0f ? 1.0f : (values22[j] < 0.0f ? 0.0f : values22[j]);
                        ++j;
                    }
                    Color c2 = null;
                    if (i2 == expressions.length) {
                        switch (values2.length) {
                            case 1: {
                                c2 = new Color(values2[0]);
                                break;
                            }
                            case 3: {
                                c2 = new Color(values2[0], values2[1], values2[2]);
                                break;
                            }
                            case 4: {
                                c2 = new Color(values2[0], values2[1], values2[2], values2[3]);
                                break;
                            }
                        }
                    } else if (j == expressions.length) {
                        switch (values22.length) {
                            case 3: {
                                c2 = new Color(values22[0], values22[1], values22[2]);
                                break;
                            }
                            case 4: {
                                c2 = new Color(values22[0], values22[1], values22[2], values22[3]);
                                break;
                            }
                        }
                    }
                    if (c2 != null) {
                        buffer.append(ColorUtil.generatePreviewHtml(c2));
                    }
                }
            } else if (initializer2 instanceof PsiReferenceExpression && (reference = initializer2.getReference()) != null && (psiElement = reference.resolve()) instanceof PsiField && (psiClass = (psiField = (PsiField)psiElement).getContainingClass()) != null && "java.awt.Color".equals(psiClass.getQualifiedName()) && (c = ReflectionUtil.getStaticFieldValue(Color.class, Color.class, psiField.getName())) != null) {
                buffer.append(ColorUtil.generatePreviewHtml(c));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/javadoc/ColorUtil", "generatePreviewHtml"));
    }
}

