/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantExplicitVariableTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.getLanguageLevel(holder.getFile()).isAtLeast(LanguageLevel.JDK_X)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitLocalVariable(PsiLocalVariable variable2) {
                PsiTypeElement typeElement = variable2.getTypeElement();
                if (!typeElement.isInferredType()) {
                    PsiElement parent2 = variable2.getParent();
                    if (parent2 instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent2).getDeclaredElements().length > 1) {
                        return;
                    }
                    this.doCheck(variable2, (PsiLocalVariable)variable2.copy(), typeElement);
                }
            }

            @Override
            public void visitForeachStatement(PsiForeachStatement statement2) {
                super.visitForeachStatement(statement2);
                PsiParameter parameter = statement2.getIterationParameter();
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement != null && !typeElement.isInferredType()) {
                    PsiForeachStatement copy = (PsiForeachStatement)statement2.copy();
                    this.doCheck(parameter, copy.getIterationParameter(), typeElement);
                }
            }

            private void doCheck(PsiVariable variable2, PsiVariable copyVariable, PsiTypeElement element2Highlight) {
                PsiTypeElement typeElementCopy = copyVariable.getTypeElement();
                if (typeElementCopy != null) {
                    RedundantExplicitVariableTypeInspection.replaceExplicitTypeWithVar(typeElementCopy, variable2);
                    if (variable2.getType().equals(copyVariable.getType())) {
                        holder.registerProblem((PsiElement)element2Highlight, "Explicit type of local variable is redundant", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new ReplaceWithVarFix());
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("RedundantExplicitVariableType" == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(3);
        }
        return "RedundantExplicitVariableType";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.explicit.var.type.display.name", new Object[0]);
        if (string == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Java Experimental" == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(5);
        }
        return "Java Experimental";
    }

    @Override
    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Java", "Java language level migration aids", "Java Experimental"};
        if (stringArray == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(7);
        }
        return highlightDisplayLevel;
    }

    private static PsiElement replaceExplicitTypeWithVar(PsiTypeElement typeElement, PsiElement context) {
        return typeElement.replace(JavaPsiFacade.getElementFactory(context.getProject()).createTypeElementFromText("var", context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithVarFix
    implements LocalQuickFix {
        private ReplaceWithVarFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace explicit type with 'var'" == null) {
                ReplaceWithVarFix.$$$reportNull$$$0(0);
            }
            return "Replace explicit type with 'var'";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ReplaceWithVarFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithVarFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) instanceof PsiTypeElement) {
                CodeStyleManager.getInstance(project).reformat(RedundantExplicitVariableTypeInspection.replaceExplicitTypeWithVar((PsiTypeElement)element, element));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection$ReplaceWithVarFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection$ReplaceWithVarFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

