/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;

public class RemoveAnnotationQuickFix
implements LocalQuickFix {
    private final PsiAnnotation myAnnotation;
    private final PsiModifierListOwner myListOwner;

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation2, PsiModifierListOwner listOwner) {
        if (annotation2 == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(0);
        }
        this.myAnnotation = annotation2;
        this.myListOwner = listOwner;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message("remove.annotation", new Object[0]);
        if (string == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(3);
        }
        if (this.myAnnotation.isPhysical()) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite(this.myAnnotation)) {
                return;
            }
            WriteAction.run(() -> this.myAnnotation.delete());
        } else if (this.myListOwner != null) {
            ExternalAnnotationsManager.getInstance(project).deannotate(this.myListOwner, this.myAnnotation.getQualifiedName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

