/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnalysisConverter {
    private static final ThreadLocalCachedValue<MessageDigest> HASHER_CACHE = new ThreadLocalCachedValue<MessageDigest>(){

        @Override
        public MessageDigest create() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        protected void init(MessageDigest value) {
            value.reset();
        }
    };

    public static MessageDigest getMessageDigest() {
        return HASHER_CACHE.getValue();
    }

    @Nullable
    public static EKey psiKey(@NotNull PsiMethod psiMethod, @NotNull Direction direction) {
        PsiClass psiClass;
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(1);
        }
        if ((psiClass = psiMethod.getContainingClass()) == null) {
            return null;
        }
        String className2 = BytecodeAnalysisConverter.descriptor(psiClass, 0, false);
        String methodSig = BytecodeAnalysisConverter.methodSignature(psiMethod);
        if (className2 == null || methodSig == null) {
            return null;
        }
        String methodName = psiMethod.getReturnType() == null ? "<init>" : psiMethod.getName();
        return new EKey((MethodDescriptor)new Method(className2, methodName, methodSig), direction, true, false);
    }

    @Nullable
    private static String methodSignature(@NotNull PsiMethod psiMethod) {
        String desc;
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(2);
        }
        StringBuilder sb = new StringBuilder();
        PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class, false);
        if (psiClass == null) {
            return null;
        }
        PsiClass outerClass2 = psiClass.getContainingClass();
        boolean isInnerClassConstructor = psiMethod.isConstructor() && outerClass2 != null && !psiClass.hasModifierProperty("static");
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        PsiType returnType = psiMethod.getReturnType();
        sb.append('(');
        if (isInnerClassConstructor) {
            desc = BytecodeAnalysisConverter.descriptor(outerClass2, 0, true);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        for (PsiParameter parameter : parameters2) {
            desc = BytecodeAnalysisConverter.descriptor(parameter.getType());
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        sb.append(')');
        if (returnType == null) {
            sb.append('V');
        } else {
            desc = BytecodeAnalysisConverter.descriptor(returnType);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiClass psiClass, int dimensions, boolean full) {
        PsiFile containingFile;
        if (psiClass == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(3);
        }
        if (!((containingFile = psiClass.getContainingFile()) instanceof PsiClassOwner)) {
            ProjectBytecodeAnalysis.LOG.debug("containingFile was not resolved for " + psiClass.getQualifiedName());
            return null;
        }
        PsiClassOwner psiFile = (PsiClassOwner)containingFile;
        String packageName = psiFile.getPackageName();
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return null;
        }
        String className2 = packageName.length() > 0 ? qname.substring(packageName.length() + 1).replace('.', '$') : qname.replace('.', '$');
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < dimensions; ++i2) {
            sb.append('[');
        }
        if (full) {
            sb.append('L');
        }
        if (packageName.length() > 0) {
            sb.append(packageName.replace('.', '/'));
            sb.append('/');
        }
        sb.append(className2);
        if (full) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiType psiType) {
        if (psiType == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(4);
        }
        int dimensions = 0;
        if ((psiType = TypeConversionUtil.erasure(psiType)) instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            psiType = arrayType.getDeepComponentType();
            dimensions = arrayType.getArrayDimensions();
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass != null) {
                return BytecodeAnalysisConverter.descriptor(psiClass, dimensions, true);
            }
            ProjectBytecodeAnalysis.LOG.debug("resolve was null for " + psiType.getCanonicalText());
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < dimensions; ++i2) {
                sb.append('[');
            }
            if (PsiType.VOID.equals(psiType)) {
                sb.append('V');
            } else if (PsiType.BOOLEAN.equals(psiType)) {
                sb.append('Z');
            } else if (PsiType.CHAR.equals(psiType)) {
                sb.append('C');
            } else if (PsiType.BYTE.equals(psiType)) {
                sb.append('B');
            } else if (PsiType.SHORT.equals(psiType)) {
                sb.append('S');
            } else if (PsiType.INT.equals(psiType)) {
                sb.append('I');
            } else if (PsiType.FLOAT.equals(psiType)) {
                sb.append('F');
            } else if (PsiType.LONG.equals(psiType)) {
                sb.append('J');
            } else if (PsiType.DOUBLE.equals(psiType)) {
                sb.append('D');
            }
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static ArrayList<EKey> mkInOutKeys(@NotNull PsiMethod psiMethod, @NotNull EKey primaryKey) {
        if (psiMethod == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(5);
        }
        if (primaryKey == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(6);
        }
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        ArrayList<EKey> keys2 = new ArrayList<EKey>(parameters2.length * 2 + 2);
        keys2.add(primaryKey);
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            if (!(parameters2[i2].getType() instanceof PsiPrimitiveType)) {
                keys2.add(primaryKey.withDirection(new Direction.InOut(i2, Value.NotNull)));
                keys2.add(primaryKey.withDirection(new Direction.InOut(i2, Value.Null)));
                keys2.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.NotNull)));
                keys2.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.Null)));
                continue;
            }
            if (!PsiType.BOOLEAN.equals(parameters2[i2].getType())) continue;
            keys2.add(primaryKey.withDirection(new Direction.InOut(i2, Value.True)));
            keys2.add(primaryKey.withDirection(new Direction.InOut(i2, Value.False)));
            keys2.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.True)));
            keys2.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.False)));
        }
        ArrayList<EKey> arrayList = keys2;
        if (arrayList == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static void addMethodAnnotations(@NotNull Map<EKey, Value> solution2, @NotNull MethodAnnotations methodAnnotations, @NotNull EKey methodKey, int arity) {
        if (solution2 == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(8);
        }
        if (methodAnnotations == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(9);
        }
        if (methodKey == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(10);
        }
        ArrayList<StandardMethodContract> contractClauses = new ArrayList<StandardMethodContract>();
        Set<EKey> notNulls = methodAnnotations.notNulls;
        Set<EKey> pures = methodAnnotations.pures;
        Map<EKey, String> contracts2 = methodAnnotations.contractsValues;
        for (Map.Entry<EKey, Value> entry : solution2.entrySet()) {
            Value value = entry.getValue();
            if (value == Value.Top || value == Value.Bot || value == Value.Fail && !pures.contains(methodKey)) continue;
            EKey key = entry.getKey().mkStable();
            Direction direction = key.getDirection();
            EKey baseKey = key.mkBase();
            if (!methodKey.equals(baseKey)) continue;
            if (value == Value.NotNull && direction == Direction.Out) {
                notNulls.add(methodKey);
                continue;
            }
            if (value == Value.Pure && direction == Direction.Pure) {
                pures.add(methodKey);
                continue;
            }
            if (!(direction instanceof Direction.ParamValueBasedDirection)) continue;
            contractClauses.add(BytecodeAnalysisConverter.contractElement(arity, (Direction.ParamValueBasedDirection)direction, value));
        }
        if (!notNulls.contains(methodKey) && !contractClauses.isEmpty()) {
            String result2;
            StandardMethodContract contract;
            Map partition = StreamEx.of(contractClauses).partitioningBy(c -> c.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION);
            List<StandardMethodContract> failingContracts = BytecodeAnalysisConverter.squashContracts((List)partition.get(true));
            List<StandardMethodContract> nonFailingContracts = BytecodeAnalysisConverter.squashContracts((List)partition.get(false));
            if (nonFailingContracts.size() == 1 && (contract = nonFailingContracts.get(0)).getReturnValue() == MethodContract.ValueConstraint.NOT_NULL_VALUE && contract.isTrivial()) {
                nonFailingContracts = Collections.emptyList();
                notNulls.add(methodKey);
            }
            if (!(result2 = StreamEx.of((Object[])new List[]{failingContracts, nonFailingContracts}).flatMap(list2 -> list2.stream().map(Object::toString).map(str -> str.replace(" ", "")).sorted()).joining(";")).isEmpty()) {
                contracts2.put(methodKey, '\"' + result2 + '\"');
            }
        }
    }

    @NotNull
    private static List<StandardMethodContract> squashContracts(List<StandardMethodContract> contractClauses) {
        StandardMethodContract soleContract = StreamEx.ofPairs(contractClauses, (c1, c2) -> {
            if (c1.getReturnValue() != c2.getReturnValue()) {
                return null;
            }
            int idx = -1;
            for (int i2 = 0; i2 < c1.arguments.length; ++i2) {
                MethodContract.ValueConstraint left = c1.arguments[i2];
                MethodContract.ValueConstraint right = c2.arguments[i2];
                if (left == MethodContract.ValueConstraint.ANY_VALUE && right == MethodContract.ValueConstraint.ANY_VALUE) continue;
                if (idx >= 0 || !right.canBeNegated() || left != right.negate()) {
                    return null;
                }
                idx = i2;
            }
            return c1;
        }).nonNull().findFirst().orElse(null);
        if (soleContract != null) {
            Arrays.fill((Object[])soleContract.arguments, (Object)MethodContract.ValueConstraint.ANY_VALUE);
            contractClauses = Collections.singletonList(soleContract);
        }
        List<StandardMethodContract> list2 = contractClauses;
        if (list2 == null) {
            BytecodeAnalysisConverter.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public static void addEffectAnnotations(Map<EKey, Effects> puritySolutions, MethodAnnotations result2, EKey methodKey, boolean constructor) {
        for (Map.Entry<EKey, Effects> entry : puritySolutions.entrySet()) {
            Set<EffectQuantum> effects = entry.getValue().effects;
            EKey key = entry.getKey().mkStable();
            EKey baseKey = key.mkBase();
            if (!methodKey.equals(baseKey) || !effects.isEmpty() && (!constructor || effects.size() != 1 || !effects.contains(EffectQuantum.ThisChangeQuantum))) continue;
            result2.pures.add(methodKey);
        }
    }

    private static StandardMethodContract contractElement(int arity, Direction.ParamValueBasedDirection inOut, Value value) {
        MethodContract.ValueConstraint[] constraints = new MethodContract.ValueConstraint[arity];
        Arrays.fill((Object[])constraints, (Object)MethodContract.ValueConstraint.ANY_VALUE);
        constraints[inOut.paramIndex] = inOut.inValue.toValueConstraint();
        return new StandardMethodContract(constraints, value.toValueConstraint());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryKey";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "solution";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodAnnotations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mkInOutKeys";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "squashContracts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiKey";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "methodSignature";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "descriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mkInOutKeys";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMethodAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

