/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Analysis;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.MakeResult;
import com.intellij.codeInspection.bytecodeAnalysis.NotNullInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProceedState;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.TooComplexException;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class NonNullInAnalysis
extends Analysis<PResults.PResult> {
    private final PendingAction[] pendingActions;
    private final PResults.PResult[] results;
    private final NotNullInterpreter interpreter = new NotNullInterpreter();
    boolean possibleNPE;
    private int id;
    private Frame<BasicValue> nextFrame;
    private PResults.PResult subResult;
    private int pendingTop;

    protected NonNullInAnalysis(RichControlFlow richControlFlow, Direction direction, boolean stable, PendingAction[] pendingActions, PResults.PResult[] results) {
        super(richControlFlow, direction, stable);
        this.pendingActions = pendingActions;
        this.results = results;
    }

    PResults.PResult combineResults(PResults.PResult delta, int[] subResults) throws AnalyzerException {
        PResults.PResult result2 = PResults.Identity;
        for (int subResult : subResults) {
            result2 = PResults.join(result2, this.results[subResult]);
        }
        return PResults.meet(delta, result2);
    }

    @NotNull
    Equation mkEquation(PResults.PResult result2) {
        if (PResults.Identity == result2 || PResults.Return == result2) {
            Equation equation = new Equation(this.aKey, new Final(Value.Top));
            if (equation == null) {
                NonNullInAnalysis.$$$reportNull$$$0(0);
            }
            return equation;
        }
        if (PResults.NPE == result2) {
            Equation equation = new Equation(this.aKey, new Final(Value.NotNull));
            if (equation == null) {
                NonNullInAnalysis.$$$reportNull$$$0(1);
            }
            return equation;
        }
        PResults.ConditionalNPE condNpe = (PResults.ConditionalNPE)result2;
        Set<Component> components = condNpe.sop.stream().map(prod -> new Component(Value.Top, (Set<EKey>)prod)).collect(Collectors.toSet());
        Equation equation = new Equation(this.aKey, new Pending(components));
        if (equation == null) {
            NonNullInAnalysis.$$$reportNull$$$0(2);
        }
        return equation;
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        this.pendingPush(new ProceedState(this.createStartState()));
        int steps = 0;
        while (this.pendingTop > 0 && this.earlyResult == null) {
            TooComplexException.check(this.method, ++steps);
            PendingAction action2 = this.pendingActions[--this.pendingTop];
            if (action2 instanceof MakeResult) {
                MakeResult makeResult = (MakeResult)action2;
                PResults.PResult result2 = this.combineResults(makeResult.subResult, makeResult.indices);
                State state2 = makeResult.state;
                int insnIndex = state2.conf.insnIndex;
                this.results[state2.index] = result2;
                this.addComputed(insnIndex, state2);
                continue;
            }
            if (!(action2 instanceof ProceedState)) continue;
            ProceedState proceedState = (ProceedState)action2;
            State state3 = proceedState.state;
            int insnIndex = state3.conf.insnIndex;
            Conf conf = state3.conf;
            List<Conf> history = state3.history;
            boolean fold = false;
            if (this.dfsTree.loopEnters[insnIndex]) {
                for (Conf prev : history) {
                    if (!AbstractValues.isInstance(conf, prev)) continue;
                    fold = true;
                    break;
                }
            }
            if (fold) {
                this.results[state3.index] = PResults.Identity;
                this.addComputed(insnIndex, state3);
                continue;
            }
            State baseState = null;
            List thisComputed = this.computed[insnIndex];
            if (thisComputed != null) {
                for (State prevState : thisComputed) {
                    if (!NonNullInAnalysis.stateEquiv(state3, prevState)) continue;
                    baseState = prevState;
                    break;
                }
            }
            if (baseState != null) {
                this.results[state3.index] = this.results[baseState.index];
                continue;
            }
            this.processState(state3);
        }
        if (this.earlyResult != null) {
            Equation equation = this.mkEquation((PResults.PResult)this.earlyResult);
            if (equation == null) {
                NonNullInAnalysis.$$$reportNull$$$0(3);
            }
            return equation;
        }
        Equation equation = this.mkEquation(this.results[0]);
        if (equation == null) {
            NonNullInAnalysis.$$$reportNull$$$0(4);
        }
        return equation;
    }

    private void processState(State state2) throws AnalyzerException {
        int i2;
        boolean notEmptySubResult;
        int stateIndex = state2.index;
        Conf conf = state2.conf;
        int insnIndex = conf.insnIndex;
        List<Conf> history = state2.history;
        boolean taken = state2.taken;
        Frame<BasicValue> frame = conf.frame;
        AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
        List<Conf> nextHistory = this.dfsTree.loopEnters[insnIndex] ? NonNullInAnalysis.append(history, conf) : history;
        boolean hasCompanions = state2.hasCompanions;
        this.execute(frame, insnNode);
        boolean bl = notEmptySubResult = this.subResult != PResults.Identity;
        if (this.subResult == PResults.NPE) {
            this.results[stateIndex] = PResults.NPE;
            this.possibleNPE = true;
            this.addComputed(insnIndex, state2);
            return;
        }
        int opcode = insnNode.getOpcode();
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                if (!hasCompanions) {
                    this.earlyResult = PResults.Return;
                } else {
                    this.results[stateIndex] = PResults.Return;
                    this.addComputed(insnIndex, state2);
                }
                return;
            }
        }
        if (opcode == 191) {
            if (taken) {
                this.results[stateIndex] = PResults.NPE;
                this.possibleNPE = true;
            } else {
                this.results[stateIndex] = PResults.Identity;
            }
            this.addComputed(insnIndex, state2);
            return;
        }
        if (opcode == 199 && NonNullInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state2.unsure);
            this.pendingPush(new MakeResult(state2, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 198 && NonNullInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf(((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state2.unsure);
            this.pendingPush(new MakeResult(state2, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 153 && NonNullInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf(((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state2.unsure);
            this.pendingPush(new MakeResult(state2, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 154 && NonNullInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult, state2.unsure);
            this.pendingPush(new MakeResult(state2, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        int[] nextInsnIndices = this.controlFlow.transitions[insnIndex];
        int[] subIndices = new int[nextInsnIndices.length];
        for (i2 = 0; i2 < nextInsnIndices.length; ++i2) {
            subIndices[i2] = ++this.id;
        }
        this.pendingPush(new MakeResult(state2, this.subResult, subIndices));
        for (i2 = 0; i2 < nextInsnIndices.length; ++i2) {
            int nextInsnIndex = nextInsnIndices[i2];
            Frame<BasicValue> nextFrame1 = this.nextFrame;
            boolean exceptional = state2.unsure;
            if (this.controlFlow.errors[nextInsnIndex] && this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) {
                nextFrame1 = NonNullInAnalysis.createCatchFrame(frame);
                exceptional = true;
            }
            this.pendingPush(new ProceedState(new State(subIndices[i2], new Conf(nextInsnIndex, nextFrame1), nextHistory, taken, hasCompanions || notEmptySubResult, exceptional)));
        }
    }

    private void pendingPush(PendingAction action2) {
        TooComplexException.check(this.method, this.pendingTop);
        this.pendingActions[this.pendingTop++] = action2;
    }

    private void execute(Frame<BasicValue> frame, AbstractInsnNode insnNode) throws AnalyzerException {
        switch (insnNode.getType()) {
            case 8: 
            case 14: 
            case 15: {
                this.nextFrame = frame;
                this.subResult = PResults.Identity;
                break;
            }
            default: {
                this.nextFrame = new Frame<BasicValue>(frame);
                this.interpreter.reset(false);
                this.nextFrame.execute(insnNode, this.interpreter);
                this.subResult = this.interpreter.getSubResult();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/NonNullInAnalysis";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mkEquation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyze";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

