/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Analysis;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.TooComplexException;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class NullableInAnalysis
extends Analysis<PResults.PResult> {
    private final State[] pending;
    private final NullableInterpreter interpreter = new NullableInterpreter();
    private int id;
    private Frame<BasicValue> nextFrame;
    private PResults.PResult myResult = PResults.Identity;
    private PResults.PResult subResult = PResults.Identity;
    private boolean top;
    private int pendingTop;

    protected NullableInAnalysis(RichControlFlow richControlFlow, Direction direction, boolean stable, State[] pending) {
        super(richControlFlow, direction, stable);
        this.pending = pending;
    }

    @NotNull
    Equation mkEquation(PResults.PResult result2) {
        if (PResults.NPE == result2) {
            Equation equation = new Equation(this.aKey, new Final(Value.Top));
            if (equation == null) {
                NullableInAnalysis.$$$reportNull$$$0(0);
            }
            return equation;
        }
        if (PResults.Identity == result2 || PResults.Return == result2) {
            Equation equation = new Equation(this.aKey, new Final(Value.Null));
            if (equation == null) {
                NullableInAnalysis.$$$reportNull$$$0(1);
            }
            return equation;
        }
        PResults.ConditionalNPE condNpe = (PResults.ConditionalNPE)result2;
        Set<Component> components = condNpe.sop.stream().map(prod -> new Component(Value.Top, (Set<EKey>)prod)).collect(Collectors.toSet());
        Equation equation = new Equation(this.aKey, new Pending(components));
        if (equation == null) {
            NullableInAnalysis.$$$reportNull$$$0(2);
        }
        return equation;
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        this.pendingPush(this.createStartState());
        int steps = 0;
        while (this.pendingTop > 0 && this.earlyResult == null) {
            TooComplexException.check(this.method, ++steps);
            State state2 = this.pending[--this.pendingTop];
            int insnIndex = state2.conf.insnIndex;
            Conf conf = state2.conf;
            List<Conf> history = state2.history;
            boolean fold = false;
            if (this.dfsTree.loopEnters[insnIndex]) {
                for (Conf prev : history) {
                    if (!AbstractValues.isInstance(conf, prev)) continue;
                    fold = true;
                    break;
                }
            }
            if (fold) {
                this.addComputed(insnIndex, state2);
                continue;
            }
            State baseState = null;
            List thisComputed = this.computed[insnIndex];
            if (thisComputed != null) {
                for (State prevState : thisComputed) {
                    if (!NullableInAnalysis.stateEquiv(state2, prevState)) continue;
                    baseState = prevState;
                    break;
                }
            }
            if (baseState != null) continue;
            this.processState(state2);
        }
        if (this.earlyResult != null) {
            Equation equation = this.mkEquation((PResults.PResult)this.earlyResult);
            if (equation == null) {
                NullableInAnalysis.$$$reportNull$$$0(3);
            }
            return equation;
        }
        Equation equation = this.mkEquation(this.myResult);
        if (equation == null) {
            NullableInAnalysis.$$$reportNull$$$0(4);
        }
        return equation;
    }

    private void processState(State state2) throws AnalyzerException {
        Conf conf = state2.conf;
        int insnIndex = conf.insnIndex;
        List<Conf> history = state2.history;
        boolean taken = state2.taken;
        Frame<BasicValue> frame = conf.frame;
        AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
        List<Conf> nextHistory = this.dfsTree.loopEnters[insnIndex] ? NullableInAnalysis.append(history, conf) : history;
        this.addComputed(insnIndex, state2);
        this.execute(frame, insnNode, taken);
        if (this.subResult == PResults.NPE || this.top) {
            this.earlyResult = PResults.NPE;
            return;
        }
        if (this.subResult instanceof PResults.ConditionalNPE) {
            this.myResult = PResults.combineNullable(this.myResult, this.subResult);
        }
        int opcode = insnNode.getOpcode();
        switch (opcode) {
            case 176: {
                if (NullableInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
                    this.earlyResult = PResults.NPE;
                }
                return;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 177: {
                return;
            }
        }
        if (opcode == 191) {
            if (taken) {
                this.earlyResult = PResults.NPE;
            }
            return;
        }
        if (opcode == 199 && NullableInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = insnIndex + 1;
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        if (opcode == 198 && NullableInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf(((JumpInsnNode)insnNode).label);
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        if (opcode == 153 && NullableInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf(((JumpInsnNode)insnNode).label);
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        if (opcode == 154 && NullableInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = insnIndex + 1;
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        for (int nextInsnIndex : this.controlFlow.transitions[insnIndex]) {
            Frame<BasicValue> nextFrame1 = this.nextFrame;
            if (this.controlFlow.errors[nextInsnIndex] && this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) {
                nextFrame1 = NullableInAnalysis.createCatchFrame(frame);
            }
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, nextFrame1), nextHistory, taken, false, false));
        }
    }

    private void pendingPush(State state2) {
        TooComplexException.check(this.method, this.pendingTop);
        this.pending[this.pendingTop++] = state2;
    }

    private void execute(Frame<BasicValue> frame, AbstractInsnNode insnNode, boolean taken) throws AnalyzerException {
        switch (insnNode.getType()) {
            case 8: 
            case 14: 
            case 15: {
                this.nextFrame = frame;
                this.subResult = PResults.Identity;
                this.top = false;
                break;
            }
            default: {
                this.nextFrame = new Frame<BasicValue>(frame);
                this.interpreter.reset(taken);
                this.nextFrame.execute(insnNode, this.interpreter);
                this.subResult = this.interpreter.getSubResult();
                this.top = this.interpreter.top;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/NullableInAnalysis";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mkEquation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyze";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

