/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import org.jetbrains.annotations.Contract;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

public class ASMUtils {
    public static final Type THROWABLE_TYPE = Type.getType("java/lang/Throwable");
    public static final BasicValue THROWABLE_VALUE = new BasicValue(THROWABLE_TYPE);

    @Contract(pure=true)
    public static boolean isReferenceType(Type tp) {
        int sort = tp.getSort();
        return sort == 10 || sort == 9;
    }

    @Contract(pure=true)
    public static boolean isBooleanType(Type tp) {
        return Type.BOOLEAN_TYPE.equals(tp);
    }

    @Contract(pure=true)
    public static int getSizeFast(String desc) {
        switch (desc.charAt(0)) {
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    @Contract(pure=true)
    public static int getReturnSizeFast(String methodDesc) {
        switch (methodDesc.charAt(methodDesc.indexOf(41) + 1)) {
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    @Contract(pure=true)
    public static boolean isReferenceReturnType(String methodDesc) {
        switch (methodDesc.charAt(methodDesc.indexOf(41) + 1)) {
            case 'L': 
            case '[': {
                return true;
            }
        }
        return false;
    }
}

