/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.Subroutine;
import com.intellij.codeInspection.bytecodeAnalysis.asm.SubroutineFinder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public class FramelessAnalyzer
extends SubroutineFinder {
    private static final Set<String> NPE_HANDLERS = ContainerUtil.set("java/lang/Throwable", "java/lang/Exception", "java/lang/RuntimeException", "java/lang/NullPointerException");
    protected boolean[] wasQueued;
    protected boolean[] queued;
    protected int[] queue;
    protected int top;
    protected final EdgeCreator myEdgeCreator;

    public FramelessAnalyzer(EdgeCreator creator) {
        this.myEdgeCreator = creator;
    }

    public void analyze(MethodNode m) throws AnalyzerException {
        this.n = m.instructions.size();
        if ((m.access & 0x500) != 0 || this.n == 0) {
            return;
        }
        this.insns = m.instructions;
        this.handlers = new List[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.wasQueued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            int begin = this.insns.indexOf(tcb.start);
            int end = this.insns.indexOf(tcb.end);
            for (int j = begin; j < end; ++j) {
                ArrayList<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Subroutine main2 = new Subroutine(null, m.maxLocals, null);
        ArrayList<AbstractInsnNode> subroutineCalls = new ArrayList<AbstractInsnNode>();
        HashMap<LabelNode, Subroutine> subroutineHeads = new HashMap<LabelNode, Subroutine>();
        this.findSubroutine(0, main2, subroutineCalls);
        while (!subroutineCalls.isEmpty()) {
            JumpInsnNode jsr = (JumpInsnNode)subroutineCalls.remove(0);
            Subroutine sub2 = (Subroutine)subroutineHeads.get(jsr.label);
            if (sub2 == null) {
                sub2 = new Subroutine(jsr.label, m.maxLocals, jsr);
                subroutineHeads.put(jsr.label, sub2);
                this.findSubroutine(this.insns.indexOf(jsr.label), sub2, subroutineCalls);
                continue;
            }
            sub2.callers.add(jsr);
        }
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.subroutines[i2] == null || this.subroutines[i2].start != null) continue;
            this.subroutines[i2] = null;
        }
        this.merge(0, null);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Subroutine subroutine = this.subroutines[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insn + 1, subroutine);
                    this.myEdgeCreator.newControlFlowEdge(insn, insn + 1);
                } else {
                    LabelNode label2;
                    int j;
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, subroutine);
                            this.myEdgeCreator.newControlFlowEdge(insn, insn + 1);
                        }
                        int jump = this.insns.indexOf(j2.label);
                        if (insnOpcode == 168) {
                            this.merge(jump, new Subroutine(j2.label, m.maxLocals, j2));
                        } else {
                            this.merge(jump, subroutine);
                        }
                        this.myEdgeCreator.newControlFlowEdge(insn, jump);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        int jump = this.insns.indexOf(lsi.dflt);
                        this.merge(jump, subroutine);
                        this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            label2 = lsi.labels.get(j);
                            jump = this.insns.indexOf(label2);
                            this.merge(jump, subroutine);
                            this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        int jump = this.insns.indexOf(tsi.dflt);
                        this.merge(jump, subroutine);
                        this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            label2 = tsi.labels.get(j);
                            jump = this.insns.indexOf(label2);
                            this.merge(jump, subroutine);
                            this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(insnNode, "RET instruction outside of a sub routine");
                        }
                        for (int i3 = 0; i3 < subroutine.callers.size(); ++i3) {
                            JumpInsnNode caller2 = subroutine.callers.get(i3);
                            int call2 = this.insns.indexOf(caller2);
                            if (!this.wasQueued[call2]) continue;
                            this.merge(call2 + 1, this.subroutines[call2], subroutine.access);
                            this.myEdgeCreator.newControlFlowEdge(insn, call2 + 1);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.access[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                            }
                        }
                        this.merge(insn + 1, subroutine);
                        this.myEdgeCreator.newControlFlowEdge(insn, insn + 1);
                    }
                }
                if ((insnHandlers = this.handlers[insn]) == null) continue;
                for (TryCatchBlockNode tcb : insnHandlers) {
                    this.newControlFlowExceptionEdge(insn, tcb);
                    this.merge(this.insns.indexOf(tcb.handler), subroutine);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insn + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insn + ": " + e.getMessage(), e);
            }
        }
    }

    protected boolean newControlFlowExceptionEdge(int insn, TryCatchBlockNode tcb) {
        return this.myEdgeCreator.newControlFlowExceptionEdge(insn, this.insns.indexOf(tcb.handler), NPE_HANDLERS.contains(tcb.type));
    }

    protected void merge(int insn, @Nullable Subroutine subroutine) throws AnalyzerException {
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes = false;
        if (!this.wasQueued[insn]) {
            this.wasQueued[insn] = true;
            changes = true;
        }
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insn] = subroutine.copy();
                changes = true;
            }
        } else if (subroutine != null) {
            changes |= oldSubroutine.merge(subroutine);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    protected void merge(int insn, Subroutine subroutineBeforeJSR, boolean[] access) throws AnalyzerException {
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes = false;
        if (!this.wasQueued[insn]) {
            this.wasQueued[insn] = true;
            changes = true;
        }
        if (oldSubroutine != null && subroutineBeforeJSR != null) {
            changes |= oldSubroutine.merge(subroutineBeforeJSR);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    static interface EdgeCreator {
        public void newControlFlowEdge(int var1, int var2);

        public boolean newControlFlowExceptionEdge(int var1, int var2, boolean var3);
    }
}

