/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CommonDataflow {
    @Contract(value="null -> null")
    @Nullable
    private static DataflowResult runDFA(@Nullable PsiElement block) {
        if (block == null) {
            return null;
        }
        DataFlowRunner runner = new DataFlowRunner(false, !DfaUtil.isInsideConstructorOrInitializer(block));
        final DfaConstValue fail = runner.getFactory().getConstFactory().getContractFail();
        final DataflowResult dfr = new DataflowResult();
        StandardInstructionVisitor visitor2 = new StandardInstructionVisitor(){

            @Override
            public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                DfaInstructionState[] states = super.visitPush(instruction, runner, memState);
                PsiExpression place = instruction.getPlace();
                if (place != null) {
                    for (DfaInstructionState state2 : states) {
                        dfr.add(place, (DfaMemoryStateImpl)state2.getMemoryState());
                    }
                }
                return states;
            }

            @Override
            public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
                PsiExpression context = ObjectUtils.tryCast(instruction.getContext(), PsiExpression.class);
                if (context != null) {
                    for (DfaInstructionState state2 : states) {
                        DfaValue value = state2.getMemoryState().peek();
                        if (value == fail) continue;
                        dfr.add(context, (DfaMemoryStateImpl)state2.getMemoryState());
                    }
                }
                return states;
            }
        };
        RunnerResult result2 = runner.analyzeMethod(block, visitor2);
        return result2 == RunnerResult.OK ? dfr : null;
    }

    private static DataflowResult getDataflowResult(PsiElement context) {
        PsiElement body2;
        PsiMember member = PsiTreeUtil.getParentOfType(context, PsiMember.class);
        if (!(member instanceof PsiMethod || member instanceof PsiField || member instanceof PsiClassInitializer)) {
            return null;
        }
        PsiElement psiElement = body2 = member instanceof PsiMethod ? ((PsiMethod)member).getBody() : member.getContainingClass();
        if (body2 == null) {
            return null;
        }
        return (DataflowResult)CachedValuesManager.getCachedValue(body2, () -> {
            DataflowResult result2 = CommonDataflow.runDFA(body2);
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    public static <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
        DataflowResult result2 = CommonDataflow.getDataflowResult(expression2);
        if (result2 == null) {
            return null;
        }
        DfaFactMap map2 = (DfaFactMap)result2.myFacts.get(expression2);
        return map2 == null ? null : (T)map2.get(type2);
    }

    static class DataflowResult {
        private final Map<PsiExpression, DfaFactMap> myFacts = new HashMap<PsiExpression, DfaFactMap>();

        DataflowResult() {
        }

        void add(PsiExpression expression2, DfaMemoryStateImpl memState) {
            DfaFactMap existing = this.myFacts.get(expression2);
            if (existing != DfaFactMap.EMPTY) {
                DfaValue value = memState.peek();
                DfaFactMap newMap = memState.getFactMap(value);
                this.myFacts.put(expression2, existing == null ? newMap : existing.union(newMap));
            }
        }
    }
}

