/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;

public abstract class ContractValue {
    ContractValue() {
    }

    abstract DfaValue makeDfaValue(DfaValueFactory var1, DfaCallArguments var2);

    boolean isBoundCheckingCondition() {
        return false;
    }

    public static ContractValue qualifier() {
        return Qualifier.INSTANCE;
    }

    public static ContractValue argument(int index2) {
        return new Argument(index2);
    }

    public ContractValue specialField(SpecialField field) {
        return new Spec(this, field);
    }

    public static ContractValue constant(Object value, PsiType type2) {
        return new IndependentValue(factory2 -> factory2.getConstFactory().createFromValue(value, type2, null), String.valueOf(value));
    }

    public static ContractValue booleanValue(boolean value) {
        return value ? IndependentValue.TRUE : IndependentValue.FALSE;
    }

    public static ContractValue optionalValue(boolean present) {
        return present ? IndependentValue.OPTIONAL_PRESENT : IndependentValue.OPTIONAL_ABSENT;
    }

    public static ContractValue nullValue() {
        return IndependentValue.NULL;
    }

    public static ContractValue zero() {
        return IndependentValue.ZERO;
    }

    public static ContractValue condition(ContractValue left, DfaRelationValue.RelationType relation, ContractValue right) {
        return new Condition(left, relation, right);
    }

    private static class Condition
    extends ContractValue {
        private final ContractValue myLeft;
        private final ContractValue myRight;
        private final DfaRelationValue.RelationType myRelationType;

        Condition(ContractValue left, DfaRelationValue.RelationType type2, ContractValue right) {
            this.myLeft = left;
            this.myRight = right;
            this.myRelationType = type2;
        }

        @Override
        boolean isBoundCheckingCondition() {
            switch (this.myRelationType) {
                case LE: 
                case LT: 
                case GE: 
                case GT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory2, DfaCallArguments arguments2) {
            return factory2.createCondition(this.myLeft.makeDfaValue(factory2, arguments2), this.myRelationType, this.myRight.makeDfaValue(factory2, arguments2));
        }

        public String toString() {
            return this.myLeft + " " + (Object)((Object)this.myRelationType) + " " + this.myRight;
        }
    }

    private static class Spec
    extends ContractValue {
        private final ContractValue myQualifier;
        private final SpecialField myField;

        Spec(ContractValue qualifier, SpecialField field) {
            this.myQualifier = qualifier;
            this.myField = field;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory2, DfaCallArguments arguments2) {
            return this.myField.createValue(factory2, this.myQualifier.makeDfaValue(factory2, arguments2));
        }

        public String toString() {
            return this.myQualifier + "." + this.myField.getMethodName() + "()";
        }
    }

    private static class IndependentValue
    extends ContractValue {
        static final IndependentValue NULL = new IndependentValue(factory2 -> factory2.getConstFactory().getNull(), "null");
        static final IndependentValue TRUE = new IndependentValue(factory2 -> factory2.getConstFactory().getTrue(), "true");
        static final IndependentValue FALSE = new IndependentValue(factory2 -> factory2.getConstFactory().getFalse(), "false");
        static final IndependentValue OPTIONAL_PRESENT = new IndependentValue(factory2 -> factory2.getOptionalFactory().getOptional(true), "present");
        static final IndependentValue OPTIONAL_ABSENT = new IndependentValue(factory2 -> factory2.getOptionalFactory().getOptional(false), "empty");
        static final IndependentValue ZERO = new IndependentValue(factory2 -> factory2.getInt(0), "0");
        private final Function<DfaValueFactory, DfaValue> mySupplier;
        private final String myPresentation;

        IndependentValue(Function<DfaValueFactory, DfaValue> supplier, String presentation) {
            this.mySupplier = supplier;
            this.myPresentation = presentation;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory2, DfaCallArguments arguments2) {
            return this.mySupplier.fun(factory2);
        }

        public String toString() {
            return this.myPresentation;
        }
    }

    private static class Argument
    extends ContractValue {
        private final int myIndex;

        Argument(int index2) {
            this.myIndex = index2;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory2, DfaCallArguments arguments2) {
            return arguments2.myArguments.length <= this.myIndex ? DfaUnknownValue.getInstance() : arguments2.myArguments[this.myIndex];
        }

        public String toString() {
            return "arg#" + this.myIndex;
        }
    }

    private static class Qualifier
    extends ContractValue {
        static final Qualifier INSTANCE = new Qualifier();

        private Qualifier() {
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory2, DfaCallArguments arguments2) {
            return arguments2.myQualifier;
        }

        public String toString() {
            return "this";
        }
    }
}

