/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRangeValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaFactType<T>
extends Key<T> {
    private static final List<DfaFactType<?>> ourFactTypes = new ArrayList();
    public static final DfaFactType<Boolean> CAN_BE_NULL = new DfaFactType<Boolean>("Can be null"){

        @Override
        String toString(Boolean fact) {
            return fact != false ? "Nullable" : "NotNull";
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value) {
            if (value instanceof DfaConstValue) {
                return ((DfaConstValue)value).getValue() == null;
            }
            if (value instanceof DfaBoxedValue || value instanceof DfaUnboxedValue || value instanceof DfaRangeValue) {
                return false;
            }
            if (value instanceof DfaTypeValue) {
                return NullnessUtil.toBoolean(((DfaTypeValue)value).getNullness());
            }
            return null;
        }

        @Override
        @Nullable
        Boolean calcFromVariable(@NotNull DfaVariableValue value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            return NullnessUtil.calcCanBeNull(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactType$1", "calcFromVariable"));
        }
    };
    public static final DfaFactType<Boolean> OPTIONAL_PRESENCE = new DfaFactType<Boolean>("Optional presense"){

        @Override
        String toString(Boolean fact) {
            return fact != false ? "present Optional" : "absent Optional";
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value) {
            return value instanceof DfaOptionalValue ? Boolean.valueOf(((DfaOptionalValue)value).isPresent()) : null;
        }
    };
    public static final DfaFactType<LongRangeSet> RANGE = new DfaFactType<LongRangeSet>("Range"){

        @Override
        boolean isSuper(@Nullable LongRangeSet superFact, @Nullable LongRangeSet subFact) {
            return superFact == null || subFact != null && superFact.contains(subFact);
        }

        @Override
        @Nullable
        LongRangeSet fromDfaValue(DfaValue value) {
            if (value instanceof DfaVariableValue) {
                return this.calcFromVariable((DfaVariableValue)value);
            }
            return LongRangeSet.fromDfaValue(value);
        }

        @Override
        @Nullable
        LongRangeSet calcFromVariable(@NotNull DfaVariableValue var) {
            if (var == null) {
                3.$$$reportNull$$$0(0);
            }
            if (var.getQualifier() != null) {
                for (SpecialField sf : SpecialField.values()) {
                    if (!sf.isMyAccessor(var.getPsiVariable())) continue;
                    return sf.getRange();
                }
            }
            PsiModifierListOwner psiVariable = var.getPsiVariable();
            LongRangeSet fromType = LongRangeSet.fromType(var.getVariableType());
            return fromType == null ? null : LongRangeSet.fromAnnotation(psiVariable).intersect(fromType);
        }

        @Override
        @Nullable
        LongRangeSet unionFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            if (left == null) {
                3.$$$reportNull$$$0(1);
            }
            if (right == null) {
                3.$$$reportNull$$$0(2);
            }
            return left.union(right);
        }

        @Override
        @Nullable
        LongRangeSet intersectFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            LongRangeSet intersection;
            if (left == null) {
                3.$$$reportNull$$$0(3);
            }
            if (right == null) {
                3.$$$reportNull$$$0(4);
            }
            return (intersection = left.intersect(right)).isEmpty() ? null : intersection;
        }

        @Override
        String toString(LongRangeSet fact) {
            return fact.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcFromVariable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unionFacts";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intersectFacts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final DfaFactType<TypeConstraint> TYPE_CONSTRAINT = new DfaFactType<TypeConstraint>("Type"){

        @Override
        @Nullable
        TypeConstraint fromDfaValue(DfaValue value) {
            if (value instanceof DfaTypeValue) {
                TypeConstraint constraint = TypeConstraint.EMPTY.withInstanceofValue((DfaTypeValue)value);
                return constraint == null || constraint.isEmpty() ? null : constraint;
            }
            return null;
        }

        @Override
        boolean isSuper(@Nullable TypeConstraint superFact, @Nullable TypeConstraint subFact) {
            return superFact == null || subFact != null && superFact.isSuperStateOf(subFact);
        }

        @Override
        @Nullable
        TypeConstraint intersectFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                4.$$$reportNull$$$0(0);
            }
            if (right == null) {
                4.$$$reportNull$$$0(1);
            }
            for (DfaPsiType type2 : right.getInstanceofValues()) {
                if ((left = left.withInstanceofValue(type2)) != null) continue;
                return null;
            }
            for (DfaPsiType type2 : right.getNotInstanceofValues()) {
                if ((left = left.withNotInstanceofValue(type2)) != null) continue;
                return null;
            }
            return left;
        }

        @Override
        @Nullable
        TypeConstraint unionFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                4.$$$reportNull$$$0(2);
            }
            if (right == null) {
                4.$$$reportNull$$$0(3);
            }
            if (left.isSuperStateOf(right)) {
                return left;
            }
            if (right.isSuperStateOf(left)) {
                return right;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intersectFacts";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unionFacts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private DfaFactType(String name) {
        super("DfaFactType: " + name);
        ourFactTypes.add(this);
    }

    @Nullable
    T fromDfaValue(DfaValue value) {
        return null;
    }

    @Nullable
    T calcFromVariable(@NotNull DfaVariableValue value) {
        if (value == null) {
            DfaFactType.$$$reportNull$$$0(0);
        }
        return null;
    }

    boolean isSuper(@Nullable T superFact, @Nullable T subFact) {
        return Objects.equals(superFact, subFact);
    }

    @Nullable
    T intersectFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(1);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(2);
        }
        return (T)(left.equals(right) ? left : null);
    }

    @Nullable
    T unionFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(3);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(4);
        }
        return (T)(left.equals(right) ? left : null);
    }

    String toString(T fact) {
        return fact.toString();
    }

    static List<DfaFactType<?>> getTypes() {
        return Collections.unmodifiableList(ourFactTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcFromVariable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "intersectFacts";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "unionFacts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

