/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.StateMerger;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class StateQueue {
    private final PriorityQueue<DfaInstructionState> myQueue = new PriorityQueue();
    private final Set<Pair<Instruction, DfaMemoryState>> mySet = ContainerUtil.newHashSet();

    StateQueue() {
    }

    void offer(DfaInstructionState state2) {
        if (this.mySet.add(Pair.create(state2.getInstruction(), state2.getMemoryState()))) {
            this.myQueue.offer(state2);
        }
    }

    boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    boolean processAll(@NotNull Processor<? super DfaInstructionState> processor) {
        if (processor == null) {
            StateQueue.$$$reportNull$$$0(0);
        }
        for (DfaInstructionState state2 : this.myQueue) {
            if (processor.process(state2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    List<DfaInstructionState> getNextInstructionStates(Set<Instruction> joinInstructions) {
        DfaInstructionState state2 = this.myQueue.poll();
        Instruction instruction = state2.getInstruction();
        this.mySet.remove(Pair.create(instruction, state2.getMemoryState()));
        DfaInstructionState next = this.myQueue.peek();
        if (next == null || next.compareTo(state2) != 0) {
            List<DfaInstructionState> list2 = Collections.singletonList(state2);
            if (list2 == null) {
                StateQueue.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<DfaMemoryStateImpl> memoryStates = ContainerUtil.newArrayList();
        memoryStates.add((DfaMemoryStateImpl)state2.getMemoryState());
        while (!this.myQueue.isEmpty() && this.myQueue.peek().compareTo(state2) == 0) {
            DfaMemoryState anotherState = this.myQueue.poll().getMemoryState();
            this.mySet.remove(Pair.create(instruction, anotherState));
            memoryStates.add((DfaMemoryStateImpl)anotherState);
        }
        if (memoryStates.size() > 1 && joinInstructions.contains(instruction)) {
            MultiMap<Object, DfaMemoryStateImpl> groups2 = MultiMap.create();
            for (DfaMemoryStateImpl dfaMemoryStateImpl : memoryStates) {
                groups2.putValue(dfaMemoryStateImpl.getSuperficialKey(), dfaMemoryStateImpl);
            }
            memoryStates = ContainerUtil.newArrayList();
            for (Map.Entry entry : groups2.entrySet()) {
                memoryStates.addAll(StateQueue.mergeGroup((List)entry.getValue()));
            }
        }
        List<DfaInstructionState> list3 = ContainerUtil.map(memoryStates, state1 -> new DfaInstructionState(instruction, (DfaMemoryState)state1));
        if (list3 == null) {
            StateQueue.$$$reportNull$$$0(2);
        }
        return list3;
    }

    private static List<DfaMemoryStateImpl> mergeGroup(List<DfaMemoryStateImpl> group) {
        if (group.size() < 2) {
            return group;
        }
        StateMerger merger = new StateMerger();
        while (true) {
            List<DfaMemoryStateImpl> nextStates;
            if ((nextStates = merger.mergeByRanges(group)) == null) {
                nextStates = merger.mergeByFacts(group);
            }
            if (nextStates == null) {
                nextStates = merger.mergeByNullability(group);
            }
            if (nextStates == null) {
                nextStates = merger.mergeByUnknowns(group);
            }
            if (nextStates == null) break;
            group = nextStates;
        }
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StateQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateQueue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextInstructionStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

