/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class CollectionFactoryInliner
implements CallInliner {
    private static final CallMapper<FactoryInfo> STATIC_FACTORIES = new CallMapper<FactoryInfo>().register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet").parameterCount(0), new FactoryInfo(0, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "singletonList", "singleton").parameterCount(1), new FactoryInfo(1, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyMap").parameterCount(0), new FactoryInfo(0, SpecialField.MAP_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "singletonMap").parameterCount(2), new FactoryInfo(1, SpecialField.MAP_SIZE));

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call2) {
        PsiExpression[] args;
        FactoryInfo factoryInfo;
        if (builder == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(0);
        }
        if (call2 == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(1);
        }
        if ((factoryInfo = STATIC_FACTORIES.mapFirst(call2)) == null) {
            return false;
        }
        for (PsiExpression arg : args = call2.getArgumentList().getExpressions()) {
            builder.pushExpression(arg).pop();
        }
        PsiVariable variable2 = builder.createTempVariable(call2.getType());
        DfaValueFactory factory2 = builder.getFactory();
        DfaVariableValue variableValue = factory2.getVarFactory().createVariableValue(variable2, false);
        builder.pushVariable(variable2).push(factory2.createTypeValue(call2.getType(), Nullness.NOT_NULL)).assign().push(factoryInfo.mySizeField.createValue(factory2, variableValue)).push(factory2.getInt(factoryInfo.mySize)).assign().pop();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/inliner/CollectionFactoryInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class FactoryInfo {
        int mySize;
        SpecialField mySizeField;

        public FactoryInfo(int size, SpecialField sizeField) {
            this.mySize = size;
            this.mySizeField = sizeField;
        }
    }
}

