/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaVariableValue
extends DfaValue {
    private final PsiModifierListOwner myVariable;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfaVariableValue myNegatedValue;
    private final boolean myIsNegated;
    private DfaFactMap myInherentFacts;
    private final DfaTypeValue myTypeValue;
    private final List<DfaVariableValue> myDependents;

    private DfaVariableValue(@NotNull PsiModifierListOwner variable2, @Nullable PsiType varType, boolean isNegated, DfaValueFactory factory2, @Nullable DfaVariableValue qualifier) {
        if (variable2 == null) {
            DfaVariableValue.$$$reportNull$$$0(0);
        }
        super(factory2);
        this.myDependents = new SmartList<DfaVariableValue>();
        this.myVariable = variable2;
        this.myIsNegated = isNegated;
        this.myQualifier = qualifier;
        this.myVarType = varType;
        DfaValue typeValue = this.myFactory.createTypeValue(varType, Nullness.UNKNOWN);
        DfaTypeValue dfaTypeValue = this.myTypeValue = typeValue instanceof DfaTypeValue ? (DfaTypeValue)typeValue : null;
        if (varType != null && !varType.isValid()) {
            PsiUtil.ensureValidType(varType, "Variable: " + variable2 + " of class " + variable2.getClass());
        }
    }

    @Nullable
    public DfaTypeValue getTypeValue() {
        return this.myTypeValue;
    }

    @NotNull
    public PsiModifierListOwner getPsiVariable() {
        PsiModifierListOwner psiModifierListOwner = this.myVariable;
        if (psiModifierListOwner == null) {
            DfaVariableValue.$$$reportNull$$$0(1);
        }
        return psiModifierListOwner;
    }

    @Nullable
    public PsiType getVariableType() {
        return this.myVarType;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Nullable
    public DfaVariableValue getNegatedValue() {
        return this.myNegatedValue;
    }

    @Override
    public DfaVariableValue createNegated() {
        if (this.myNegatedValue != null) {
            return this.myNegatedValue;
        }
        this.myNegatedValue = this.myFactory.getVarFactory().createVariableValue(this.myVariable, this.myVarType, !this.myIsNegated, this.myQualifier);
        return this.myNegatedValue;
    }

    public String toString() {
        return (this.myIsNegated ? "!" : "") + ((PsiNamedElement)((Object)this.myVariable)).getName() + (this.myQualifier == null ? "" : "|" + this.myQualifier.toString());
    }

    private boolean hardEquals(PsiModifierListOwner psiVar, PsiType varType, boolean negated, DfaVariableValue qualifier) {
        return (psiVar == this.myVariable || SpecialField.ARRAY_LENGTH.isMyAccessor(psiVar) && SpecialField.ARRAY_LENGTH.isMyAccessor(this.myVariable)) && negated == this.myIsNegated && qualifier == this.myQualifier && Comparing.equal(TypeConversionUtil.erasure(varType), TypeConversionUtil.erasure(this.myVarType));
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    public DfaFactMap getInherentFacts() {
        if (this.myInherentFacts == null) {
            this.myInherentFacts = DfaFactMap.calcFromVariable(this);
        }
        return this.myInherentFacts;
    }

    @NotNull
    public Nullness getInherentNullability() {
        Nullness nullness = NullnessUtil.fromBoolean(this.getInherentFacts().get(DfaFactType.CAN_BE_NULL));
        if (nullness == null) {
            DfaVariableValue.$$$reportNull$$$0(2);
        }
        return nullness;
    }

    public boolean isFlushableByCalls() {
        boolean specialFinalField;
        if (this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter || ControlFlowAnalyzer.isTempVariable(this.myVariable)) {
            return false;
        }
        boolean finalField = this.myVariable instanceof PsiVariable && this.myVariable.hasModifierProperty("final");
        boolean bl = specialFinalField = this.myVariable instanceof PsiMethod && Arrays.stream(SpecialField.values()).anyMatch(sf -> sf.isFinal() && sf.isMyAccessor(this.myVariable));
        if (finalField || specialFinalField) {
            return this.myQualifier != null && this.myQualifier.isFlushableByCalls();
        }
        return true;
    }

    public boolean containsCalls() {
        return this.myVariable instanceof PsiMethod || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherentNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        private final MultiMap<Trinity<Boolean, String, DfaVariableValue>, DfaVariableValue> myExistingVars = new MultiMap();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory2) {
            this.myFactory = factory2;
        }

        @NotNull
        public DfaVariableValue createVariableValue(PsiVariable myVariable, boolean isNegated) {
            PsiType varType = myVariable.getType();
            if (varType instanceof PsiEllipsisType) {
                varType = new PsiArrayType(((PsiEllipsisType)varType).getComponentType());
            }
            DfaVariableValue dfaVariableValue = this.createVariableValue(myVariable, varType, isNegated, null);
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return dfaVariableValue;
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull PsiModifierListOwner myVariable, @Nullable PsiType varType, boolean isNegated, @Nullable DfaVariableValue qualifier) {
            if (myVariable == null) {
                Factory.$$$reportNull$$$0(1);
            }
            Trinity<Boolean, String, DfaVariableValue> key = Trinity.create(isNegated, ((PsiNamedElement)((Object)myVariable)).getName(), qualifier);
            for (DfaVariableValue aVar : this.myExistingVars.get(key)) {
                if (!aVar.hardEquals(myVariable, varType, isNegated, qualifier)) continue;
                DfaVariableValue dfaVariableValue = aVar;
                if (dfaVariableValue == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return dfaVariableValue;
            }
            DfaVariableValue result2 = new DfaVariableValue(myVariable, varType, isNegated, this.myFactory, qualifier);
            this.myExistingVars.putValue(key, result2);
            while (qualifier != null) {
                qualifier.myDependents.add(result2);
                qualifier = qualifier.getQualifier();
            }
            DfaVariableValue dfaVariableValue = result2;
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return dfaVariableValue;
        }

        @NotNull
        public List<DfaVariableValue> getAllQualifiedBy(@NotNull DfaVariableValue value) {
            if (value == null) {
                Factory.$$$reportNull$$$0(4);
            }
            List list2 = value.myDependents;
            if (list2 == null) {
                Factory.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myVariable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createVariableValue";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllQualifiedBy";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createVariableValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllQualifiedBy";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

