/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.deadCode.RefUnreachableFilter;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationInspectionBase
extends GlobalInspectionTool {
    private static final Logger LOG = Logger.getInstance(UnusedDeclarationInspectionBase.class);
    public boolean ADD_MAINS_TO_ENTRIES = true;
    public boolean ADD_APPLET_TO_ENTRIES = true;
    public boolean ADD_SERVLET_TO_ENTRIES = true;
    public boolean ADD_NONJAVA_TO_ENTRIES = true;
    private boolean TEST_ENTRY_POINTS = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message("inspection.dead.code.display.name", new Object[0]);
    public static final String SHORT_NAME = "unused";
    public static final String ALTERNATIVE_ID = "UnusedDeclaration";
    final List<EntryPoint> myExtensions = ContainerUtil.createLockFreeCopyOnWriteList();
    final UnusedSymbolLocalInspectionBase myLocalInspectionBase = this.createUnusedSymbolLocalInspection();
    private Set<RefElement> myProcessedSuspicious;
    private int myPhase;
    private final boolean myEnabledInEditor;

    public UnusedDeclarationInspectionBase() {
        this(!ApplicationManager.getApplication().isUnitTestMode());
    }

    public UnusedDeclarationInspectionBase(boolean enabledInEditor) {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        EntryPoint[] extensions = (EntryPoint[])point.getExtensions();
        ArrayList<EntryPoint> deadCodeAddIns = new ArrayList<EntryPoint>(extensions.length);
        for (EntryPoint entryPoint : extensions) {
            try {
                deadCodeAddIns.add(entryPoint.clone());
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        Collections.sort(deadCodeAddIns, (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        this.myExtensions.addAll(deadCodeAddIns);
        this.myEnabledInEditor = enabledInEditor;
    }

    protected UnusedSymbolLocalInspectionBase createUnusedSymbolLocalInspection() {
        return new UnusedSymbolLocalInspectionBase();
    }

    @Override
    @NotNull
    public UnusedSymbolLocalInspectionBase getSharedLocalInspectionTool() {
        UnusedSymbolLocalInspectionBase unusedSymbolLocalInspectionBase = this.myLocalInspectionBase;
        if (unusedSymbolLocalInspectionBase == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(0);
        }
        return unusedSymbolLocalInspectionBase;
    }

    private boolean isAddMainsEnabled() {
        return this.ADD_MAINS_TO_ENTRIES;
    }

    private boolean isAddAppletEnabled() {
        return this.ADD_APPLET_TO_ENTRIES;
    }

    private boolean isAddServletEnabled() {
        return this.ADD_SERVLET_TO_ENTRIES;
    }

    private boolean isAddNonJavaUsedEnabled() {
        return this.ADD_NONJAVA_TO_ENTRIES;
    }

    public boolean isTestEntryPoints() {
        return this.TEST_ENTRY_POINTS;
    }

    public void setTestEntryPoints(boolean testEntryPoints) {
        this.TEST_ENTRY_POINTS = testEntryPoints;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(3);
        }
        return SHORT_NAME;
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(4);
        }
        super.readSettings(node);
        this.myLocalInspectionBase.readSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.readExternal(node);
        }
        String testEntriesAttr = node.getAttributeValue("test_entries");
        this.TEST_ENTRY_POINTS = testEntriesAttr == null || Boolean.parseBoolean(testEntriesAttr);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(5);
        }
        this.myLocalInspectionBase.writeSettings(node);
        this.writeUnusedDeclarationSettings(node);
        if (!this.TEST_ENTRY_POINTS) {
            node.setAttribute("test_entries", Boolean.toString(false));
        }
    }

    protected void writeUnusedDeclarationSettings(Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.writeExternal(node);
        }
    }

    private static boolean isExternalizableNoParameterConstructor(@NotNull PsiMethod method, RefClass refClass) {
        if (method == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(6);
        }
        if (!method.isConstructor()) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 0) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        return aClass2 == null || UnusedDeclarationInspectionBase.isExternalizable(aClass2, refClass);
    }

    private static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        String name;
        if (field == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(7);
        }
        if (!"serialVersionUID".equals(name = field.getName()) && !"serialPersistentFields".equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass2 = field.getContainingClass();
        return aClass2 == null || UnusedDeclarationInspectionBase.isSerializable(aClass2, null);
    }

    private static boolean isWriteObjectMethod(@NotNull PsiMethod method, RefClass refClass) {
        String name;
        if (method == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(8);
        }
        if (!"writeObject".equals(name = method.getName())) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(parameters2[0].getType(), "java.io.ObjectOutputStream")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        return aClass2 == null || UnusedDeclarationInspectionBase.isSerializable(aClass2, refClass);
    }

    private static boolean isReadObjectMethod(@NotNull PsiMethod method, RefClass refClass) {
        String name;
        if (method == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(9);
        }
        if (!"readObject".equals(name = method.getName())) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(parameters2[0].getType(), "java.io.ObjectInputStream")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        return aClass2 == null || UnusedDeclarationInspectionBase.isSerializable(aClass2, refClass);
    }

    private static boolean isWriteReplaceMethod(@NotNull PsiMethod method, RefClass refClass) {
        String name;
        if (method == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(10);
        }
        if (!"writeReplace".equals(name = method.getName())) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 0) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(method.getReturnType(), "java.lang.Object")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        return aClass2 == null || UnusedDeclarationInspectionBase.isSerializable(aClass2, refClass);
    }

    private static boolean isReadResolveMethod(@NotNull PsiMethod method, RefClass refClass) {
        String name;
        if (method == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(11);
        }
        if (!"readResolve".equals(name = method.getName())) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 0) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(method.getReturnType(), "java.lang.Object")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        return aClass2 == null || UnusedDeclarationInspectionBase.isSerializable(aClass2, refClass);
    }

    private static boolean equalsToText(PsiType type2, String text2) {
        return type2 != null && type2.equalsToText(text2);
    }

    private static boolean isSerializable(PsiClass aClass2, @Nullable RefClass refClass) {
        PsiClass serializableClass = JavaPsiFacade.getInstance(aClass2.getProject()).findClass("java.io.Serializable", aClass2.getResolveScope());
        return serializableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass2, refClass, serializableClass);
    }

    private static boolean isExternalizable(@NotNull PsiClass aClass2, RefClass refClass) {
        if (aClass2 == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(12);
        }
        GlobalSearchScope scope = aClass2.getResolveScope();
        PsiClass externalizableClass = JavaPsiFacade.getInstance(aClass2.getProject()).findClass("java.io.Externalizable", scope);
        return externalizableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass2, refClass, externalizableClass);
    }

    private static boolean isSerializable(PsiClass aClass2, RefClass refClass, PsiClass serializableClass) {
        if (aClass2 == null) {
            return false;
        }
        if (aClass2.isInheritor(serializableClass, true)) {
            return true;
        }
        if (refClass != null) {
            Set<RefClass> subClasses = refClass.getSubClasses();
            for (RefClass subClass : subClasses) {
                if (!UnusedDeclarationInspectionBase.isSerializable(subClass.getElement(), subClass, serializableClass)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void runInspection(final @NotNull AnalysisScope scope, @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(13);
        }
        if (manager == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(14);
        }
        if (globalContext == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(15);
        }
        if (problemDescriptionsProcessor == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(16);
        }
        globalContext.getRefManager().iterate(new RefJavaVisitor(){

            @Override
            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof RefElementImpl) {
                    RefElementImpl refElement = (RefElementImpl)refEntity;
                    if (!refElement.isSuspicious()) {
                        return;
                    }
                    PsiFile file2 = refElement.getContainingFile();
                    if (file2 == null) {
                        return;
                    }
                    boolean isSuppressed = refElement.isSuppressed(UnusedDeclarationInspectionBase.this.getShortName(), UnusedDeclarationInspectionBase.ALTERNATIVE_ID);
                    if (!(!isSuppressed && ((GlobalInspectionContextBase)globalContext).isToCheckFile(file2, UnusedDeclarationInspectionBase.this) || !isSuppressed && scope.contains(file2))) {
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refElement, false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$1", "visitElement"));
            }
        });
        if (this.isAddNonJavaUsedEnabled()) {
            this.checkForReachableRefs(globalContext);
            final StrictUnreferencedFilter strictUnreferencedFilter = new StrictUnreferencedFilter(this, globalContext);
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    RefManager refManager = globalContext.getRefManager();
                    final PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance(refManager.getProject());
                    refManager.iterate(new RefJavaVisitor(){

                        @Override
                        public void visitElement(@NotNull RefEntity refEntity) {
                            RefMethod refMethod;
                            if (refEntity == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (refEntity instanceof RefClass && strictUnreferencedFilter.accepts((RefClass)refEntity)) {
                                this.findExternalClassReferences((RefClass)refEntity);
                            } else if (refEntity instanceof RefMethod && (refMethod = (RefMethod)refEntity).isConstructor() && strictUnreferencedFilter.accepts(refMethod)) {
                                this.findExternalClassReferences(refMethod.getOwnerClass());
                            }
                        }

                        private void findExternalClassReferences(RefClass refElement) {
                            String qualifiedName2;
                            PsiClass psiClass = refElement.getElement();
                            String string = qualifiedName2 = psiClass != null ? psiClass.getQualifiedName() : null;
                            if (qualifiedName2 != null) {
                                GlobalSearchScope projectScope = GlobalSearchScope.projectScope(globalContext.getProject());
                                PsiNonJavaFileReferenceProcessor processor = (file2, startOffset, endOffset) -> {
                                    if (globalContext == null) {
                                        1.$$$reportNull$$$0(1);
                                    }
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refElement, false);
                                    return false;
                                };
                                DelegatingGlobalSearchScope globalSearchScope = new DelegatingGlobalSearchScope(projectScope){

                                    @Override
                                    public boolean contains(@NotNull VirtualFile file2) {
                                        if (file2 == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        return file2.getFileType() != JavaFileType.INSTANCE && super.contains(file2);
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2$1$1", "contains"));
                                    }
                                };
                                helper.processUsagesInNonJavaFiles(qualifiedName2, processor, globalSearchScope);
                                for (RefElement element : refElement.getInReferences()) {
                                    if (element instanceof RefJavaElement) continue;
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refElement, false);
                                }
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refEntity";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "globalContext";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitElement";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "lambda$findExternalClassReferences$0";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            }, null);
        }
        this.myProcessedSuspicious = new HashSet<RefElement>();
        this.myPhase = 1;
    }

    public boolean isEntryPoint(@NotNull RefElement owner) {
        EntryPointsManager entryPointsManager;
        PsiElement element;
        if (owner == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(17);
        }
        if (RefUtil.isImplicitUsage(element = owner.getElement())) {
            return true;
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance(element.getProject())).isEntryPoint(element)) {
            return true;
        }
        if (element != null) {
            for (EntryPoint extension : this.myExtensions) {
                if (!extension.isSelected() || !extension.isEntryPoint(owner, element)) continue;
                return true;
            }
            if (this.isAddMainsEnabled() && owner instanceof RefMethod && ((RefMethod)owner).isAppMain()) {
                return true;
            }
            if (owner instanceof RefClass && (this.isAddAppletEnabled() && ((RefClass)owner).isApplet() || this.isAddServletEnabled() && ((RefClass)owner).isServlet())) {
                return true;
            }
        }
        return false;
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        EntryPointsManager entryPointsManager;
        if (element == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(18);
        }
        Project project = element.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        if (element instanceof PsiMethod && this.isAddMainsEnabled() && PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)element)) {
            return true;
        }
        if (element instanceof PsiClass) {
            PsiClass aClass2 = (PsiClass)element;
            PsiClass applet = psiFacade.findClass("java.applet.Applet", GlobalSearchScope.allScope(project));
            if (this.isAddAppletEnabled() && applet != null && aClass2.isInheritor(applet, true)) {
                return true;
            }
            PsiClass servlet = psiFacade.findClass("javax.servlet.Servlet", GlobalSearchScope.allScope(project));
            if (this.isAddServletEnabled() && servlet != null && aClass2.isInheritor(servlet, true)) {
                return true;
            }
            if (this.isAddMainsEnabled() && UnusedDeclarationInspectionBase.hasMainMethodDeep(aClass2)) {
                return true;
            }
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance(project)).isEntryPoint(element)) {
            return true;
        }
        for (EntryPoint extension : this.myExtensions) {
            if (!extension.isSelected() || !extension.isEntryPoint(element)) continue;
            return true;
        }
        return RefUtil.isImplicitUsage(element);
    }

    private static boolean hasMainMethodDeep(PsiClass aClass2) {
        if (PsiMethodUtil.hasMainMethod(aClass2)) {
            return true;
        }
        for (PsiClass innerClass : aClass2.getInnerClasses()) {
            if (!innerClass.hasModifierProperty("static") || !PsiMethodUtil.hasMainMethod(innerClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isGlobalEnabledInEditor() {
        return this.myEnabledInEditor;
    }

    @NotNull
    public static UnusedDeclarationInspectionBase findUnusedDeclarationInspection(@NotNull PsiElement element) {
        InspectionProfileImpl profile2;
        UnusedDeclarationInspectionBase tool;
        if (element == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(19);
        }
        UnusedDeclarationInspectionBase unusedDeclarationInspectionBase = (tool = (UnusedDeclarationInspectionBase)(profile2 = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile()).getUnwrappedTool(SHORT_NAME, element)) == null ? new UnusedDeclarationInspectionBase() : tool;
        if (unusedDeclarationInspectionBase == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(20);
        }
        return unusedDeclarationInspectionBase;
    }

    public static boolean isDeclaredAsEntryPoint(@NotNull PsiElement method) {
        if (method == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(21);
        }
        return UnusedDeclarationInspectionBase.findUnusedDeclarationInspection(method).isEntryPoint(method);
    }

    @Override
    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(22);
        }
        if (globalContext == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(23);
        }
        if (problemDescriptionsProcessor == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(24);
        }
        this.checkForReachableRefs(globalContext);
        final RefUnreachableFilter filter2 = this.myPhase == 1 ? new StrictUnreferencedFilter(this, globalContext) : new RefUnreachableFilter(this, globalContext);
        LOG.assertTrue(this.myProcessedSuspicious != null, "phase: " + this.myPhase);
        final boolean[] requestAdded = new boolean[]{false};
        globalContext.getRefManager().iterate(new RefJavaVisitor(){

            @Override
            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                if (refEntity instanceof RefClass && ((RefClass)refEntity).isAnonymous()) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (filter2.accepts(refElement) && !UnusedDeclarationInspectionBase.this.myProcessedSuspicious.contains(refElement)) {
                    refEntity.accept(new RefJavaVisitor(){

                        @Override
                        public void visitField(@NotNull RefField refField) {
                            if (refField == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refField);
                            PsiField psiField = refField.getElement();
                            if (psiField != null && UnusedDeclarationInspectionBase.isSerializationImplicitlyUsedField(psiField)) {
                                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refField, false);
                            } else {
                                globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT).enqueueFieldUsagesProcessor(refField, psiReference -> {
                                    if (globalContext == null) {
                                        1.$$$reportNull$$$0(7);
                                    }
                                    if (refField == null) {
                                        1.$$$reportNull$$$0(8);
                                    }
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refField, false);
                                    return false;
                                });
                                requestAdded[0] = true;
                            }
                        }

                        @Override
                        public void visitMethod(@NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refMethod);
                            if (refMethod instanceof RefImplicitConstructor) {
                                this.visitClass(refMethod.getOwnerClass());
                            } else {
                                PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
                                if (psiMethod != null && UnusedDeclarationInspectionBase.isSerializablePatternMethod(psiMethod, refMethod.getOwnerClass())) {
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refMethod, false);
                                } else if (!refMethod.isExternalOverride() && !"private".equals(refMethod.getAccessModifier())) {
                                    for (RefMethod derivedMethod : refMethod.getDerivedMethods()) {
                                        UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(derivedMethod);
                                    }
                                    UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refMethod);
                                    requestAdded[0] = true;
                                }
                            }
                        }

                        @Override
                        public void visitClass(@NotNull RefClass refClass) {
                            if (refClass == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refClass);
                            if (!refClass.isAnonymous()) {
                                globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT).enqueueDerivedClassesProcessor(refClass, inheritor -> {
                                    if (globalContext == null) {
                                        1.$$$reportNull$$$0(5);
                                    }
                                    if (refClass == null) {
                                        1.$$$reportNull$$$0(6);
                                    }
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refClass, false);
                                    return false;
                                });
                                globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT).enqueueClassUsagesProcessor(refClass, psiReference -> {
                                    if (globalContext == null) {
                                        1.$$$reportNull$$$0(3);
                                    }
                                    if (refClass == null) {
                                        1.$$$reportNull$$$0(4);
                                    }
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refClass, false);
                                    return false;
                                });
                                requestAdded[0] = true;
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refField";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refMethod";
                                    break;
                                }
                                case 2: 
                                case 4: 
                                case 6: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "refClass";
                                    break;
                                }
                                case 3: 
                                case 5: 
                                case 7: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "globalContext";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitField";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitMethod";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitClass";
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "lambda$visitClass$2";
                                    break;
                                }
                                case 5: 
                                case 6: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "lambda$visitClass$1";
                                    break;
                                }
                                case 7: 
                                case 8: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "lambda$visitField$0";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3", "visitElement"));
            }
        });
        if (!requestAdded[0]) {
            if (this.myPhase == 2) {
                this.myProcessedSuspicious = null;
                return false;
            }
            this.myPhase = 2;
        }
        return true;
    }

    private static boolean isSerializablePatternMethod(@NotNull PsiMethod psiMethod, RefClass refClass) {
        if (psiMethod == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(25);
        }
        return UnusedDeclarationInspectionBase.isReadObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isReadResolveMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteReplaceMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isExternalizableNoParameterConstructor(psiMethod, refClass);
    }

    private static void enqueueMethodUsages(GlobalInspectionContext globalContext, RefMethod refMethod) {
        if (refMethod.getSuperMethods().isEmpty()) {
            globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT).enqueueMethodUsagesProcessor(refMethod, psiReference -> {
                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refMethod, false);
                return false;
            });
        } else {
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refSuper);
            }
        }
    }

    @Override
    @Nullable
    public JobDescriptor[] getAdditionalJobs(GlobalInspectionContext context) {
        return new JobDescriptor[]{context.getStdJobDescriptors().BUILD_GRAPH, context.getStdJobDescriptors().FIND_EXTERNAL_USAGES};
    }

    void checkForReachableRefs(final @NotNull GlobalInspectionContext context) {
        if (context == null) {
            UnusedDeclarationInspectionBase.$$$reportNull$$$0(26);
        }
        CodeScanner codeScanner = new CodeScanner();
        context.getRefManager().iterate(new RefJavaVisitor(){

            @Override
            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof RefJavaElementImpl) {
                    RefJavaElementImpl refElement = (RefJavaElementImpl)refEntity;
                    if (!((GlobalInspectionContextBase)context).isToCheckMember(refElement, UnusedDeclarationInspectionBase.this)) {
                        return;
                    }
                    refElement.setReachable(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$4", "visitElement"));
            }
        });
        for (RefElement entry : UnusedDeclarationInspectionBase.getEntryPointsManager(context).getEntryPoints()) {
            entry.accept(codeScanner);
        }
        while (codeScanner.newlyInstantiatedClassesCount() != 0) {
            codeScanner.cleanInstantiatedClassesCount();
            codeScanner.processDelayedMethods();
        }
    }

    private static EntryPointsManager getEntryPointsManager(GlobalInspectionContext context) {
        return context.getExtension(GlobalJavaInspectionContext.CONTEXT).getEntryPointsManager(context.getRefManager());
    }

    public List<EntryPoint> getExtensions() {
        return this.myExtensions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedLocalInspectionTool";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnusedDeclarationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExternalizableNoParameterConstructor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSerializationImplicitlyUsedField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWriteObjectMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReadObjectMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWriteReplaceMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReadResolveMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExternalizable";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findUnusedDeclarationInspection";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredAsEntryPoint";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isSerializablePatternMethod";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkForReachableRefs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CodeScanner
    extends RefJavaVisitor {
        private final Map<RefClass, Set<RefMethod>> myClassIDtoMethods = new HashMap<RefClass, Set<RefMethod>>();
        private final Set<RefClass> myInstantiatedClasses = new HashSet<RefClass>();
        private int myInstantiatedClassesCount;
        private final Set<RefMethod> myProcessedMethods = new HashSet<RefMethod>();

        private CodeScanner() {
        }

        @Override
        public void visitMethod(@NotNull RefMethod method) {
            if (method == null) {
                CodeScanner.$$$reportNull$$$0(0);
            }
            if (!this.myProcessedMethods.contains(method)) {
                if (method.isStatic() || method.isConstructor()) {
                    if (method.isConstructor()) {
                        this.addInstantiatedClass(method.getOwnerClass());
                    } else {
                        ((RefClassImpl)method.getOwnerClass()).setReachable(true);
                    }
                    this.myProcessedMethods.add(method);
                    this.makeContentReachable((RefJavaElementImpl)((Object)method));
                    this.makeClassInitializersReachable(method.getOwnerClass());
                } else {
                    if (this.isClassInstantiated(method.getOwnerClass())) {
                        this.myProcessedMethods.add(method);
                        this.makeContentReachable((RefJavaElementImpl)((Object)method));
                    } else {
                        this.addDelayedMethod(method);
                    }
                    for (RefMethod refSub : method.getDerivedMethods()) {
                        this.visitMethod(refSub);
                    }
                }
            }
        }

        @Override
        public void visitClass(@NotNull RefClass refClass) {
            if (refClass == null) {
                CodeScanner.$$$reportNull$$$0(1);
            }
            boolean alreadyActive = refClass.isReachable();
            ((RefClassImpl)refClass).setReachable(true);
            if (!alreadyActive) {
                this.makeClassInitializersReachable(refClass);
            }
            this.addInstantiatedClass(refClass);
        }

        @Override
        public void visitField(@NotNull RefField field) {
            if (field == null) {
                CodeScanner.$$$reportNull$$$0(2);
            }
            if (!field.isReachable()) {
                this.makeContentReachable((RefJavaElementImpl)((Object)field));
                this.makeClassInitializersReachable(field.getOwnerClass());
            }
        }

        private void addInstantiatedClass(RefClass refClass) {
            if (this.myInstantiatedClasses.add(refClass)) {
                ((RefClassImpl)refClass).setReachable(true);
                ++this.myInstantiatedClassesCount;
                List<RefMethod> refMethods = refClass.getLibraryMethods();
                for (RefMethod refMethod : refMethods) {
                    refMethod.accept(this);
                }
                for (RefClass baseClass : refClass.getBaseClasses()) {
                    this.addInstantiatedClass(baseClass);
                }
            }
        }

        private void makeContentReachable(RefJavaElementImpl refElement) {
            refElement.setReachable(true);
            for (RefElement refCallee : refElement.getOutReferences()) {
                refCallee.accept(this);
            }
        }

        private void makeClassInitializersReachable(RefClass refClass) {
            for (RefElement refCallee : refClass.getOutReferences()) {
                refCallee.accept(this);
            }
        }

        private void addDelayedMethod(RefMethod refMethod) {
            Set<RefMethod> methods2 = this.myClassIDtoMethods.get(refMethod.getOwnerClass());
            if (methods2 == null) {
                methods2 = new HashSet<RefMethod>();
                this.myClassIDtoMethods.put(refMethod.getOwnerClass(), methods2);
            }
            methods2.add(refMethod);
        }

        private boolean isClassInstantiated(RefClass refClass) {
            return this.myInstantiatedClasses.contains(refClass);
        }

        private int newlyInstantiatedClassesCount() {
            return this.myInstantiatedClassesCount;
        }

        private void cleanInstantiatedClassesCount() {
            this.myInstantiatedClassesCount = 0;
        }

        private void processDelayedMethods() {
            RefClass[] instClasses;
            for (RefClass refClass : instClasses = this.myInstantiatedClasses.toArray(new RefClass[this.myInstantiatedClasses.size()])) {
                RefMethod[] arMethods;
                Set<RefMethod> methods2;
                if (!this.isClassInstantiated(refClass) || (methods2 = this.myClassIDtoMethods.get(refClass)) == null) continue;
                for (RefMethod arMethod : arMethods = methods2.toArray(new RefMethod[methods2.size()])) {
                    arMethod.accept(this);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StrictUnreferencedFilter
    extends UnreferencedFilter {
        private StrictUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContext context) {
            if (tool == null) {
                StrictUnreferencedFilter.$$$reportNull$$$0(0);
            }
            if (context == null) {
                StrictUnreferencedFilter.$$$reportNull$$$0(1);
            }
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            int problemCount;
            if (refElement == null) {
                StrictUnreferencedFilter.$$$reportNull$$$0(2);
            }
            if ((problemCount = super.getElementProblemCount(refElement)) > -1) {
                return problemCount;
            }
            return refElement.isReferenced() ? 0 : 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementProblemCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

