/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java15api;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java15APIUsageInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    public static final String SHORT_NAME = "Since15";
    private static final String EFFECTIVE_LL = "effectiveLL";
    private static final Map<LanguageLevel, Reference<Set<String>>> ourForbiddenAPI = ContainerUtil.newEnumMap(LanguageLevel.class);
    private static final Set<String> ourIgnored16ClassesAPI = new THashSet<String>(10);
    private static final Map<LanguageLevel, String> ourPresentableShortMessage = ContainerUtil.newEnumMap(LanguageLevel.class);
    private static final LanguageLevel ourHighestKnownLanguage = LanguageLevel.JDK_1_9;
    private static final Set<String> ourGenerifiedClasses;
    private static final Set<String> ourDefaultMethods;
    LanguageLevel myEffectiveLanguageLevel;

    @Nullable
    private static Set<String> getForbiddenApi(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(0);
        }
        if (!ourPresentableShortMessage.containsKey((Object)languageLevel)) {
            return null;
        }
        Reference<Set<String>> ref = ourForbiddenAPI.get((Object)languageLevel);
        Set<String> result2 = SoftReference.dereference(ref);
        if (result2 == null) {
            result2 = new THashSet<String>(1000);
            Java15APIUsageInspectionBase.loadForbiddenApi("api" + Java15APIUsageInspectionBase.getShortName(languageLevel) + ".txt", result2);
            ourForbiddenAPI.put(languageLevel, new SoftReference<Set<String>>(result2));
        }
        return result2;
    }

    private static void loadForbiddenApi(String fileName, Set<String> set) {
        URL resource = Java15APIUsageInspectionBase.class.getResource(fileName);
        if (resource == null) {
            Logger.getInstance(Java15APIUsageInspectionBase.class).warn("not found: " + fileName);
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), CharsetToolkit.UTF8_CHARSET));){
            set.addAll(FileUtil.loadLines(reader));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.1.5.display.name", new Object[0]);
        if (string == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(3);
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        Element element;
        if (node == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(5);
        }
        if ((element = node.getChild(EFFECTIVE_LL)) != null) {
            this.myEffectiveLanguageLevel = LanguageLevel.valueOf(element.getAttributeValue("value"));
        }
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(6);
        }
        if (this.myEffectiveLanguageLevel != null) {
            Element llElement = new Element(EFFECTIVE_LL);
            llElement.setAttribute("value", this.myEffectiveLanguageLevel.toString());
            node.addContent(llElement);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(7);
        }
        MyVisitor myVisitor = new MyVisitor(holder, isOnTheFly);
        if (myVisitor == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(8);
        }
        return myVisitor;
    }

    private static boolean isInProject(PsiElement elt) {
        return elt.getManager().isInProject(elt);
    }

    public static String getShortName(LanguageLevel languageLevel) {
        return ourPresentableShortMessage.get((Object)languageLevel);
    }

    private static String getJdkName(LanguageLevel languageLevel) {
        String presentableText = languageLevel.getPresentableText();
        return presentableText.substring(0, presentableText.indexOf(32));
    }

    public static LanguageLevel getLastIncompatibleLanguageLevel(@NotNull PsiMember member, @NotNull LanguageLevel languageLevel) {
        LanguageLevel lastIncompatibleLanguageLevel;
        if (member == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(9);
        }
        if (languageLevel == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(10);
        }
        if (member instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (member instanceof PsiClass && !(member.getParent() instanceof PsiClass) && !(member.getParent() instanceof PsiFile)) {
            return null;
        }
        Set<String> forbiddenApi = Java15APIUsageInspectionBase.getForbiddenApi(languageLevel);
        String signature2 = Java15APIUsageInspectionBase.getSignature(member);
        if (forbiddenApi != null && signature2 != null && (lastIncompatibleLanguageLevel = Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevelForSignature(signature2, languageLevel, forbiddenApi)) != null) {
            return lastIncompatibleLanguageLevel;
        }
        return containingClass != null ? Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevel(containingClass, languageLevel) : null;
    }

    private static LanguageLevel getLastIncompatibleLanguageLevelForSignature(@NotNull String signature2, @NotNull LanguageLevel languageLevel, @NotNull Set<String> forbiddenApi) {
        if (signature2 == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(11);
        }
        if (languageLevel == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(12);
        }
        if (forbiddenApi == null) {
            Java15APIUsageInspectionBase.$$$reportNull$$$0(13);
        }
        if (forbiddenApi.contains(signature2)) {
            return languageLevel;
        }
        if (languageLevel.compareTo(ourHighestKnownLanguage) == 0) {
            return null;
        }
        LanguageLevel nextLanguageLevel = LanguageLevel.values()[languageLevel.ordinal() + 1];
        Set<String> nextForbiddenApi = Java15APIUsageInspectionBase.getForbiddenApi(nextLanguageLevel);
        return nextForbiddenApi != null ? Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevelForSignature(signature2, nextLanguageLevel, nextForbiddenApi) : null;
    }

    @Nullable
    public static String getSignature(@Nullable PsiMember member) {
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        if (member instanceof PsiField) {
            String containingClass = Java15APIUsageInspectionBase.getSignature(member.getContainingClass());
            return containingClass == null ? null : containingClass + "#" + member.getName();
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            String containingClass = Java15APIUsageInspectionBase.getSignature(member.getContainingClass());
            if (containingClass == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(containingClass);
            buf.append('#');
            buf.append(method.getName());
            buf.append('(');
            for (PsiType type2 : method.getSignature(PsiSubstitutor.EMPTY).getParameterTypes()) {
                buf.append(type2.getCanonicalText());
                buf.append(";");
            }
            buf.append(')');
            return buf.toString();
        }
        return null;
    }

    static {
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_3, "1.4");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_4, "1.5");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_5, "1.6");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_6, "1.7");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_7, "1.8");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_8, "1.9");
        Java15APIUsageInspectionBase.loadForbiddenApi("ignore16List.txt", ourIgnored16ClassesAPI);
        ourGenerifiedClasses = new HashSet<String>();
        ourGenerifiedClasses.add("javax.swing.JComboBox");
        ourGenerifiedClasses.add("javax.swing.ListModel");
        ourGenerifiedClasses.add("javax.swing.JList");
        ourDefaultMethods = new HashSet<String>();
        ourDefaultMethods.add("java.util.Iterator#remove()");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forbiddenApi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getForbiddenApi";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLastIncompatibleLanguageLevel";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLastIncompatibleLanguageLevelForSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myOnTheFly;

        public MyVisitor(ProblemsHolder holder, boolean onTheFly) {
            this.myHolder = holder;
            this.myOnTheFly = onTheFly;
        }

        @Override
        public void visitDocComment(PsiDocComment comment) {
        }

        @Override
        public void visitClass(PsiClass aClass2) {
            if (!aClass2.hasModifierProperty("abstract") && !(aClass2 instanceof PsiTypeParameter)) {
                JavaSdkVersion version;
                LanguageLevel effectiveLanguageLevel;
                Module module2 = ModuleUtilCore.findModuleForPsiElement(aClass2);
                LanguageLevel languageLevel = effectiveLanguageLevel = module2 != null ? this.getEffectiveLanguageLevel(module2) : null;
                if (effectiveLanguageLevel != null && !effectiveLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (version = JavaVersionService.getInstance().getJavaSdkVersion(aClass2)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_8)) {
                    ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>();
                    for (HierarchicalMethodSignature methodSignature : aClass2.getVisibleSignatures()) {
                        PsiMethod method = methodSignature.getMethod();
                        if (!ourDefaultMethods.contains(Java15APIUsageInspectionBase.getSignature(method))) continue;
                        methods2.add(method);
                    }
                    if (!methods2.isEmpty()) {
                        PsiElement element2Highlight = aClass2.getNameIdentifier();
                        if (element2Highlight == null) {
                            element2Highlight = aClass2;
                        }
                        this.myHolder.registerProblem(element2Highlight, methods2.size() == 1 ? InspectionsBundle.message("inspection.1.8.problem.single.descriptor", ((PsiMethod)methods2.get(0)).getName(), Java15APIUsageInspectionBase.getJdkName(effectiveLanguageLevel)) : InspectionsBundle.message("inspection.1.8.problem.descriptor", methods2.size(), Java15APIUsageInspectionBase.getJdkName(effectiveLanguageLevel)), QuickFixFactory.getInstance().createImplementMethodsFix(aClass2));
                    }
                }
            }
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement(expression2);
        }

        @Override
        public void visitNameValuePair(PsiNameValuePair pair) {
            LanguageLevel languageLevel;
            LanguageLevel sinceLanguageLevel;
            Module module2;
            PsiElement resolve2;
            super.visitNameValuePair(pair);
            PsiReference reference = pair.getReference();
            if (reference != null && (resolve2 = reference.resolve()) instanceof PsiCompiledElement && resolve2 instanceof PsiAnnotationMethod && (module2 = ModuleUtilCore.findModuleForPsiElement(pair)) != null && (sinceLanguageLevel = Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevel((PsiMember)resolve2, languageLevel = this.getEffectiveLanguageLevel(module2))) != null) {
                this.registerError(ObjectUtils.notNull(pair.getNameIdentifier(), pair), sinceLanguageLevel);
            }
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            Module module2;
            super.visitReferenceElement(reference);
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PsiCompiledElement && resolved instanceof PsiMember && (module2 = ModuleUtilCore.findModuleForPsiElement(reference.getElement())) != null) {
                PsiReferenceParameterList parameterList;
                LanguageLevel languageLevel = this.getEffectiveLanguageLevel(module2);
                LanguageLevel sinceLanguageLevel = Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevel((PsiMember)resolved, languageLevel);
                if (sinceLanguageLevel != null) {
                    PsiClass psiClass = null;
                    PsiElement qualifier = reference.getQualifier();
                    if (qualifier != null) {
                        if (qualifier instanceof PsiExpression) {
                            psiClass = PsiUtil.resolveClassInType(((PsiExpression)qualifier).getType());
                        }
                    } else {
                        psiClass = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
                    }
                    if (psiClass != null) {
                        if (this.isIgnored(psiClass)) {
                            return;
                        }
                        for (PsiClass superClass : psiClass.getSupers()) {
                            if (!this.isIgnored(superClass)) continue;
                            return;
                        }
                    }
                    this.registerError(reference, sinceLanguageLevel);
                } else if (resolved instanceof PsiClass && Java15APIUsageInspectionBase.isInProject(reference) && !languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && (parameterList = reference.getParameterList()) != null && parameterList.getTypeParameterElements().length > 0) {
                    for (String generifiedClass : ourGenerifiedClasses) {
                        if (!InheritanceUtil.isInheritor((PsiClass)resolved, generifiedClass) || this.isRawInheritance(generifiedClass, (PsiClass)resolved, new HashSet<PsiClass>())) continue;
                        String message = InspectionsBundle.message("inspection.1.7.problem.descriptor", Java15APIUsageInspectionBase.getJdkName(languageLevel));
                        this.myHolder.registerProblem((PsiElement)reference, message, new LocalQuickFix[0]);
                        break;
                    }
                }
            }
        }

        private boolean isRawInheritance(String generifiedClassQName, PsiClass currentClass, Set<PsiClass> visited2) {
            for (PsiClassType classType : currentClass.getSuperTypes()) {
                if (classType.isRaw()) {
                    return true;
                }
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass superClass = resolveResult.getElement();
                if (!visited2.add(superClass) || !InheritanceUtil.isInheritor(superClass, generifiedClassQName) || !this.isRawInheritance(generifiedClassQName, superClass, visited2)) continue;
                return true;
            }
            return false;
        }

        private boolean isIgnored(PsiClass psiClass) {
            String qualifiedName2 = psiClass.getQualifiedName();
            return qualifiedName2 != null && ourIgnored16ClassesAPI.contains(qualifiedName2);
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiMethod constructor = expression2.resolveConstructor();
            Module module2 = ModuleUtilCore.findModuleForPsiElement(expression2);
            if (module2 != null) {
                LanguageLevel sinceLanguageLevel;
                LanguageLevel languageLevel = this.getEffectiveLanguageLevel(module2);
                if (constructor instanceof PsiCompiledElement && (sinceLanguageLevel = Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevel(constructor, languageLevel)) != null) {
                    this.registerError(expression2.getClassReference(), sinceLanguageLevel);
                }
            }
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiAnnotation annotation2;
            super.visitMethod(method);
            PsiAnnotation psiAnnotation = annotation2 = !method.isConstructor() ? AnnotationUtil.findAnnotation((PsiModifierListOwner)method, "java.lang.Override") : null;
            if (annotation2 != null) {
                Module module2 = ModuleUtilCore.findModuleForPsiElement(annotation2);
                LanguageLevel sinceLanguageLevel = null;
                if (module2 != null) {
                    PsiMethod[] methods2;
                    LanguageLevel languageLevel = this.getEffectiveLanguageLevel(module2);
                    for (PsiMethod superMethod : methods2 = method.findSuperMethods()) {
                        if (superMethod instanceof PsiCompiledElement) {
                            sinceLanguageLevel = Java15APIUsageInspectionBase.getLastIncompatibleLanguageLevel(superMethod, languageLevel);
                            if (sinceLanguageLevel != null) continue;
                            return;
                        }
                        return;
                    }
                    if (methods2.length > 0) {
                        this.registerError(annotation2.getNameReferenceElement(), sinceLanguageLevel);
                    }
                }
            }
        }

        private LanguageLevel getEffectiveLanguageLevel(Module module2) {
            if (Java15APIUsageInspectionBase.this.myEffectiveLanguageLevel != null) {
                return Java15APIUsageInspectionBase.this.myEffectiveLanguageLevel;
            }
            return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel(module2);
        }

        private void registerError(PsiElement reference, LanguageLevel api) {
            if (reference != null && Java15APIUsageInspectionBase.isInProject(reference)) {
                LocalQuickFix[] localQuickFixArray;
                String string = InspectionsBundle.message("inspection.1.5.problem.descriptor", Java15APIUsageInspectionBase.getShortName(api));
                if (this.myOnTheFly) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = (LocalQuickFix)((Object)QuickFixFactory.getInstance().createIncreaseLanguageLevelFix(LanguageLevel.values()[api.ordinal() + 1]));
                } else {
                    localQuickFixArray = null;
                }
                this.myHolder.registerProblem(reference, string, localQuickFixArray);
            }
        }
    }
}

